/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.modelexplorer.handlers;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.modelexplorer.handlers.AbstractTableModelExplorerHandler;
import org.eclipse.papyrus.infra.table.modelexplorer.messages.Messages;

public class DuplicateTableHandler
extends AbstractTableModelExplorerHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        IPageManager pageManager = this.getPageManager();
        List<PapyrusTableInstance> tables = this.getSelectedTables();
        if (editingDomain != null && pageManager != null && !tables.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (PapyrusTableInstance table : tables) {
                PapyrusTableInstance newTable = (PapyrusTableInstance)EcoreUtil.copy((EObject)table);
                newTable.setName(String.valueOf(Messages.DuplicateTableHandler_CopyOf) + newTable.getName());
                AddCommand addGmfDiagramCmd = new AddCommand((EditingDomain)editingDomain, table.eResource().getContents(), (Object)newTable);
                RecordingCommand sashOpenCmd = new RecordingCommand(editingDomain, "Open duplicated table"){

                    protected void doExecute() {
                        pageManager.openPage((Object)newTable);
                    }
                };
                command.append((Command)addGmfDiagramCmd);
                command.append((Command)sashOpenCmd);
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

