/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.service;

import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.Activator;
import org.eclipse.papyrus.infra.services.edit.internal.ElementEditServiceProvider;
import org.eclipse.papyrus.infra.services.edit.messages.Messages;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditServiceProvider;

public class ElementEditServiceUtils {
    public static IElementEditService getCommandProvider(Object objectToEdit) {
        try {
            return ElementEditServiceUtils.getEditServiceProvider().getEditService(objectToEdit);
        }
        catch (ServiceException e) {
            Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
        }
        catch (NullPointerException e) {
            Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
        }
        return null;
    }

    public static IElementEditServiceProvider getEditServiceProvider() {
        try {
            return ElementEditServiceUtils.getEditServiceProviderFromElementTypeRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.ElementEditServiceUtils_UnableToFindServiceProvider, (Throwable)e);
            return null;
        }
    }

    protected static IElementEditServiceProvider getEditServiceProviderFromElementTypeRegistry() throws ServiceException {
        return ElementEditServiceProvider.getInstance();
    }
}

