/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;

public class CloseHandler
extends AbstractModelExplorerHandler
implements IExecutableExtension {
    public static final String PARAMETER_ALL = "all";
    public static final String PARAMETER_SELECTION = "selection";
    protected String parameter = null;
    protected String parameterID = "close_parameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain;
        IPageManager pageMngr;
        try {
            ServicesRegistry registry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            pageMngr = (IPageManager)registry.getService(IPageManager.class);
            editingDomain = (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException ex) {
            throw new ExecutionException(ex.getMessage(), (Throwable)ex);
        }
        if (PARAMETER_ALL.equals(this.parameter)) {
            boolean atLeastOneOpenedPage = false;
            for (Object page : pageMngr.allPages()) {
                if (!pageMngr.isOpen(page)) continue;
                atLeastOneOpenedPage = true;
                break;
            }
            if (atLeastOneOpenedPage) {
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Close all pages"){

                    protected void doExecute() {
                        pageMngr.closeAllOpenedPages();
                    }
                });
            }
            return null;
        }
        List<EObject> selectedProperties = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selectedProperties == null) {
            return null;
        }
        final LinkedList<EObject> pagesToClose = new LinkedList<EObject>();
        for (EObject selected : selectedProperties) {
            if (!pageMngr.isOpen((Object)selected)) continue;
            pagesToClose.add(selected);
        }
        if (pagesToClose.isEmpty()) {
            return null;
        }
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Close pages"){

            protected void doExecute() {
                for (EObject page : pagesToClose) {
                    pageMngr.closePage((Object)page);
                }
            }
        });
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable && this.parameterID != null) {
            this.parameter = (String)((Hashtable)data).get(this.parameterID);
        }
    }
}

