/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;

public class OpenHandler
extends AbstractModelExplorerHandler
implements IExecutableExtension {
    public static final String IS_DUPLICATE_EDITOR_ALLOWED_PARAMETER = "isDuplicateEditorAllowed";
    protected boolean isDuplicateDiagramAllowed = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IPageManager pageMngr = this.getPageManager();
        if (pageMngr == null) {
            return null;
        }
        List<EObject> selectedProperties = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selectedProperties == null) {
            return null;
        }
        final LinkedList<EObject> pagesToOpen = new LinkedList<EObject>();
        LinkedList<EObject> pagesToSelect = new LinkedList<EObject>();
        for (EObject selected : selectedProperties) {
            if (!pageMngr.isOpen((Object)selected) || this.isDuplicateDiagramAllowed) {
                pagesToOpen.add(selected);
                continue;
            }
            pagesToSelect.add(selected);
        }
        if (!pagesToOpen.isEmpty()) {
            try {
                TransactionalEditingDomain editingDomain = ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Open pages"){

                    protected void doExecute() {
                        for (EObject page : pagesToOpen) {
                            pageMngr.openPage((Object)page);
                        }
                    }
                });
            }
            catch (ServiceException ex) {
                throw new ExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
        for (EObject page : pagesToSelect) {
            pageMngr.selectPage((Object)page);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof Hashtable)) {
            return;
        }
        Hashtable map = (Hashtable)data;
        try {
            this.isDuplicateDiagramAllowed = Boolean.parseBoolean((String)map.get(IS_DUPLICATE_EDITOR_ALLOWED_PARAMETER));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

