/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.object;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperlinkDocumentShell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkDocument
extends HyperLinkObject {
    public String getHyperlinkDocument() {
        return (String)super.getObject();
    }

    public void setHyperlinkDocument(String object) {
        super.setObject(object);
    }

    @Override
    public void openLink() {
        try {
            String fileName = this.getHyperlinkDocument();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            URI uri = URIUtil.toURI((String)fileName, (boolean)true);
            IFileStore fileStore = EFS.getStore((URI)uri);
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void executeEditMousePressed(List<HyperLinkObject> list, EObject amodel) {
        EditorHyperlinkDocumentShell editor = new EditorHyperlinkDocumentShell();
        editor.setHyperlinkDocument(this);
        editor.open();
        int index = list.indexOf(this);
        list.remove(this);
        list.add(index, editor.getHyperlinkDocument());
    }

    @Override
    public boolean needsOpenCommand() {
        return false;
    }
}

