/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.object;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperLinkEditorShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkEditor
extends HyperLinkObject {
    @Override
    public void openLink() {
        EObject context = EMFHelper.getEObject((Object)this.getObject());
        if (context != null) {
            try {
                IPageManager pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)context);
                Object objectToOpen = this.getObject();
                if (pageManager.isOpen(objectToOpen)) {
                    pageManager.selectPage(objectToOpen);
                } else {
                    pageManager.openPage(objectToOpen);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public void executeEditMousePressed(List<HyperLinkObject> list, EObject amodel) {
        IPageIconsRegistry editorRegistry;
        try {
            editorRegistry = (IPageIconsRegistry)ServiceUtilsForEObject.getInstance().getService(IPageIconsRegistry.class, (Object)amodel);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        EditorHyperLinkEditorShell editor = new EditorHyperLinkEditorShell(editorRegistry, amodel);
        editor.setHyperLinkEditor(this);
        editor.open();
        if (editor.getHyperLinkEditor() != null) {
            int index = list.indexOf(this);
            list.remove(this);
            list.add(index, editor.getHyperLinkEditor());
        }
    }

    @Override
    public boolean needsOpenCommand() {
        EObject context = EMFHelper.getEObject((Object)this.getObject());
        try {
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(context);
            IPageManager pageManager = (IPageManager)registry.getService(IPageManager.class);
            return !pageManager.isOpen((Object)context);
        }
        catch (ServiceException ex) {
            return false;
        }
    }
}

