/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractParametricAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomAction
extends AbstractParametricAction {
    public static final String ZOOM_IN = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomIn;
    public static final String ZOOM_OUT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomOut;
    public static final String ZOOM_100 = DiagramUIMessages.ZoomAction_ZoomCombo_Zoom100;
    public static final String ZOOM_FIT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToFit;
    public static final String ZOOM_WIDTH = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToWidth;
    public static final String ZOOM_HEIGHT = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToHeight;
    public static final String ZOOM_SELECTION = DiagramUIMessages.ZoomAction_ZoomCombo_ZoomToSelection;
    public static final String ZOOM_IN_PARAMETER = "parameter_zoom_in";
    public static final String ZOOM_OUT_PARAMETER = "parameter_zoom_out";
    public static final String ZOOM_100_PARAMETER = "parameter_zoom_100";
    public static final String ZOOM_FIT_PARAMETER = "parameter_zoom_fit";
    public static final String ZOOM_WIDTH_PARAMETER = "parameter_zoom_width";
    public static final String ZOOM_HEIGHT_PARAMETER = "parameter_zoom_height";
    public static final String ZOOM_SELECTION_PARAMETER = "parameter_zoom_selection";

    public ZoomAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        super(parameter, selectedElements);
    }

    @Override
    public boolean isEnabled() {
        return this.isValid(this.getParameter());
    }

    protected boolean isValid(String zoomText) {
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        if (diagramEP == null) {
            return false;
        }
        if (zoomText.equals(ZOOM_IN_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_OUT_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_100_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_FIT_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_WIDTH_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_HEIGHT_PARAMETER)) {
            return true;
        }
        if (zoomText.equals(ZOOM_SELECTION_PARAMETER)) {
            return true;
        }
        StringBuffer buffer = new StringBuffer(zoomText);
        while (buffer.indexOf("%") != -1) {
            int index = buffer.indexOf("%");
            buffer.deleteCharAt(index);
        }
        try {
            Double.parseDouble(buffer.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void doRun(IProgressMonitor progressMonitor) {
        if (this.isEnabled()) {
            String parameter = this.getParameter();
            this.getZoomManager();
            if (parameter.equals(ZOOM_IN_PARAMETER)) {
                this.getZoomManager().zoomIn();
            } else if (parameter.equals(ZOOM_OUT_PARAMETER)) {
                this.getZoomManager().zoomOut();
            } else if (parameter.equals(ZOOM_100_PARAMETER)) {
                this.getZoomManager().setZoom(1.0);
            } else if (parameter.equals(ZOOM_FIT_PARAMETER)) {
                this.zoomToFit(true, true, false);
            } else if (parameter.equals(ZOOM_WIDTH_PARAMETER)) {
                this.zoomToFit(true, false, false);
            } else if (parameter.equals(ZOOM_HEIGHT_PARAMETER)) {
                this.zoomToFit(false, true, false);
            } else if (parameter.equals(ZOOM_SELECTION_PARAMETER)) {
                this.zoomToFit(true, true, true);
            } else {
                this.getZoomManager().setZoomAsText(parameter);
            }
        }
    }

    protected void zoomToFit(boolean onWidth, boolean onHeight, boolean selectionOnly) {
        this.zoomToFit(onWidth, onHeight, selectionOnly, false);
    }

    protected void zoomToFit(boolean onWidth, boolean onHeight, boolean selectionOnly, boolean zoomOutOnly) {
        Iterator<Object> editParts;
        if (selectionOnly) {
            editParts = this.getSelection().iterator();
        } else {
            List allEditParts = this.getDiagramEditPart().getConnections();
            allEditParts.addAll(this.getDiagramEditPart().getChildrenAffectingZoom());
            editParts = allEditParts.iterator();
        }
        Rectangle targetRegion = null;
        while (editParts.hasNext()) {
            IFigure f = ((GraphicalEditPart)editParts.next()).getFigure();
            Rectangle rectangle = targetRegion = targetRegion == null ? f.getBounds().getCopy() : targetRegion.getUnion(f.getBounds());
        }
        if (targetRegion == null) {
            return;
        }
        MapModeUtil.getMapMode((IFigure)this.getDiagramEditPart().getFigure()).LPtoDP(targetRegion);
        Viewport viewport = this.getZoomManager().getViewport();
        float xratio = (float)viewport.getHorizontalRangeModel().getExtent() / (float)targetRegion.width;
        float yratio = (float)viewport.getVerticalRangeModel().getExtent() / (float)targetRegion.height;
        double zoom = 1.0;
        if (onHeight && onWidth) {
            zoom = yratio < xratio ? Math.floor(yratio * 100.0f) : Math.floor(xratio * 100.0f);
        } else if (onWidth) {
            zoom = Math.floor(xratio * 100.0f);
        } else if (onHeight) {
            zoom = Math.floor(yratio * 100.0f);
        }
        if (zoomOutOnly && zoom >= 100.0) {
            zoom = 100.0;
        }
        Point topLeft = targetRegion.getTopLeft();
        zoom = Math.min((double)((int)(this.getZoomManager().getMaxZoom() * 100.0)), Math.max((double)((int)(this.getZoomManager().getMinZoom() * 100.0)), zoom));
        int viewX = Math.round((float)topLeft.x * (float)zoom / 100.0f);
        int viewY = Math.round((float)topLeft.y * (float)zoom / 100.0f);
        this.getZoomManager().setZoom(zoom / 100.0);
        viewport.setHorizontalLocation(viewX);
        viewport.setVerticalLocation(viewY);
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.getDiagramWorkbenchPart().getAdapter(ZoomManager.class);
    }
}

