/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.customization.properties";
    public static final String PREVIEW_ID = "org.eclipse.papyrus.customization.properties.preview";
    public static final String CUSTOMIZATION_PERSPECTIVE_ID = "org.eclipse.papyrus.customization.properties.perspective";
    private static Activator plugin;
    public static LogHelper log;
    private CustomizationManager fCustomizationManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public CustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = new CustomizationManager();
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    private void init(CustomizationManager customizationManager) {
        customizationManager.setShowContainer(false);
        customizationManager.setShowDerivedLinks(true);
        customizationManager.setShowEmptyLinks(true);
        try {
            List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
            for (MetamodelView metamodelView : registryDefaultCustomizations) {
                if ("PapyrusNotationFacet".equals(metamodelView.getName())) continue;
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    public IPath getPreferencesPath() {
        return this.getStateLocation();
    }

    public Image getImage(String path) {
        return this.getImage(PLUGIN_ID, path);
    }

    public Image getImage(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key = String.valueOf(pluginId) + "/" + path);
        if (image == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            image = registry.get(key);
        }
        return image;
    }
}

