/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.results;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.views.search.results.ResultEntry;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public abstract class AbstractResultEntry
extends Match {
    protected Object source;
    protected Object parent;
    protected static final int UNSPECIFIED = -1;

    public abstract Object elementToDisplay();

    public abstract Object openElement(OpenElementService var1) throws ServiceException, PartInitException;

    public abstract Object elementToCheckFilterFor();

    protected void recursiveHierarchy(AbstractResultEntry child, ScopeEntry scopeEntry) {
        if (child.getSource() instanceof EObject) {
            EObject potentialParent = ((EObject)child.getSource()).eContainer();
            if (potentialParent != null) {
                ResultEntry theParent = new ResultEntry(potentialParent, scopeEntry);
                child.setParent((Object)theParent);
                this.recursiveHierarchy(theParent, scopeEntry);
            } else {
                ResultEntry theParent = new ResultEntry(scopeEntry.getResource(), scopeEntry);
                child.setParent((Object)theParent);
            }
        }
    }

    protected AbstractResultEntry getLastParent(AbstractResultEntry child, ScopeEntry scopeEntry) {
        if (child.getSource() instanceof EObject) {
            EObject potentialParent = ((EObject)child.getSource()).eContainer();
            ResultEntry theParent = null;
            while (potentialParent != null) {
                theParent = new ResultEntry(potentialParent, scopeEntry);
                theParent.setParent((Object)new ResultEntry(scopeEntry.getResource(), scopeEntry));
                potentialParent = potentialParent.eContainer();
            }
            if (theParent == null) {
                theParent = new ResultEntry(scopeEntry.getResource(), scopeEntry);
            }
            return theParent;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractResultEntry) {
            return ((AbstractResultEntry)((Object)obj)).getSource().equals(this.source) && ((AbstractResultEntry)((Object)obj)).getOffset() == this.getOffset() && ((AbstractResultEntry)((Object)obj)).getLength() == this.getLength();
        }
        return super.equals(obj);
    }

    public AbstractResultEntry(int offset, int lenght, Object source, ScopeEntry scopeEntry) {
        super((Object)scopeEntry, offset, lenght);
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }
}

