/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.scope;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.views.search.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceVisitor
implements IResourceProxyVisitor {
    private List<IResource> participants = new ArrayList<IResource>();

    public boolean visit(IResourceProxy proxy) throws CoreException {
        switch (proxy.getType()) {
            case 1: {
                IResource resource = proxy.requestResource();
                URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                if (!"di".equals(uri.fileExtension())) break;
                try {
                    ModelSet modelSet = ModelUtils.openFile(resource);
                    modelSet.unload();
                    this.participants.add(resource);
                }
                catch (ModelMultiException modelMultiException) {}
                break;
            }
        }
        return true;
    }

    public List<IResource> getParticipants() {
        return this.participants;
    }
}

