/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.scope;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceInitializerService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.services.openelement.service.impl.OpenElementServiceImpl;
import org.eclipse.papyrus.views.search.Activator;
import org.eclipse.papyrus.views.search.Messages;
import org.eclipse.papyrus.views.search.utils.ModelUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeEntry {
    private ModelSet modelSet;
    private ServicesRegistry servicesRegistry;
    private IResource resource;

    public ScopeEntry(IResource resource) {
        this.resource = resource;
        this.modelSet = this.getModelSet();
        this.servicesRegistry = this.getServicesRegistry();
    }

    private Collection<IEditorPart> getEditors() {
        IWorkbenchWindow[] windows;
        HashSet<IEditorPart> results = new HashSet<IEditorPart>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = iWorkbenchWindow.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] references;
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = references = iWorkbenchPage.getEditorReferences();
                int n5 = references.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart editor = ref.getEditor(true);
                    results.add(editor);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return results;
    }

    private ServicesRegistry createServicesRegistry() {
        try {
            ServicesRegistry serviceRegistry = new ServicesRegistry();
            serviceRegistry.add(LabelProviderService.class, 10, (IService)new LabelProviderServiceImpl());
            serviceRegistry.add(OpenElementService.class, 10, (IService)new OpenElementServiceImpl());
            serviceRegistry.startRegistry();
            return serviceRegistry;
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.ScopeEntry_0, (Throwable)e);
            return null;
        }
    }

    public ModelSet getModelSet() {
        if (this.modelSet == null) {
            try {
                this.modelSet = ServiceUtils.getInstance().getModelSet((Object)this.getServicesRegistry());
            }
            catch (ServiceException e) {
                try {
                    this.modelSet = ModelUtils.openFile(this.resource);
                    this.getServicesRegistry().add(ModelSet.class, 10, (Object)this.modelSet);
                    this.getServicesRegistry().add(ServiceUtilsForResourceInitializerService.class, 10, (IService)new ServiceUtilsForResourceInitializerService());
                    this.getServicesRegistry().startServicesByClassKeys(new Class[]{ModelSet.class, ServiceUtilsForResourceInitializerService.class});
                }
                catch (ModelMultiException modelMultiException) {
                    Activator.log.error(String.valueOf(Messages.ScopeEntry_1) + this.resource, (Throwable)modelMultiException);
                }
                catch (ServiceMultiException e1) {
                    Activator.log.error((Throwable)e1);
                }
                catch (ServiceNotFoundException e1) {
                    Activator.log.error((Throwable)e1);
                }
            }
        }
        return this.modelSet;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    private IEditorPart editorOnResource() {
        Collection<IEditorPart> editors = this.getEditors();
        for (IEditorPart editor : editors) {
            if (editor == null || !ResourceUtil.getResource((IEditorInput)editor.getEditorInput()).equals((Object)this.resource)) continue;
            return editor;
        }
        return null;
    }

    private ServicesRegistry getUpdatedServiceRegistry() {
        IEditorPart editor = this.editorOnResource();
        if (editor != null) {
            ServicesRegistry registry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
            return registry;
        }
        return this.servicesRegistry;
    }

    public ServicesRegistry getServicesRegistry() {
        if (this.servicesRegistry == null) {
            ServicesRegistry registry = this.getUpdatedServiceRegistry();
            if (registry != null) {
                try {
                    registry.getService(OpenElementService.class);
                }
                catch (ServiceException e) {
                    registry.add(OpenElementService.class, 10, (IService)new OpenElementServiceImpl());
                }
                this.servicesRegistry = registry;
            } else {
                this.servicesRegistry = this.createServicesRegistry();
            }
        }
        return this.servicesRegistry;
    }

    public void setServicesRegistry(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }
}

