/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.emf.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.extendedtypes.ActionConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.emf.Activator;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.ConstantValue;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.FeatureToSet;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.FeatureValue;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.ListValue;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.ModifySemanticValuesActionConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.QueryExecutionValue;
import org.eclipse.papyrus.infra.extendedtypes.emf.modifysemanticvaluesactionconfiguration.util.ModifySemanticValuesActionConfigurationSwitch;
import org.eclipse.papyrus.infra.extendedtypes.providers.GetAllExtendedElementTypeActionProvidersOperation;
import org.eclipse.papyrus.infra.extendedtypes.providers.GetExtendedElementTypeActionProviderOperation;
import org.eclipse.papyrus.infra.extendedtypes.providers.IExtendedElementTypeActionProvider;
import org.eclipse.papyrus.infra.queries.core.configuration.QueryConfiguration;
import org.eclipse.papyrus.infra.queries.core.converter.ConverterNotfoundException;
import org.eclipse.papyrus.infra.queries.core.converter.ConverterRegistry;
import org.eclipse.papyrus.infra.queries.core.modisco.QueryUtil;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifySemanticValuesActionProvider
extends AbstractProvider
implements IExtendedElementTypeActionProvider {
    public boolean provides(IOperation operation) {
        if (operation instanceof GetAllExtendedElementTypeActionProvidersOperation) {
            return true;
        }
        if (operation instanceof GetExtendedElementTypeActionProviderOperation) {
            return ((GetExtendedElementTypeActionProviderOperation)operation).getActionConfiguration() instanceof ModifySemanticValuesActionConfiguration;
        }
        return false;
    }

    public ICommand getICommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) {
        if (!(configuration instanceof ModifySemanticValuesActionConfiguration)) {
            Activator.log.error("Trying to configure a modify semantic values action configuration with a configuration which is not a semantic value one: " + configuration, null);
            return UnexecutableCommand.INSTANCE;
        }
        CompositeCommand compositeCommand = new CompositeCommand("Set Values");
        ModifySemanticValuesActionConfiguration modifySemanticValuesActionConfiguration = (ModifySemanticValuesActionConfiguration)configuration;
        for (Object object : elementsToEdit) {
            if (!(object instanceof EObject)) continue;
            for (FeatureToSet featureToSet : modifySemanticValuesActionConfiguration.getFeaturesToSet()) {
                EObject eObject = (EObject)object;
                EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureToSet.getFeatureName());
                if (feature == null || !feature.isChangeable()) continue;
                FeatureValue featureValue = featureToSet.getValue();
                Object value = this.computeValue(eObject, feature, featureValue);
                SetRequest request = new SetRequest(eObject, feature, value);
                IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)eObject);
                ICommand command = service.getEditCommand((IEditCommandRequest)request);
                if (command == null) continue;
                compositeCommand.add((IUndoableOperation)command);
            }
        }
        return compositeCommand;
    }

    protected Object computeValue(final EObject eObject, final EStructuralFeature feature, FeatureValue featureValue) {
        Object value = new ModifySemanticValuesActionConfigurationSwitch<Object>(){

            @Override
            public Object caseListValue(ListValue listValue) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (FeatureValue fValue : listValue.getValues()) {
                    Object value = ModifySemanticValuesActionProvider.this.computeValue(eObject, feature, fValue);
                    values.add(value);
                }
                return values;
            }

            @Override
            public Object caseQueryExecutionValue(QueryExecutionValue queryExecutionValue) {
                Object value = null;
                QueryConfiguration configuration = queryExecutionValue.getConfiguration();
                try {
                    value = QueryUtil.evaluateQuery((EObject)eObject, (QueryConfiguration)configuration);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
                return value;
            }

            @Override
            public Object caseConstantValue(ConstantValue constantValue) {
                Class parameterType = feature.getEType().getInstanceClass();
                try {
                    Object convertedValue = ConverterRegistry.getSingleton().convert(parameterType, constantValue.getValueInstance());
                    return convertedValue;
                }
                catch (ConverterNotfoundException e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
            }
        }.doSwitch(featureValue);
        return value;
    }

    public ICommand getBeforeCreateValidationCommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) {
        ModifySemanticValuesActionConfiguration modifySemanticValuesActionConfiguration = (ModifySemanticValuesActionConfiguration)configuration;
        for (Object object : elementsToEdit) {
        }
        return null;
    }

    public void setConfiguration(IConfigurationElement element) {
    }
}

