/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.NamedElementHelper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.StereotypeHelper;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.ExtensionEditPart;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class ExtensionHelper
extends ElementHelper {
    public static final String EXTENSION = "Extension_";
    public static final String BASE = "base_";
    public static int source = 0;
    public static int target = 1;

    public static org.eclipse.gef.commands.Command getDestroyExtensionCommand(Class metaclass) {
        CompoundCommand cc = new CompoundCommand("Destroy Extension");
        IMultiDiagramEditor editor = (IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ServicesRegistry registry = editor.getServicesRegistry();
        Object rootProfile = null;
        try {
            IModel umlModel;
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            if (modelSet != null && (umlModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")) != null) {
                rootProfile = (Profile)((UmlModel)umlModel).lookupRoot();
            }
        }
        catch (NotFoundException ex) {
            Activator.log.error((Throwable)ex);
            return UnexecutableCommand.INSTANCE;
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList profileList = Util.getInstancesFilteredByType((Package)rootProfile, rootProfile.getClass(), null);
        EList extensionList = metaclass.getExtensions();
        ArrayList<Extension> extensionsToDestroy = new ArrayList<Extension>();
        for (Extension extension : extensionList) {
            EObject containerExt = extension.eContainer();
            if (!profileList.contains(containerExt) && containerExt != rootProfile) continue;
            extensionsToDestroy.add(extension);
        }
        int iterExt = 0;
        while (iterExt < extensionsToDestroy.size()) {
            cc.add(StereotypeHelper.getRemovePropertyCommand((Extension)extensionsToDestroy.get(iterExt)));
            ++iterExt;
        }
        for (Extension extension : extensionsToDestroy) {
            DestroyElementRequest destroyElementRequest = new DestroyElementRequest((EObject)extension, false);
            DestroyElementCommand destroyElementCommand = new DestroyElementCommand(destroyElementRequest);
            cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)destroyElementCommand));
        }
        if (cc.isEmpty()) {
            cc.add((org.eclipse.gef.commands.Command)new EMFtoGEFCommandWrapper((Command)new IdentityCommand()));
        }
        return cc;
    }

    public static CommandResult reconnectSource(Extension link, Stereotype newSource) {
        Property property2;
        String deducedName = ExtensionHelper.deduceExtensionNameFromProperties(link);
        String oldName = link.getName();
        EditPolicy policy = null;
        List view = DiagramEditPartsUtil.getEObjectViews((EObject)link);
        if (!view.isEmpty()) {
            IEditorPart editor = MDTUtil.getActiveEditor();
            DiagramEditPart diagram = (DiagramEditPart)((IMultiDiagramEditor)editor).getAdapter(DiagramEditPart.class);
            EditPart extensionEP = DiagramEditPartsUtil.getEditPartFromView((View)((View)view.get(0)), (EditPart)diagram);
            if (extensionEP instanceof ExtensionEditPart) {
                policy = extensionEP.getEditPolicy((Object)"SpecificExtensionNameEditPolicy");
            }
            if (policy != null) {
                policy.deactivate();
            }
        }
        Type sourceType = (Type)link.getEndTypes().get(source);
        Type targetType = (Type)link.getEndTypes().get(target);
        if (sourceType instanceof Stereotype) {
            EList attributes = ((Stereotype)sourceType).getOwnedAttributes();
            for (Property property2 : attributes) {
                if (property2.getAssociation() != link) continue;
                ((Stereotype)sourceType).getOwnedAttributes().remove((Object)property2);
                link.getMemberEnds().remove((Object)property2);
                break;
            }
        }
        EList ends = link.getOwnedEnds();
        for (Property endSource : ends) {
            if (!(endSource instanceof ExtensionEnd)) continue;
            endSource.setName(String.valueOf(EXTENSION.replaceFirst("E", "e")) + newSource.getName());
            endSource.setType((Type)newSource);
            break;
        }
        property2 = UMLFactory.eINSTANCE.createProperty();
        property2.setName(BASE + targetType.getName());
        property2.setType(targetType);
        property2.setAssociation((Association)link);
        property2.setAggregation(AggregationKind.NONE_LITERAL);
        link.getMemberEnds().add((Object)property2);
        newSource.getOwnedAttributes().add((Object)property2);
        if (oldName.contains(deducedName) && oldName.indexOf(deducedName) == 0) {
            oldName = oldName.substring(deducedName.length());
            try {
                Integer test = Integer.parseInt(oldName);
                link.setName(ExtensionHelper.getExtensionName((Element)link.eContainer(), newSource, (Class)targetType));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (policy != null) {
            policy.activate();
        }
        return CommandResult.newOKCommandResult((Object)link);
    }

    public static CommandResult reconnectTarget(Extension link, Class newTarget) {
        String deducedName = ExtensionHelper.deduceExtensionNameFromProperties(link);
        String oldName = link.getName();
        Type sourceType = (Type)link.getEndTypes().get(source);
        if (sourceType instanceof Stereotype) {
            EList attributes = ((Stereotype)sourceType).getOwnedAttributes();
            for (Property property : attributes) {
                if (property.getAssociation() != link) continue;
                property.setType((Type)newTarget);
                property.setName(BASE + newTarget.getName());
                break;
            }
            if (oldName.contains(deducedName) && oldName.indexOf(deducedName) == 0) {
                oldName = oldName.substring(deducedName.length());
                try {
                    Integer test = Integer.parseInt(oldName);
                    link.setName(ExtensionHelper.getExtensionName((Element)link.eContainer(), (Stereotype)sourceType, newTarget));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return CommandResult.newOKCommandResult((Object)link);
    }

    public static String getExtensionName(Element extensionParent, Stereotype source, Class target) {
        String name = "E_";
        name = String.valueOf(name) + source.getName() + "_" + target.getName();
        NamedElementHelper helper = new NamedElementHelper();
        name = helper.getNewUMLElementName(extensionParent, name);
        return name;
    }

    public static String deduceExtensionNameFromProperties(Extension extension) {
        String logicName = "E_";
        String stereotypeName = null;
        stereotypeName = extension.getStereotype().getName();
        String metaclassName = extension.getMetaclass().getName();
        logicName = String.valueOf(logicName) + stereotypeName + "_" + metaclassName;
        return logicName;
    }
}

