/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.ContainerNodeDescriptorRegistry;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.GroupRequestAdvisor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IGroupRequestAdvisor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers.IGroupNotifier;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.Utils;

public abstract class GroupListenerEditPolicy
extends GraphicalNodeEditPolicy
implements IGroupNotifier {
    private IContainerNodeDescriptor groupDescriptor;
    private boolean isMoving = false;
    private ChangeBoundsRequest movingRequest;

    public GroupListenerEditPolicy(IContainerNodeDescriptor groupDescriptor) {
        this.groupDescriptor = groupDescriptor;
    }

    public EObject getEObject() {
        EditPart editPart = this.getHost();
        if (editPart instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)editPart).resolveSemanticElement();
        }
        return null;
    }

    public void deactivate() {
        GroupRequestAdvisor.getInstance().removeListenner(this);
        super.deactivate();
    }

    public void activate() {
        EObject resolveSemanticElement = this.getHostEditPart().resolveSemanticElement();
        if (resolveSemanticElement != null) {
            GroupRequestAdvisor.getInstance().addListenner(resolveSemanticElement, this);
        }
        super.activate();
    }

    public IContainerNodeDescriptor getHostGroupDescriptor() {
        return this.groupDescriptor;
    }

    protected IGroupRequestAdvisor getGroupRequestAdvisor() {
        return GroupRequestAdvisor.getInstance();
    }

    public IGraphicalEditPart getHostEditPart() {
        return (IGraphicalEditPart)this.getHost();
    }

    public boolean isIncludedIn(Rectangle bounds) {
        Rectangle figureBounds = null;
        figureBounds = this.isMoving() ? Utils.getAbslotueRequestBounds(this.getMovingRequest(), this.getHostEditPart()) : Utils.getAbsoluteBounds(this.getHostEditPart());
        return bounds.contains(figureBounds);
    }

    public boolean includes(Rectangle bounds) {
        if (this.getHost() == null) {
            return false;
        }
        IGraphicalEditPart compartmentEditPart = this.getHostGroupDescriptor().getCompartmentPartFromView(this.getHostEditPart());
        if (compartmentEditPart != null) {
            Rectangle figureBounds = null;
            figureBounds = this.isMoving() ? Utils.getAbslotueRequestBounds(this.getMovingRequest(), compartmentEditPart) : Utils.getAbsoluteBounds(compartmentEditPart);
            return figureBounds.contains(bounds);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IContainerNodeDescriptor.class.isAssignableFrom(adapter)) {
            return this.groupDescriptor;
        }
        return this.getHostEditPart().getAdapter(adapter);
    }

    public int compareTo(IGroupNotifier o) {
        return this.getHostGroupDescriptor().compareTo(o.getHostGroupDescriptor());
    }

    public void startMoving(ChangeBoundsRequest request) {
        this.setMoving(true);
        this.setMovingRequest(request);
    }

    public void stopMoving() {
        this.setMoving(false);
        this.setMovingRequest(null);
    }

    protected boolean isMoving() {
        return this.isMoving;
    }

    protected ChangeBoundsRequest getMovingRequest() {
        return this.movingRequest;
    }

    protected void setMovingRequest(ChangeBoundsRequest movingRequest) {
        this.movingRequest = movingRequest;
    }

    protected void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    public boolean isPartMoving() {
        return this.isMoving();
    }

    public IAdaptable getAdaptableView() {
        return this.getViewAdapter();
    }

    public void eraseTargetFeedback(Request request) {
    }

    public void showSourceFeedback(Request request) {
    }

    public IContainerNodeDescriptor getTargetGroupDescriptor(IAdaptable eObjectAdapter) {
        Object adapted = eObjectAdapter.getAdapter(EObject.class);
        if (adapted instanceof EObject) {
            EObject eObject = (EObject)adapted;
            return ContainerNodeDescriptorRegistry.getInstance().getContainerNodeDescriptor(eObject.eClass());
        }
        return null;
    }
}

