/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.predicates.DescendantsFilter;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String OLD_PARENT = "Old parent :";
    private static UMLItemProviderAdapterFactory adapter = new UMLItemProviderAdapterFactory();
    static AdapterFactoryLabelProvider factory = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

    public static Iterable<IGraphicalEditPart> getTargetedEditPart(ChangeBoundsRequest req) {
        if (req != null && req.getEditParts() != null) {
            return Iterables.transform((Iterable)Iterables.filter((Iterable)req.getEditParts(), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return input instanceof IGraphicalEditPart;
                }
            }), (Function)new Function<Object, IGraphicalEditPart>(){

                public IGraphicalEditPart apply(Object from) {
                    return (IGraphicalEditPart)from;
                }
            });
        }
        return Collections.EMPTY_LIST;
    }

    public static Rectangle getAbslotueRequestBounds(ChangeBoundsRequest request, IGraphicalEditPart host) {
        Rectangle bounds = Utils.getAbsoluteBounds(host);
        return request.getTransformedRectangle(bounds);
    }

    public static Rectangle getAbsoluteBounds(IGraphicalEditPart part) {
        Node node;
        LayoutConstraint cst;
        part.refresh();
        part.getFigure().invalidate();
        part.getFigure().validate();
        Rectangle bounds = part.getFigure().getBounds().getCopy();
        if (part.getNotationView() instanceof Node && (cst = (node = (Node)part.getNotationView()).getLayoutConstraint()) instanceof Bounds) {
            Bounds b = (Bounds)cst;
            Point parentLoc = part.getFigure().getParent().getBounds().getLocation();
            if (b.getX() > 0) {
                bounds.x = b.getX() + parentLoc.x;
            }
            if (b.getY() > 0) {
                bounds.y = b.getY() + parentLoc.y;
            }
            if (b.getHeight() != -1) {
                bounds.height = b.getHeight();
            }
            if (b.getWidth() != -1) {
                bounds.width = b.getWidth();
            }
        }
        part.getFigure().getParent().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Set<EObject> filterDescendants(Set<EObject> all) {
        return Sets.filter(all, (Predicate)new DescendantsFilter(all));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCorrectLabel(Object object) {
        if (object instanceof EObject) {
            if (!(object instanceof Element)) return factory.getText(object);
            Object provider = adapter.adapt(object, IItemLabelProvider.class);
            if (!(provider instanceof IItemLabelProvider)) return "Error in getting name";
            IItemLabelProvider labelProvider = (IItemLabelProvider)provider;
            return labelProvider.getText(object);
        }
        if (!(object instanceof EReference)) return object.toString();
        return ((EReference)object).getName();
    }

    public static String getCorrectLabel(IAdaptable object) {
        Object view = object.getAdapter(EObject.class);
        if (view instanceof EObject) {
            return Utils.getCorrectLabel(view);
        }
        return object.toString();
    }

    public static Multimap<EReference, EObject> getOldParents(IGroupRequest request) {
        if (request.getNodeDescpitor() != null) {
            return Utils.getReferenceMultimap(request, request.getNodeDescpitor().getParentReferences());
        }
        return ArrayListMultimap.create();
    }

    public static Multimap<EReference, EObject> getOldChildren(IGroupRequest request) {
        if (request.getNodeDescpitor() != null) {
            return Utils.getReferenceMultimap(request, request.getNodeDescpitor().getChildrenReferences());
        }
        return ArrayListMultimap.create();
    }

    protected static Multimap<EReference, EObject> getReferenceMultimap(IGroupRequest request, Iterable<EReference> references) {
        Object elementAdapter = request.getTargetElement().getAdapter(EObject.class);
        if (elementAdapter instanceof EObject && references != null) {
            ArrayListMultimap result = ArrayListMultimap.create();
            EObject targetElement = (EObject)elementAdapter;
            if (targetElement != null) {
                for (EReference ref : references) {
                    if (ref.isMany()) {
                        Collection values = (Collection)targetElement.eGet((EStructuralFeature)ref);
                        for (EObject v : values) {
                            result.put((Object)ref, (Object)v);
                        }
                        continue;
                    }
                    Object value = targetElement.eGet((EStructuralFeature)ref);
                    if (!(value instanceof EObject)) continue;
                    result.put((Object)ref, (Object)((EObject)value));
                }
            }
            return result;
        }
        return ArrayListMultimap.create();
    }

    public static ChangeBoundsRequest getChangeBoundsRequestCopy(ChangeBoundsRequest req, EditPart part) {
        ChangeBoundsRequest auxRequest = new ChangeBoundsRequest(req.getType());
        auxRequest.setLocation(req.getLocation());
        auxRequest.setEditParts(Collections.singletonList(part));
        auxRequest.setMoveDelta(req.getMoveDelta());
        auxRequest.setResizeDirection(req.getResizeDirection());
        auxRequest.setSizeDelta(req.getSizeDelta());
        return auxRequest;
    }

    public static Rectangle getAbslotueRequestBounds(CreateViewRequest initialRequest) {
        Point location = initialRequest.getLocation();
        Dimension size = initialRequest.getSize();
        Rectangle creationBounds = new Rectangle(location != null ? location : new Point(0, 0), size != null ? size : new Dimension(20, 20));
        return creationBounds;
    }
}

