/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.draw2d;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.activity.draw2d.FlowLayoutAdvancedConstraint;

public class FlowLayoutAdvanced
extends FlowLayout {
    private Orientation orientation = Orientation.VERTICAL;
    private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        FlowLayoutAdvancedConstraint constraint;
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        Dimension childDim = this.getChildSize(child, Rectangle.SINGLETON.width, Rectangle.SINGLETON.height).getCopy();
        bounds.setSize(childDim);
        Object _constraint = this.getConstraint(child);
        if (_constraint instanceof FlowLayoutAdvancedConstraint && (constraint = (FlowLayoutAdvancedConstraint)_constraint) != null) {
            if (constraint.isFill()) {
                if (Orientation.VERTICAL.equals((Object)this.orientation)) {
                    bounds.setSize(bounds.getSize().getCopy().width, this.getAvailableSpaceForFilledElement((IFigure)child, (Dimension)Rectangle.SINGLETON.getSize().getCopy()).getCopy().height);
                } else {
                    bounds.setSize(this.getAvailableSpaceForFilledElement((IFigure)child, (Dimension)Rectangle.SINGLETON.getSize().getCopy()).getCopy().width, bounds.getSize().getCopy().height);
                }
            }
            if (constraint.isFull()) {
                bounds.setSize(Rectangle.SINGLETON.getSize().getCopy());
                bounds.setLocation(Rectangle.SINGLETON.getLocation().getCopy());
            }
        }
        child.setBounds(bounds);
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (constraint instanceof FlowLayoutAdvancedConstraint || constraint == null) {
            this.constraints.put(child, constraint);
        }
    }

    private Dimension getAvailableSpaceForFilledElement(IFigure currentChild, Dimension parentDim) {
        Set<IFigure> children = this.constraints.keySet();
        if (children.isEmpty()) {
            throw new RuntimeException("Current layout is not set on any figure");
        }
        int numberOfFilledElement = 0;
        for (IFigure _child : children) {
            FlowLayoutAdvancedConstraint localConstraint;
            if (!(_child instanceof IFigure)) continue;
            IFigure child = _child;
            if (this.constraints.containsKey(child) && (localConstraint = (FlowLayoutAdvancedConstraint)this.constraints.get(child)) != null && localConstraint.isFill()) {
                ++numberOfFilledElement;
            }
            if (child.equals(currentChild)) continue;
            parentDim = parentDim.getShrinked(0, this.getChildSize((IFigure)child, (int)Rectangle.SINGLETON.width, (int)Rectangle.SINGLETON.height).height);
        }
        if (Orientation.VERTICAL.equals((Object)this.orientation)) {
            parentDim.setHeight((int)((float)parentDim.height / (float)numberOfFilledElement));
        } else {
            parentDim.setWidth((int)((float)parentDim.width / (float)numberOfFilledElement));
        }
        return parentDim;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Dimension getMinimumSize(IFigure container, int w, int h) {
        Dimension minDim = null;
        for (IFigure figure : this.constraints.keySet()) {
            FlowLayoutAdvancedConstraint constraint;
            Object _c = this.constraints.get(figure);
            if (!(_c instanceof FlowLayoutAdvancedConstraint) || !(constraint = (FlowLayoutAdvancedConstraint)_c).isHasMinsize()) continue;
            minDim = minDim == null ? figure.getMinimumSize() : Dimension.min((Dimension)minDim, (Dimension)figure.getMinimumSize());
        }
        if (minDim == null) {
            minDim = new Dimension(0, 0);
        }
        return minDim;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

