/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.activity.commands.CreatePinToParameterLinkEAnnotation;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.ConfirmPinAndParameterSyncDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.WarningAndCreateAttributeDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.WarningAndCreateParameterDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.WarningAndLinkDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.BroadcastSignalActionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.handlers.SynchronizePinsParametersHandler;
import org.eclipse.papyrus.uml.diagram.activity.helper.PinAndParameterSynchronizeValidator;
import org.eclipse.papyrus.uml.diagram.activity.helper.SafeDialogOpenerDuringValidation;
import org.eclipse.papyrus.uml.diagram.activity.helper.UMLValidationHelper;
import org.eclipse.papyrus.uml.diagram.activity.helper.datastructure.LinkPinToParameter;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.AddStructuralFeatureValueAction;
import org.eclipse.uml2.uml.AddVariableValueAction;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BroadcastSignalAction;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CreateObjectAction;
import org.eclipse.uml2.uml.DestroyObjectAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ReadStructuralFeatureAction;
import org.eclipse.uml2.uml.ReadVariableAction;
import org.eclipse.uml2.uml.SendObjectAction;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.StructuralFeatureAction;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinAndParameterSynchronizer
extends AbstractModelConstraint {
    private static final String RESULT_IN_READ_VARIABLE_ACTION = "result";
    private static final String VALUE_IN_ADD_VARIABLE_VALUE_ACTION = "value";
    private static final String INSERT_AT_IN_ADD_VARIABLE_VALUE_ACTION = "insertAt";
    private static final String TARGET_IN_DESTROY_OBJECT_ACTION = "target";
    private static final String VALUE_PIN_IN_STRUCTURAL_FEATURE_VALUE_ACTION = "value";
    private static final String RESULT_PIN_READ_SRTUCTURAL_ACTION = "result";
    private static final String OBJECT_PIN_IN_READS_STRUCTURAL_ACTION = "object";
    private static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    private static final String TARGET_PIN_INITIALIZATION_NAME = "target";
    private static final String REQUEST_PIN_INITIALIZATION_NAME = "request";
    private static final String RESULT_PIN_INITIALIZATION_NAME = "result";

    public IStatus validate(IValidationContext ctx) {
        try {
            CompoundCommand cmd;
            EObject eObject = ctx.getTarget();
            if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof CallBehaviorAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)((CallAction)ctx.getFeatureNewValue()));
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof CallOperationAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)((CallAction)ctx.getFeatureNewValue()));
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof SendSignalAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)((SendSignalAction)ctx.getFeatureNewValue()));
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof SendObjectAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((SendObjectAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof DestroyObjectAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((DestroyObjectAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof AddStructuralFeatureValueAction) {
                cmd = this.getResetPinsCmd((AddStructuralFeatureValueAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof ReadStructuralFeatureAction) {
                cmd = this.getResetPinsCmd((ReadStructuralFeatureAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof AddVariableValueAction) {
                cmd = this.getResetPinsCmd((AddVariableValueAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof ReadVariableAction) {
                cmd = this.getResetPinsCmd((ReadVariableAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof BroadcastSignalAction) {
                cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)ctx.getFeatureNewValue());
                if (!cmd.isEmpty() && cmd.canExecute()) {
                    cmd.execute();
                }
            } else if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof CreateObjectAction && !(cmd = this.getResetPinsCmd((CreateObjectAction)ctx.getFeatureNewValue())).isEmpty() && cmd.canExecute()) {
                cmd.execute();
            }
            if ((EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getOperation_Class().equals(ctx.getFeature()) && eObject instanceof Operation && !(cmd = this.getUpdateTargetPinsType((Operation)eObject)).isEmpty() && cmd.canExecute()) {
                if (this.askForValidation(PinAndParameterSynchronizer.getCallingActions((Element)((Operation)eObject)))) {
                    cmd.execute();
                } else {
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
            if (eObject instanceof ValueSpecification) {
                EObject topValueSpec = eObject;
                while (topValueSpec.eContainer() instanceof ValueSpecification) {
                    topValueSpec = topValueSpec.eContainer();
                }
                eObject = topValueSpec.eContainer();
            }
            if (eObject instanceof Pin) {
                Element owner = ((Pin)eObject).getOwner();
                InputPin target = null;
                if (owner instanceof CallOperationAction) {
                    target = ((CallOperationAction)owner).getTarget();
                }
                if (target != null && target.equals(eObject)) {
                    return this.handleTargetPinModification((Pin)eObject, ctx);
                }
                return this.handlePinModification((Pin)eObject, ctx);
            }
            if (eObject instanceof Parameter) {
                return this.handleParameterModification((Parameter)eObject, ctx);
            }
            if (eObject instanceof Property) {
                return this.handlePropertyModification((Property)eObject, ctx);
            }
            if (eObject instanceof CallOperationAction) {
                return this.handleCallOperationActionModification((CallOperationAction)eObject, ctx);
            }
            if (eObject instanceof Operation) {
                return this.handleOperationModification((Operation)eObject, ctx);
            }
            if (eObject instanceof CallBehaviorAction) {
                return this.handleCallBehaviorActionModification((CallBehaviorAction)eObject, ctx);
            }
            if (eObject instanceof Behavior) {
                return this.handleBehaviorModification((Behavior)eObject, ctx);
            }
            if (eObject instanceof SendSignalAction) {
                return this.handleSendSignalActionModification((SendSignalAction)eObject, ctx);
            }
            if (eObject instanceof Signal) {
                return this.handleSignalModification((Signal)eObject, ctx);
            }
            if (eObject instanceof SendObjectAction) {
                return this.handleSendObjectActionModification((SendObjectAction)eObject, ctx);
            }
            if (eObject instanceof BroadcastSignalAction) {
                return this.handleBroadcastSignalActionModification((BroadcastSignalAction)eObject, ctx);
            }
            return ctx.createSuccessStatus();
        }
        catch (RuntimeException rte) {
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"Unexpected exception during Pin and Parameter synchronization : ", (Throwable)rte);
            return ctx.createSuccessStatus();
        }
    }

    protected boolean testPinOrParameterOrPropertyFeature(EStructuralFeature modifiedFeature) {
        boolean type = UMLPackage.eINSTANCE.getTypedElement_Type().equals(modifiedFeature);
        boolean ordering = UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(modifiedFeature);
        boolean multiplicity = UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(modifiedFeature) || UMLPackage.eINSTANCE.getMultiplicityElement_Lower().equals(modifiedFeature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(modifiedFeature) || UMLPackage.eINSTANCE.getMultiplicityElement_Upper().equals(modifiedFeature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(modifiedFeature);
        boolean inAValueSpecification = ValueSpecification.class.isAssignableFrom(modifiedFeature.getContainerClass());
        return type || ordering || multiplicity || inAValueSpecification;
    }

    protected boolean testActionFeature(EStructuralFeature modifiedFeature) {
        boolean input = UMLPackage.eINSTANCE.getInvocationAction_Argument().equals(modifiedFeature) || UMLPackage.eINSTANCE.getCallOperationAction_Target().equals(modifiedFeature);
        boolean output = UMLPackage.eINSTANCE.getCallAction_Result().equals(modifiedFeature);
        return input || output;
    }

    protected IStatus handleTargetPinModification(Pin pin, IValidationContext ctx) {
        Element owner;
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(ctx.getFeature()) && (owner = pin.getOwner()) instanceof CallOperationAction && ((CallOperationAction)owner).getOperation() != null) {
            this.proposeNavigation((NamedElement)((CallOperationAction)owner).getOperation());
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }

    protected boolean proposeParameterCreation(final NamedElement element, final EClass preferredPinClass) {
        String elementLabel = labelProvider.getText((Object)element);
        final String message = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UnauthorizedModification, (Object)elementLabel);
        final ParameterDirectionKind preferredDirection = UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(preferredPinClass) ? ParameterDirectionKind.OUT_LITERAL : ParameterDirectionKind.IN_LITERAL;
        SafeDialogOpenerDuringValidation<Boolean> opener = new SafeDialogOpenerDuringValidation<Boolean>(){

            @Override
            protected Boolean openDialog() {
                boolean result;
                WarningAndCreateParameterDialog dialog = new WarningAndCreateParameterDialog(new Shell(Display.getDefault()), CustomMessages.PinAndParameterSynchronizer_UnauthorizedModificationTitle, message, element, labelProvider, preferredDirection);
                boolean bl = result = dialog.open() == 0;
                if (result) {
                    Parameter parameter = dialog.getParameter();
                    PinAndParameterSynchronizer.this.handleParameterCreatedDuringValidation(parameter, preferredPinClass);
                }
                return result;
            }
        };
        return (Boolean)opener.execute();
    }

    protected void handleParameterCreatedDuringValidation(Parameter parameter, EClass preferredPinClass) {
        if (parameter != null) {
            Map<Integer, TypedElement> empty = Collections.emptyMap();
            CompoundCommand globalCmd = new CompoundCommand();
            List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions(parameter.getOwner());
            switch (parameter.getDirection()) {
                case IN_LITERAL: {
                    for (InvocationAction action : callingActions) {
                        if (!(action instanceof CallAction)) continue;
                        int index = action.getArguments().size();
                        CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, Collections.singletonMap(index, parameter), empty, preferredPinClass);
                        globalCmd.append((Command)cmd);
                    }
                    break;
                }
                case OUT_LITERAL: 
                case RETURN_LITERAL: {
                    for (InvocationAction action : callingActions) {
                        if (!(action instanceof CallAction)) continue;
                        int index = ((CallAction)action).getResults().size();
                        CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, empty, Collections.singletonMap(index, parameter), preferredPinClass);
                        globalCmd.append((Command)cmd);
                    }
                    break;
                }
                case INOUT_LITERAL: {
                    for (InvocationAction action : callingActions) {
                        if (!(action instanceof CallAction)) continue;
                        int indexIn = action.getArguments().size();
                        int indexOut = ((CallAction)action).getResults().size();
                        CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, Collections.singletonMap(indexIn, parameter), Collections.singletonMap(indexOut, parameter), preferredPinClass);
                        globalCmd.append((Command)cmd);
                    }
                    break;
                }
            }
            if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
                globalCmd.execute();
            }
        }
    }

    protected boolean proposeAttributeCreation(final NamedElement element, final EClass preferredPinClass) {
        String elementLabel = labelProvider.getText((Object)element);
        final String message = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UnauthorizedModification, (Object)elementLabel);
        SafeDialogOpenerDuringValidation<Boolean> opener = new SafeDialogOpenerDuringValidation<Boolean>(){

            @Override
            protected Boolean openDialog() {
                boolean result;
                WarningAndCreateAttributeDialog dialog = new WarningAndCreateAttributeDialog(new Shell(Display.getDefault()), CustomMessages.PinAndParameterSynchronizer_UnauthorizedModificationTitle, message, element, labelProvider);
                boolean bl = result = dialog.open() == 0;
                if (result) {
                    Property attribute = dialog.getAttribute();
                    PinAndParameterSynchronizer.this.handlePropertyCreatedDuringValidation(attribute, preferredPinClass);
                }
                return result;
            }
        };
        return (Boolean)opener.execute();
    }

    protected void handlePropertyCreatedDuringValidation(Property property, EClass preferredPinClass) {
        if (property != null) {
            Map empty = Collections.emptyMap();
            CompoundCommand globalCmd = new CompoundCommand();
            List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions(property.getOwner());
            for (InvocationAction action : callingActions) {
                if (!(action instanceof SendSignalAction) && !(action instanceof BroadcastSignalActionEditPart)) continue;
                int index = action.getArguments().size();
                CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, Collections.singletonMap(index, property), preferredPinClass);
                globalCmd.append((Command)cmd);
            }
            if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
                globalCmd.execute();
            }
        }
    }

    protected void proposeNavigation(final NamedElement element) {
        final String elementLabel = labelProvider.getText((Object)element);
        final String message = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UnauthorizedModificationRedirection, (Object)elementLabel);
        SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

            @Override
            protected Void openDialog() {
                WarningAndLinkDialog dialog = new WarningAndLinkDialog(new Shell(Display.getDefault()), CustomMessages.PinAndParameterSynchronizer_UnauthorizedModificationTitle, message, element, elementLabel);
                dialog.open();
                return null;
            }
        };
        opener.execute();
    }

    protected IStatus handlePinModification(Pin pin, IValidationContext ctx) {
        NamedElement invoked;
        if ((EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) && this.testPinOrParameterOrPropertyFeature(ctx.getFeature()) && (invoked = PinAndParameterSynchronizer.getInvokedObject(pin)) != null) {
            this.proposeNavigation(invoked);
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus handleParameterModification(Parameter parameter, IValidationContext ctx) {
        if (!EMFEventType.SET.equals(ctx.getEventType()) && !EMFEventType.UNSET.equals(ctx.getEventType())) return ctx.createSuccessStatus();
        if (this.testPinOrParameterOrPropertyFeature(ctx.getFeature())) {
            CompoundCommand cmd = this.getUpdatePinsCmd(PinAndParameterSynchronizer.getPins(parameter), parameter.getType(), parameter.isOrdered(), parameter.isUnique(), parameter.getLower(), parameter.getLowerValue(), parameter.getUpper(), parameter.getUpperValue());
            if (cmd.isEmpty() || !cmd.canExecute()) return ctx.createSuccessStatus();
            if (!this.askForValidation(PinAndParameterSynchronizer.getCallingActions(parameter.getOwner()))) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
            return ctx.createSuccessStatus();
        } else if (UMLPackage.eINSTANCE.getParameter_Direction().equals(ctx.getFeature())) {
            for (Notification event : ctx.getAllEvents()) {
                if (!UMLPackage.eINSTANCE.getParameter_Direction().equals(event.getFeature()) && !UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter().equals(event.getFeature())) continue;
                return this.changePinsBecauseOfParameterDirection((TypedElement)parameter, event, ctx);
            }
            return ctx.createSuccessStatus();
        } else {
            CompoundCommand cmd;
            if (!UMLPackage.eINSTANCE.getNamedElement_Name().equals(ctx.getFeature()) || (cmd = this.getSetPinsNamesCmd(PinAndParameterSynchronizer.getPins(parameter), parameter.getName())).isEmpty() || !cmd.canExecute()) return ctx.createSuccessStatus();
            if (!this.askForValidation(PinAndParameterSynchronizer.getCallingActions(parameter.getOwner()))) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
        }
        return ctx.createSuccessStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus handlePropertyModification(Property property, IValidationContext ctx) {
        if (!EMFEventType.SET.equals(ctx.getEventType()) && !EMFEventType.UNSET.equals(ctx.getEventType())) return ctx.createSuccessStatus();
        if (this.testPinOrParameterOrPropertyFeature(ctx.getFeature())) {
            CompoundCommand cmd = this.getUpdatePinsCmd(PinAndParameterSynchronizer.getPins(property), property.getType(), property.isOrdered(), property.isUnique(), property.getLower(), property.getLowerValue(), property.getUpper(), property.getUpperValue());
            if (cmd.isEmpty() || !cmd.canExecute()) return ctx.createSuccessStatus();
            if (!this.askForValidation(PinAndParameterSynchronizer.getCallingActions(property.getOwner()))) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
            return ctx.createSuccessStatus();
        } else {
            CompoundCommand cmd;
            if (!UMLPackage.eINSTANCE.getNamedElement_Name().equals(ctx.getFeature()) || (cmd = this.getSetPinsNamesCmd(PinAndParameterSynchronizer.getPins(property), property.getName())).isEmpty() || !cmd.canExecute()) return ctx.createSuccessStatus();
            if (!this.askForValidation(PinAndParameterSynchronizer.getCallingActions(property.getOwner()))) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus changePinsBecauseOfParameterDirection(TypedElement parameter, Notification event, IValidationContext ctx) {
        List<Integer> emptyList = Collections.emptyList();
        Map<Integer, TypedElement> emptyMap = Collections.emptyMap();
        Object oldDir = event.getOldValue();
        Object newDir = event.getNewValue();
        int inIndex = PinAndParameterSynchronizer.getIndex(parameter, true);
        int outIndex = PinAndParameterSynchronizer.getIndex(parameter, false);
        CompoundCommand globalCmd = new CompoundCommand();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions(parameter.getOwner());
        if (ParameterDirectionKind.IN_LITERAL.equals(oldDir)) {
            if (ParameterDirectionKind.OUT_LITERAL.equals(newDir) || ParameterDirectionKind.RETURN_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = this.getRemovePinsCmd((CallAction)action, Collections.singletonList(inIndex), emptyList);
                    globalCmd.append((Command)cmd);
                    cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, emptyMap, Collections.singletonMap(outIndex, parameter), null);
                    globalCmd.append((Command)cmd);
                }
            } else if (ParameterDirectionKind.INOUT_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, emptyMap, Collections.singletonMap(outIndex, parameter), null);
                    globalCmd.append((Command)cmd);
                }
            }
        } else if (ParameterDirectionKind.OUT_LITERAL.equals(oldDir) || ParameterDirectionKind.RETURN_LITERAL.equals(oldDir)) {
            if (ParameterDirectionKind.IN_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = this.getRemovePinsCmd((CallAction)action, emptyList, Collections.singletonList(outIndex));
                    globalCmd.append((Command)cmd);
                    cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, Collections.singletonMap(inIndex, parameter), emptyMap, null);
                    globalCmd.append((Command)cmd);
                }
            } else if (ParameterDirectionKind.INOUT_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, Collections.singletonMap(inIndex, parameter), emptyMap, null);
                    globalCmd.append((Command)cmd);
                }
            }
        } else if (ParameterDirectionKind.INOUT_LITERAL.equals(oldDir)) {
            if (ParameterDirectionKind.IN_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = this.getRemovePinsCmd((CallAction)action, emptyList, Collections.singletonList(outIndex));
                    globalCmd.append((Command)cmd);
                }
            } else if (ParameterDirectionKind.OUT_LITERAL.equals(newDir) || ParameterDirectionKind.RETURN_LITERAL.equals(newDir)) {
                for (InvocationAction action : callingActions) {
                    if (!(action instanceof CallAction)) continue;
                    CompoundCommand cmd = this.getRemovePinsCmd((CallAction)action, Collections.singletonList(inIndex), emptyList);
                    globalCmd.append((Command)cmd);
                }
            }
        }
        if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
            if (this.askForValidation(callingActions)) {
                globalCmd.execute();
            } else {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected static List<InvocationAction> getCallingActions(Element element) {
        HashSet<Object> callingActions;
        block3: {
            block2: {
                callingActions = new HashSet<Object>();
                if (!(element instanceof Behavior) && !(element instanceof Operation)) break block2;
                Collection references = CacheAdapter.INSTANCE.getNonNavigableInverseReferences((EObject)element);
                for (EStructuralFeature.Setting ref : references) {
                    EObject action = ref.getEObject();
                    boolean operationCase = UMLPackage.eINSTANCE.getCallOperationAction_Operation().equals(ref.getEStructuralFeature());
                    boolean behaviorCase = UMLPackage.eINSTANCE.getCallBehaviorAction_Behavior().equals(ref.getEStructuralFeature());
                    if (!operationCase && !behaviorCase || !(action instanceof CallAction) || action.eContainer() == null) continue;
                    callingActions.add((CallAction)action);
                }
                break block3;
            }
            if (!(element instanceof Signal)) break block3;
            Collection references = CacheAdapter.INSTANCE.getNonNavigableInverseReferences((EObject)element);
            for (EStructuralFeature.Setting ref : references) {
                EObject action = ref.getEObject();
                boolean signalCase = UMLPackage.eINSTANCE.getSendSignalAction_Signal().equals(ref.getEStructuralFeature());
                if (!signalCase || !(action instanceof SendSignalAction) || action.eContainer() == null) continue;
                callingActions.add((SendSignalAction)action);
            }
        }
        return new ArrayList<InvocationAction>(callingActions);
    }

    protected IStatus handleCallOperationActionModification(CallOperationAction action, IValidationContext ctx) {
        if (this.testTransformPinCase(ctx)) {
            return ctx.createSuccessStatus();
        }
        if (this.testCustomModificationToValidPins((ActivityNode)action, ctx)) {
            return ctx.createSuccessStatus();
        }
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getOperation() != null && action.getOperation() != null) {
                if (this.canCreateParameterFromCallAction((CallAction)action)) {
                    Object pin = ctx.getFeatureNewValue();
                    boolean parameterCreated = this.proposeParameterCreation((NamedElement)action.getOperation(), ((EObject)pin).eClass());
                    if (parameterCreated) {
                        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
                        Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)ctx.getFeatureNewValue());
                        cmd.execute();
                        return ctx.createSuccessStatus();
                    }
                } else {
                    this.proposeNavigation((NamedElement)action.getOperation());
                }
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getOperation() != null && action.getOperation() != null) {
                this.proposeNavigation((NamedElement)action.getOperation());
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) {
            CompoundCommand cmd;
            if (UMLPackage.eINSTANCE.getCallOperationAction_Operation().equals(ctx.getFeature()) && !(cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)action)).isEmpty() && cmd.canExecute()) {
                cmd.execute();
            }
            if (UMLPackage.eINSTANCE.getCallOperationAction_Target().equals(ctx.getFeature())) {
                final String msg = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinMessage, (Object)UMLPackage.eINSTANCE.getCallOperationAction_Target().getName());
                SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

                    @Override
                    protected Void openDialog() {
                        MessageDialog.openWarning((Shell)new Shell(Display.getDefault()), (String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinTitle, (String)msg);
                        return null;
                    }
                };
                opener.execute();
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected boolean testCustomModificationToValidPins(ActivityNode node, IValidationContext ctx) {
        Method[] methods;
        IStatus status = null;
        Class<UMLValidationHelper> aClass = UMLValidationHelper.class;
        Method[] methodArray = methods = aClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getReturnType() == IStatus.class && m.isAnnotationPresent(PinAndParameterSynchronizeValidator.class) && m.getParameterTypes().length == 2 && m.getParameterTypes()[0].isInstance(node)) {
                try {
                    status = (IStatus)m.invoke(aClass, node, ctx);
                    if (status != null && !status.isOK()) {
                        break;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return status == null || status.isOK();
    }

    protected IStatus handleCallBehaviorActionModification(CallBehaviorAction action, IValidationContext ctx) {
        if (this.testTransformPinCase(ctx)) {
            return ctx.createSuccessStatus();
        }
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getBehavior() != null && action.getBehavior() != null) {
                if (this.canCreateParameterFromCallAction((CallAction)action)) {
                    Object pin = ctx.getFeatureNewValue();
                    boolean parameterCreated = this.proposeParameterCreation((NamedElement)action.getBehavior(), ((EObject)pin).eClass());
                    if (parameterCreated) {
                        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
                        Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)ctx.getFeatureNewValue());
                        cmd.execute();
                        return ctx.createSuccessStatus();
                    }
                } else {
                    this.proposeNavigation((NamedElement)action.getBehavior());
                }
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getBehavior() != null && action.getBehavior() != null) {
                this.proposeNavigation((NamedElement)action.getBehavior());
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if ((EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getCallBehaviorAction_Behavior().equals(ctx.getFeature())) {
            String behaviorName;
            CompoundCommand cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)action);
            if (action.getBehavior() != null && (behaviorName = action.getBehavior().getName()) != null && !"".equals(behaviorName)) {
                TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
                cmd.append(SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)behaviorName));
            }
            if (!cmd.isEmpty() && cmd.canExecute()) {
                cmd.execute();
            }
        }
        return ctx.createSuccessStatus();
    }

    protected boolean canCreateParameterFromCallAction(CallAction action) {
        return true;
    }

    protected boolean canCreateAttributesFromSendSignalAction(SendSignalAction action) {
        return true;
    }

    protected IStatus handleBroadcastSignalActionModification(BroadcastSignalAction action, IValidationContext ctx) {
        CompoundCommand cmd;
        if (this.testTransformPinCase(ctx)) {
            return ctx.createSuccessStatus();
        }
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getSignal() != null && action.getSignal() != null) {
                Object pin = ctx.getFeatureNewValue();
                boolean attributeCreated = this.proposeAttributeCreation((NamedElement)action.getSignal(), ((EObject)pin).eClass());
                if (attributeCreated) {
                    TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
                    Command cmd2 = RemoveCommand.create((EditingDomain)editingdomain, (Object)ctx.getFeatureNewValue());
                    cmd2.execute();
                    return ctx.createSuccessStatus();
                }
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getSignal() != null && action.getSignal() != null) {
                this.proposeNavigation((NamedElement)action.getSignal());
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if ((EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getBroadcastSignalAction_Signal().equals(ctx.getFeature()) && !(cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)action)).isEmpty() && cmd.canExecute()) {
            cmd.execute();
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleSendSignalActionModification(SendSignalAction action, IValidationContext ctx) {
        if (this.testTransformPinCase(ctx)) {
            return ctx.createSuccessStatus();
        }
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getSignal() != null && action.getSignal() != null) {
                if (this.canCreateAttributesFromSendSignalAction(action)) {
                    Object pin = ctx.getFeatureNewValue();
                    boolean attributeCreated = this.proposeAttributeCreation((NamedElement)action.getSignal(), ((EObject)pin).eClass());
                    if (attributeCreated) {
                        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
                        Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)ctx.getFeatureNewValue());
                        cmd.execute();
                        return ctx.createSuccessStatus();
                    }
                } else {
                    this.proposeNavigation((NamedElement)action.getSignal());
                }
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) {
            if (this.testActionFeature(ctx.getFeature()) && action.getSignal() != null && action.getSignal() != null) {
                this.proposeNavigation((NamedElement)action.getSignal());
                return ctx.createFailureStatus(new Object[0]);
            }
        } else if (EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) {
            CompoundCommand cmd;
            if (UMLPackage.eINSTANCE.getSendSignalAction_Signal().equals(ctx.getFeature()) && !(cmd = PinAndParameterSynchronizer.getResetPinsCmd((InvocationAction)action)).isEmpty() && cmd.canExecute()) {
                cmd.execute();
            }
            if (UMLPackage.eINSTANCE.getSendSignalAction_Target().equals(ctx.getFeature())) {
                final String msg = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinMessage, (Object)UMLPackage.eINSTANCE.getSendSignalAction_Target().getName());
                SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

                    @Override
                    protected Void openDialog() {
                        MessageDialog.openWarning((Shell)new Shell(Display.getDefault()), (String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinTitle, (String)msg);
                        return null;
                    }
                };
                opener.execute();
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleSendObjectActionModification(SendObjectAction action, IValidationContext ctx) {
        if (this.testTransformPinCase(ctx)) {
            return ctx.createSuccessStatus();
        }
        if (EMFEventType.SET.equals(ctx.getEventType()) || EMFEventType.UNSET.equals(ctx.getEventType())) {
            if (UMLPackage.eINSTANCE.getSendObjectAction_Target().equals(ctx.getFeature())) {
                final String msg = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinMessage, (Object)UMLPackage.eINSTANCE.getSendObjectAction_Target().getName());
                SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

                    @Override
                    protected Void openDialog() {
                        MessageDialog.openWarning((Shell)new Shell(Display.getDefault()), (String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinTitle, (String)msg);
                        return null;
                    }
                };
                opener.execute();
                return ctx.createFailureStatus(new Object[0]);
            }
            if (UMLPackage.eINSTANCE.getSendObjectAction_Request().equals(ctx.getFeature())) {
                final String msg = NLS.bind((String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinMessage, (Object)UMLPackage.eINSTANCE.getSendObjectAction_Request().getName());
                SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

                    @Override
                    protected Void openDialog() {
                        MessageDialog.openWarning((Shell)new Shell(Display.getDefault()), (String)CustomMessages.PinAndParameterSynchronizer_UndeleteablePinTitle, (String)msg);
                        return null;
                    }
                };
                opener.execute();
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected boolean testTransformPinCase(IValidationContext ctx) {
        List events = ctx.getAllEvents();
        Object removed = null;
        Object added = null;
        if (events.size() == 1) {
            Notification set = (Notification)events.get(0);
            if (1 == set.getEventType()) {
                removed = set.getOldValue();
                added = set.getNewValue();
            }
        } else if (events.size() == 2) {
            Notification remove = (Notification)events.get(0);
            Notification add = (Notification)events.get(1);
            if (4 == remove.getEventType() && 3 == add.getEventType()) {
                if (remove.getPosition() == add.getPosition() && add.getFeature().equals(remove.getFeature())) {
                    removed = remove.getOldValue();
                    added = add.getNewValue();
                }
            } else if (6 == remove.getEventType() && 5 == add.getEventType() && -1 == remove.getPosition() && add.getFeature().equals(remove.getFeature()) && remove.getOldValue() instanceof List && add.getNewValue() instanceof List) {
                ArrayList removeList = new ArrayList((List)remove.getOldValue());
                removeList.removeAll((List)add.getNewValue());
                ArrayList addList = new ArrayList((List)add.getNewValue());
                addList.removeAll((List)remove.getOldValue());
                if (removeList.size() == 1 && addList.size() == 1) {
                    removed = removeList.get(0);
                    added = addList.get(0);
                }
            }
        }
        if (removed instanceof Pin && added instanceof Pin) {
            Pin removedPin = (Pin)removed;
            Pin addedPin = (Pin)added;
            boolean similars = true;
            similars &= removedPin.getName() == null || removedPin.getName().equals(addedPin.getName());
            similars &= EcoreUtil.equals((EObject)removedPin.getType(), (EObject)addedPin.getType());
            similars &= removedPin.isOrdered() == addedPin.isOrdered();
            similars &= removedPin.isUnique() == addedPin.isUnique();
            similars &= EcoreUtil.equals((EObject)removedPin.getLowerValue(), (EObject)addedPin.getLowerValue());
            return similars &= EcoreUtil.equals((EObject)removedPin.getUpperValue(), (EObject)addedPin.getUpperValue());
        }
        return false;
    }

    protected IStatus handleOperationModification(Operation operation, IValidationContext ctx) {
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter().equals(ctx.getFeature())) {
                return this.handleParametersAdded((NamedElement)operation, ctx);
            }
        } else if ((EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter().equals(ctx.getFeature())) {
            return this.handleParametersRemoved((NamedElement)operation, ctx);
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleBehaviorModification(Behavior behavior, IValidationContext ctx) {
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (UMLPackage.eINSTANCE.getBehavior_OwnedParameter().equals(ctx.getFeature())) {
                return this.handleParametersAdded((NamedElement)behavior, ctx);
            }
        } else if ((EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getBehavior_OwnedParameter().equals(ctx.getFeature())) {
            return this.handleParametersRemoved((NamedElement)behavior, ctx);
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleSignalModification(Signal signal, IValidationContext ctx) {
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            if (UMLPackage.eINSTANCE.getSignal_OwnedAttribute().equals(ctx.getFeature())) {
                return this.handleAttributesAdded(signal, ctx);
            }
        } else if ((EMFEventType.REMOVE.equals(ctx.getEventType()) || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) && UMLPackage.eINSTANCE.getSignal_OwnedAttribute().equals(ctx.getFeature())) {
            return this.handleAttributesRemoved(signal, ctx);
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleParametersRemoved(NamedElement element, IValidationContext ctx) {
        HashMap<Integer, ParameterDirectionKind> removedParameterIndexes = new HashMap<Integer, ParameterDirectionKind>();
        for (Notification event : ctx.getAllEvents()) {
            List col;
            if (!UMLPackage.eINSTANCE.getBehavior_OwnedParameter().equals(event.getFeature()) && !UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter().equals(event.getFeature())) continue;
            Object removedValue = event.getOldValue();
            if (removedValue instanceof Parameter) {
                ParameterDirectionKind dir = ((Parameter)removedValue).getDirection();
                removedParameterIndexes.put(event.getPosition(), dir);
                continue;
            }
            if (!(removedValue instanceof List) || (col = (List)removedValue).isEmpty()) continue;
            int i = 0;
            while (i < col.size()) {
                Object object = col.get(i);
                if (object instanceof Parameter) {
                    removedParameterIndexes.put(i, ((Parameter)object).getDirection());
                }
                ++i;
            }
        }
        EList newParameters = Collections.emptyList();
        if (element instanceof Behavior) {
            newParameters = ((Behavior)element).getOwnedParameters();
        } else if (element instanceof Operation) {
            newParameters = ((Operation)element).getOwnedParameters();
        }
        LinkedList<Integer> removedInputPinIndexes = new LinkedList<Integer>();
        LinkedList<Integer> removedOutputPinIndexes = new LinkedList<Integer>();
        Iterator parametersIterator = newParameters.iterator();
        int correspondingParameterIndex = 0;
        int correspondingInputPinIndex = 0;
        int correspondingOutputPinIndex = 0;
        while (removedParameterIndexes.containsKey(correspondingParameterIndex) || parametersIterator.hasNext()) {
            if (removedParameterIndexes.containsKey(correspondingParameterIndex)) {
                switch ((ParameterDirectionKind)removedParameterIndexes.get(correspondingParameterIndex)) {
                    case IN_LITERAL: {
                        removedInputPinIndexes.add(correspondingInputPinIndex);
                        ++correspondingInputPinIndex;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        removedOutputPinIndexes.add(correspondingOutputPinIndex);
                        ++correspondingOutputPinIndex;
                        break;
                    }
                    case INOUT_LITERAL: {
                        removedInputPinIndexes.add(correspondingInputPinIndex);
                        ++correspondingInputPinIndex;
                        removedOutputPinIndexes.add(correspondingOutputPinIndex);
                        ++correspondingOutputPinIndex;
                    }
                }
            } else {
                Parameter nextParam = (Parameter)parametersIterator.next();
                switch (nextParam.getDirection()) {
                    case IN_LITERAL: {
                        ++correspondingInputPinIndex;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        ++correspondingOutputPinIndex;
                        break;
                    }
                    case INOUT_LITERAL: {
                        ++correspondingInputPinIndex;
                        ++correspondingOutputPinIndex;
                    }
                }
            }
            ++correspondingParameterIndex;
        }
        CompoundCommand globalCmd = new CompoundCommand();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions((Element)element);
        for (InvocationAction action : callingActions) {
            if (!(action instanceof CallAction)) continue;
            CompoundCommand cmd = this.getRemovePinsCmd((CallAction)action, removedInputPinIndexes, removedOutputPinIndexes);
            globalCmd.append((Command)cmd);
        }
        if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
            if (this.askForValidation(callingActions)) {
                globalCmd.execute();
            } else {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleParametersAdded(NamedElement element, IValidationContext ctx) {
        LinkedList<Parameter> addedParameters = new LinkedList<Parameter>();
        for (Notification event : ctx.getAllEvents()) {
            List col;
            if (!UMLPackage.eINSTANCE.getBehavior_OwnedParameter().equals(event.getFeature()) && !UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter().equals(event.getFeature())) continue;
            Object addedValue = event.getNewValue();
            if (addedValue instanceof Parameter) {
                addedParameters.add((Parameter)addedValue);
                continue;
            }
            if (!(addedValue instanceof List) || (col = (List)addedValue).isEmpty()) continue;
            int i = 0;
            while (i < col.size()) {
                Object object = col.get(i);
                if (object instanceof Parameter) {
                    addedParameters.add((Parameter)object);
                }
                ++i;
            }
        }
        EList newParameters = Collections.emptyList();
        if (element instanceof Behavior) {
            newParameters = ((Behavior)element).getOwnedParameters();
        } else if (element instanceof Operation) {
            newParameters = ((Operation)element).getOwnedParameters();
        }
        HashMap<Integer, TypedElement> addedInputPinMap = new HashMap<Integer, TypedElement>();
        HashMap<Integer, TypedElement> addedOutputPinMap = new HashMap<Integer, TypedElement>();
        int correspondingInputPinIndex = 0;
        int correspondingOutputPinIndex = 0;
        for (Parameter param : newParameters) {
            if (addedParameters.contains(param)) {
                switch (param.getDirection()) {
                    case IN_LITERAL: {
                        addedInputPinMap.put(correspondingInputPinIndex, (TypedElement)param);
                        ++correspondingInputPinIndex;
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        addedOutputPinMap.put(correspondingOutputPinIndex, (TypedElement)param);
                        ++correspondingOutputPinIndex;
                        break;
                    }
                    case INOUT_LITERAL: {
                        addedInputPinMap.put(correspondingInputPinIndex, (TypedElement)param);
                        ++correspondingInputPinIndex;
                        addedOutputPinMap.put(correspondingOutputPinIndex, (TypedElement)param);
                        ++correspondingOutputPinIndex;
                    }
                }
                continue;
            }
            switch (param.getDirection()) {
                case IN_LITERAL: {
                    ++correspondingInputPinIndex;
                    break;
                }
                case OUT_LITERAL: 
                case RETURN_LITERAL: {
                    ++correspondingOutputPinIndex;
                    break;
                }
                case INOUT_LITERAL: {
                    ++correspondingInputPinIndex;
                    ++correspondingOutputPinIndex;
                }
            }
        }
        CompoundCommand globalCmd = new CompoundCommand();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions((Element)element);
        for (InvocationAction action : callingActions) {
            if (!(action instanceof CallAction)) continue;
            CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, addedInputPinMap, addedOutputPinMap, null);
            globalCmd.append((Command)cmd);
        }
        if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
            if (this.askForValidation(callingActions)) {
                globalCmd.execute();
            } else {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleAttributesRemoved(Signal element, IValidationContext ctx) {
        HashSet<Integer> removedAttributeIndexes = new HashSet<Integer>();
        for (Notification event : ctx.getAllEvents()) {
            List col;
            if (!UMLPackage.eINSTANCE.getSignal_OwnedAttribute().equals(event.getFeature())) continue;
            Object removedValue = event.getOldValue();
            if (removedValue instanceof Property) {
                removedAttributeIndexes.add(event.getPosition());
                continue;
            }
            if (!(removedValue instanceof List) || (col = (List)removedValue).isEmpty()) continue;
            int i = 0;
            while (i < col.size()) {
                Object object = col.get(i);
                if (object instanceof Property) {
                    removedAttributeIndexes.add(i);
                }
                ++i;
            }
        }
        LinkedList<Integer> removedInputPinIndexes = new LinkedList<Integer>(removedAttributeIndexes);
        CompoundCommand globalCmd = new CompoundCommand();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions((Element)element);
        for (InvocationAction action : callingActions) {
            if (!(action instanceof SendSignalAction)) continue;
            CompoundCommand cmd = this.getRemovePinsCmd((SendSignalAction)action, removedInputPinIndexes);
            globalCmd.append((Command)cmd);
        }
        if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
            if (this.askForValidation(callingActions)) {
                globalCmd.execute();
            } else {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus handleAttributesAdded(Signal element, IValidationContext ctx) {
        LinkedList<Property> addedAttributes = new LinkedList<Property>();
        for (Notification event : ctx.getAllEvents()) {
            Object col;
            if (!UMLPackage.eINSTANCE.getSignal_OwnedAttribute().equals(event.getFeature())) continue;
            Object addedValue = event.getNewValue();
            if (addedValue instanceof Property) {
                addedAttributes.add((Property)addedValue);
                continue;
            }
            if (!(addedValue instanceof List) || (col = (List)addedValue).isEmpty()) continue;
            int i = 0;
            while (i < col.size()) {
                Object object = col.get(i);
                if (object instanceof Property) {
                    addedAttributes.add((Property)object);
                }
                ++i;
            }
        }
        EList newAttributes = Collections.emptyList();
        if (element instanceof Signal) {
            newAttributes = element.getOwnedAttributes();
        }
        HashMap<Integer, Property> addedInputPinMap = new HashMap<Integer, Property>();
        for (Property param : addedAttributes) {
            if (!newAttributes.contains(param)) continue;
            addedInputPinMap.put(newAttributes.indexOf(param), param);
        }
        CompoundCommand globalCmd = new CompoundCommand();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions((Element)element);
        for (InvocationAction action : callingActions) {
            if (!(action instanceof SendSignalAction)) continue;
            CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, addedInputPinMap, null);
            globalCmd.append((Command)cmd);
        }
        if (!globalCmd.isEmpty() && globalCmd.canExecute()) {
            if (this.askForValidation(callingActions)) {
                globalCmd.execute();
            } else {
                return ctx.createFailureStatus(new Object[0]);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected CompoundCommand getUpdateTargetPinsType(Operation operation) {
        CompoundCommand globalCmd = new CompoundCommand();
        Type type = null;
        Element owner = operation.getOwner();
        if (owner instanceof Type) {
            type = (Type)owner;
        }
        if (type != null) {
            TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
            for (InvocationAction action : PinAndParameterSynchronizer.getCallingActions((Element)operation)) {
                InputPin targetPin;
                if (!(action instanceof CallOperationAction) || (targetPin = ((CallOperationAction)action).getTarget()) == null) continue;
                Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)targetPin, (Object)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)type);
                globalCmd.append(cmd);
            }
        }
        return globalCmd;
    }

    protected CompoundCommand getRemovePinsCmd(CallAction action, List<Integer> removedInputPinsIndexes, List<Integer> removedOutputPinsIndexes) {
        CompoundCommand globalCmd = new CompoundCommand();
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        if (action instanceof CallBehaviorAction || action instanceof CallOperationAction) {
            ArrayList<InputPin> removedIn = new ArrayList<InputPin>(removedInputPinsIndexes.size());
            for (int i : removedInputPinsIndexes) {
                if (i >= action.getArguments().size()) continue;
                removedIn.add((InputPin)action.getArguments().get(i));
            }
            if (!removedIn.isEmpty()) {
                Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getInvocationAction_Argument(), removedIn);
                globalCmd.append(cmd);
            }
            ArrayList<OutputPin> removedOut = new ArrayList<OutputPin>(removedInputPinsIndexes.size());
            for (int i : removedOutputPinsIndexes) {
                if (i >= action.getResults().size()) continue;
                removedOut.add((OutputPin)action.getResults().get(i));
            }
            if (!removedOut.isEmpty()) {
                Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getCallAction_Result(), removedOut);
                globalCmd.append(cmd);
            }
        }
        return globalCmd;
    }

    protected CompoundCommand getRemovePinsCmd(SendSignalAction action, List<Integer> removedInputPinsIndexes) {
        CompoundCommand globalCmd = new CompoundCommand();
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        if (action instanceof SendSignalAction) {
            ArrayList<InputPin> removedIn = new ArrayList<InputPin>(removedInputPinsIndexes.size());
            for (int i : removedInputPinsIndexes) {
                if (i >= action.getArguments().size()) continue;
                removedIn.add((InputPin)action.getArguments().get(i));
            }
            if (!removedIn.isEmpty()) {
                Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getInvocationAction_Argument(), removedIn);
                globalCmd.append(cmd);
            }
        }
        return globalCmd;
    }

    protected static CompoundCommand getAddPinsCmd(InvocationAction invocationAction, Map<Integer, TypedElement> addedInputPinMap, Map<Integer, TypedElement> addedOutputPinMap, EClass preferredPinClass) {
        CompoundCommand globalCmd = new CompoundCommand();
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        if (invocationAction instanceof CallBehaviorAction || invocationAction instanceof CallOperationAction || invocationAction instanceof SendSignalAction || invocationAction instanceof BroadcastSignalAction) {
            int nextKey = addedInputPinMap.size() + invocationAction.getArguments().size();
            int numberOfPinsToAdd = addedInputPinMap.size();
            while (numberOfPinsToAdd > 0) {
                if (addedInputPinMap.containsKey(nextKey)) {
                    InputPin pin = PinAndParameterSynchronizer.createInputPin(addedInputPinMap.get(nextKey), preferredPinClass);
                    int addIndex = nextKey - --numberOfPinsToAdd;
                    Command cmd = AddCommand.create((EditingDomain)editingdomain, (Object)invocationAction, (Object)UMLPackage.eINSTANCE.getInvocationAction_Argument(), (Object)pin, (int)addIndex);
                    LinkPinToParameter link = new LinkPinToParameter((Pin)pin, addedInputPinMap.get(nextKey));
                    CreatePinToParameterLinkEAnnotation linkCommand = new CreatePinToParameterLinkEAnnotation(EditorUtils.getTransactionalEditingDomain(), link);
                    globalCmd.append(cmd);
                    if (linkCommand != null && linkCommand.canExecute()) {
                        globalCmd.append((Command)linkCommand);
                    }
                }
                --nextKey;
            }
            if (invocationAction instanceof CallAction) {
                CallAction callAction = (CallAction)invocationAction;
                nextKey = addedOutputPinMap.size() + callAction.getResults().size();
                numberOfPinsToAdd = addedOutputPinMap.size();
                while (numberOfPinsToAdd > 0) {
                    if (addedOutputPinMap.containsKey(nextKey)) {
                        OutputPin pin = PinAndParameterSynchronizer.createOutputPin(addedOutputPinMap.get(nextKey));
                        int addIndex = nextKey - --numberOfPinsToAdd;
                        Command cmd = AddCommand.create((EditingDomain)editingdomain, (Object)callAction, (Object)UMLPackage.eINSTANCE.getCallAction_Result(), (Object)pin, (int)addIndex);
                        globalCmd.append(cmd);
                        LinkPinToParameter link = new LinkPinToParameter((Pin)pin, addedOutputPinMap.get(nextKey));
                        CreatePinToParameterLinkEAnnotation linkCommand = new CreatePinToParameterLinkEAnnotation(EditorUtils.getTransactionalEditingDomain(), link);
                        if (linkCommand != null) {
                            globalCmd.append((Command)linkCommand);
                        }
                    }
                    --nextKey;
                }
            }
        }
        return globalCmd;
    }

    public static CompoundCommand getAddPinsCmd(InvocationAction action, Map<Integer, Property> addedInputPinMap, EClass preferredPinClass) {
        CompoundCommand globalCmd = new CompoundCommand();
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        int nextKey = addedInputPinMap.size() + action.getArguments().size();
        int numberOfPinsToAdd = addedInputPinMap.size();
        while (numberOfPinsToAdd > 0) {
            if (addedInputPinMap.containsKey(nextKey)) {
                InputPin pin = PinAndParameterSynchronizer.createInputPin((TypedElement)addedInputPinMap.get(nextKey), preferredPinClass);
                int addIndex = nextKey - --numberOfPinsToAdd;
                Command cmd = AddCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getInvocationAction_Argument(), (Object)pin, (int)addIndex);
                globalCmd.append(cmd);
                LinkPinToParameter link = new LinkPinToParameter((Pin)pin, (TypedElement)addedInputPinMap.get(nextKey));
                CreatePinToParameterLinkEAnnotation linkCommand = new CreatePinToParameterLinkEAnnotation(WorkspaceEditingDomainFactory.INSTANCE.getEditingDomain(action.eResource().getResourceSet()), link);
                if (linkCommand != null && linkCommand.canExecute()) {
                    globalCmd.append((Command)linkCommand);
                }
            }
            --nextKey;
        }
        return globalCmd;
    }

    protected static OutputPin createOutputPin(TypedElement typedElement) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        pin.setName(typedElement.getName());
        pin.setType(typedElement.getType());
        if (typedElement instanceof Property) {
            ValueSpecification upperValue;
            Property property = (Property)typedElement;
            pin.setIsOrdered(property.isOrdered());
            pin.setIsUnique(property.isUnique());
            ValueSpecification lowerValue = property.getLowerValue();
            if (lowerValue != null) {
                Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(lowerValue));
                copy.execute();
                Collection result = copy.getResult();
                Object valueToAffect = null;
                if (!result.isEmpty()) {
                    valueToAffect = result.iterator().next();
                }
                if (valueToAffect instanceof ValueSpecification) {
                    pin.setLowerValue((ValueSpecification)valueToAffect);
                }
            }
            if ((upperValue = property.getUpperValue()) != null) {
                Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(upperValue));
                copy.execute();
                Collection result = copy.getResult();
                Object valueToAffect = null;
                if (!result.isEmpty()) {
                    valueToAffect = result.iterator().next();
                }
                if (valueToAffect instanceof ValueSpecification) {
                    pin.setUpperValue((ValueSpecification)valueToAffect);
                }
            }
        }
        return pin;
    }

    protected static InputPin createTargetPin(Operation operation) {
        Element owningType;
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (operation != null && (owningType = operation.getOwner()) instanceof Type) {
            pin.setType((Type)owningType);
        }
        pin.setName("target");
        return pin;
    }

    protected OutputPin createResultPin(Classifier classifier) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (classifier != null) {
            pin.setType((Type)classifier);
        }
        pin.setName("result");
        return pin;
    }

    protected OutputPin createResultPin(Variable var) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (var != null) {
            pin.setType(var.getType());
        }
        pin.setName("result");
        return pin;
    }

    public static InputPin createRequestPin() {
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        pin.setName(REQUEST_PIN_INITIALIZATION_NAME);
        return pin;
    }

    public static InputPin createInputPin(TypedElement typedElement, EClass preferredPinClass) {
        Object pin = UMLPackage.eINSTANCE.getValuePin().equals(preferredPinClass) ? UMLFactory.eINSTANCE.createValuePin() : (UMLPackage.eINSTANCE.getActionInputPin().equals(preferredPinClass) ? UMLFactory.eINSTANCE.createActionInputPin() : UMLFactory.eINSTANCE.createInputPin());
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        pin.setName(typedElement.getName());
        pin.setType(typedElement.getType());
        if (pin instanceof Property) {
            ValueSpecification upperValue;
            Property property = (Property)pin;
            pin.setIsOrdered(property.isOrdered());
            pin.setIsUnique(property.isUnique());
            ValueSpecification lowerValue = property.getLowerValue();
            if (lowerValue != null) {
                Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(lowerValue));
                copy.execute();
                Collection result = copy.getResult();
                Object valueToAffect = null;
                if (!result.isEmpty()) {
                    valueToAffect = result.iterator().next();
                }
                if (valueToAffect instanceof ValueSpecification) {
                    pin.setLowerValue((ValueSpecification)valueToAffect);
                }
            }
            if ((upperValue = property.getUpperValue()) != null) {
                Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(upperValue));
                copy.execute();
                Collection result = copy.getResult();
                Object valueToAffect = null;
                if (!result.isEmpty()) {
                    valueToAffect = result.iterator().next();
                }
                if (valueToAffect instanceof ValueSpecification) {
                    pin.setUpperValue((ValueSpecification)valueToAffect);
                }
            }
        }
        return pin;
    }

    protected static InputPin createInputPin(Parameter parameter, EClass preferredPinClass) {
        ValueSpecification upperValue;
        Object pin = UMLPackage.eINSTANCE.getValuePin().equals(preferredPinClass) ? UMLFactory.eINSTANCE.createValuePin() : (UMLPackage.eINSTANCE.getActionInputPin().equals(preferredPinClass) ? UMLFactory.eINSTANCE.createActionInputPin() : UMLFactory.eINSTANCE.createInputPin());
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        pin.setName(parameter.getName());
        pin.setType(parameter.getType());
        pin.setIsOrdered(parameter.isOrdered());
        pin.setIsUnique(parameter.isUnique());
        ValueSpecification lowerValue = parameter.getLowerValue();
        if (lowerValue != null) {
            Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(lowerValue));
            copy.execute();
            Collection result = copy.getResult();
            Object valueToAffect = null;
            if (!result.isEmpty()) {
                valueToAffect = result.iterator().next();
            }
            if (valueToAffect instanceof ValueSpecification) {
                pin.setLowerValue((ValueSpecification)valueToAffect);
            }
        }
        if ((upperValue = parameter.getUpperValue()) != null) {
            Command copy = CopyCommand.create((EditingDomain)EditorUtils.getTransactionalEditingDomain(), Collections.singleton(upperValue));
            copy.execute();
            Collection result = copy.getResult();
            Object valueToAffect = null;
            if (!result.isEmpty()) {
                valueToAffect = result.iterator().next();
            }
            if (valueToAffect instanceof ValueSpecification) {
                pin.setUpperValue((ValueSpecification)valueToAffect);
            }
        }
        return pin;
    }

    protected CompoundCommand getResetPinsCmd(AddStructuralFeatureValueAction action) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getValue() == null) {
            InputPin valuePin = PinAndParameterSynchronizer.createValuePinInAddStructuralFeatureAction((StructuralFeatureAction)action);
            Command cmdValuePin = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getWriteStructuralFeatureAction_Value(), (Object)valuePin);
            globalCmd.append(cmdValuePin);
        }
        if (action.getObject() == null) {
            InputPin objectPin = PinAndParameterSynchronizer.createObjectPinInStructuralFeatureAction((StructuralFeatureAction)action);
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getStructuralFeatureAction_Object(), (Object)objectPin);
            globalCmd.append(cmd);
        }
        if (action.getResult() == null) {
            OutputPin resultPin = PinAndParameterSynchronizer.createResultPinInStructuralAction((StructuralFeatureAction)action);
            Command cmdResultPin = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getWriteStructuralFeatureAction_Result(), (Object)resultPin);
            globalCmd.append(cmdResultPin);
        }
        return globalCmd;
    }

    protected CompoundCommand getResetPinsCmd(ReadVariableAction action) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getResult() == null) {
            OutputPin resultPin = this.createResultPin(action.getVariable());
            Command cmdResultPin = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getReadVariableAction_Result(), (Object)resultPin);
            globalCmd.append(cmdResultPin);
        }
        return globalCmd;
    }

    protected CompoundCommand getResetPinsCmd(AddVariableValueAction action) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getValue() == null) {
            InputPin valuePin = this.createValuePinInAddVariableValueAction(action.getVariable());
            Command cmdValuePin = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getWriteVariableAction_Value(), (Object)valuePin);
            globalCmd.append(cmdValuePin);
        }
        if (action.getInsertAt() == null) {
            InputPin insertAtPin = UMLFactory.eINSTANCE.createInputPin();
            PinAndParameterSynchronizer.assignUpperBound((ObjectNode)insertAtPin);
            insertAtPin.setName(INSERT_AT_IN_ADD_VARIABLE_VALUE_ACTION);
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getAddVariableValueAction_InsertAt(), (Object)insertAtPin);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    public static CompoundCommand getResetPinsCmd(DestroyObjectAction action) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getTarget() == null) {
            InputPin targetPin = UMLFactory.eINSTANCE.createInputPin();
            PinAndParameterSynchronizer.assignUpperBound((ObjectNode)targetPin);
            targetPin.setName("target");
            Command cmdTargetPin = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getDestroyObjectAction_Target(), (Object)targetPin);
            globalCmd.append(cmdTargetPin);
        }
        return globalCmd;
    }

    public static InputPin createValuePinInAddStructuralFeatureAction(StructuralFeatureAction action) {
        Type owningType;
        StructuralFeature feature;
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (action != null && (feature = action.getStructuralFeature()) != null && feature.getType() != null && (owningType = feature.getType()) instanceof Type) {
            pin.setType(owningType);
        }
        pin.setName("value");
        return pin;
    }

    protected InputPin createValuePinInAddVariableValueAction(Variable var) {
        Type owningType;
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (var != null && (owningType = var.getType()) instanceof Type) {
            pin.setType(owningType);
        }
        pin.setName("value");
        return pin;
    }

    public static CompoundCommand getResetPinsCmd(SendObjectAction action) {
        Command cmd;
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getTarget() == null) {
            InputPin targetPin = PinAndParameterSynchronizer.createTargetPin(null);
            cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getSendObjectAction_Target(), (Object)targetPin);
            globalCmd.append(cmd);
        }
        if (action.getRequest() == null) {
            InputPin requestPin = PinAndParameterSynchronizer.createRequestPin();
            cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getSendObjectAction_Request(), (Object)requestPin);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    protected CompoundCommand getResetPinsCmd(ReadStructuralFeatureAction action) {
        Command cmd;
        TransactionalEditingDomain editingdomain;
        try {
            editingdomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)action);
        }
        catch (ServiceException ex) {
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)ex.getMessage(), (Throwable)ex);
            return null;
        }
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getResult() == null) {
            OutputPin resultPin = PinAndParameterSynchronizer.createResultPinInStructuralAction((StructuralFeatureAction)action);
            cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getReadStructuralFeatureAction_Result(), (Object)resultPin);
            globalCmd.append(cmd);
        }
        if (action.getObject() == null) {
            InputPin objectPin = PinAndParameterSynchronizer.createObjectPinInStructuralFeatureAction((StructuralFeatureAction)action);
            cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getStructuralFeatureAction_Object(), (Object)objectPin);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    public static InputPin createObjectPinInStructuralFeatureAction(StructuralFeatureAction action) {
        Type type;
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        if (action != null && (type = PinAndParameterSynchronizer.getTypeFromStructuralFeature(action)) != null) {
            pin.setType(type);
        }
        pin.setName(OBJECT_PIN_IN_READS_STRUCTURAL_ACTION);
        return pin;
    }

    public static Type getTypeFromStructuralFeature(StructuralFeatureAction action) {
        Element owner;
        Type type = null;
        StructuralFeature feature = action.getStructuralFeature();
        if (feature != null && (owner = feature.getOwner()) != null && feature.getFeaturingClassifiers().contains((Object)owner)) {
            type = (Type)owner;
        }
        return type;
    }

    public static OutputPin createResultPinInStructuralAction(StructuralFeatureAction action) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        PinAndParameterSynchronizer.assignUpperBound((ObjectNode)pin);
        Type type = PinAndParameterSynchronizer.getTypeFromStructuralFeature(action);
        if (type != null) {
            pin.setType(type);
        }
        pin.setName("result");
        return pin;
    }

    private static void assignUpperBound(ObjectNode node) {
        LiteralInteger literal = UMLFactory.eINSTANCE.createLiteralInteger();
        literal.setValue(1);
        node.setUpperBound((ValueSpecification)literal);
    }

    protected CompoundCommand getResetPinsCmd(CreateObjectAction action) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        if (action.getResult() == null) {
            OutputPin resultPin = this.createResultPin((Classifier)null);
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getCreateObjectAction_Result(), (Object)resultPin);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    public static TypedElement getLinkedParemeter(Pin p, XMIResource xmiResource) {
        String id;
        EObject pa;
        EAnnotation eAnnotation;
        if (p != null && xmiResource != null && (eAnnotation = p.getEAnnotation("PinToParameterLink")) != null && !eAnnotation.getDetails().isEmpty() && (pa = xmiResource.getEObject(id = (String)((Map.Entry)eAnnotation.getDetails().get(0)).getValue())) instanceof TypedElement) {
            return (TypedElement)pa;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompoundCommand getResetPinsCmd(InvocationAction action) {
        InputPin targetPin;
        void var4_10;
        void var7_15;
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        CompoundCommand globalCmd = new CompoundCommand();
        Behavior behaviorStructural = null;
        List list = Collections.emptyList();
        if (action instanceof CallBehaviorAction) {
            behaviorStructural = ((CallBehaviorAction)action).getBehavior();
            if (behaviorStructural == null) return globalCmd;
            EList eList = behaviorStructural.getOwnedParameters();
        } else if (action instanceof CallOperationAction) {
            behaviorStructural = ((CallOperationAction)action).getOperation();
            if (behaviorStructural == null) return globalCmd;
            EList eList = ((Operation)behaviorStructural).getOwnedParameters();
        } else if (action instanceof SendSignalAction) {
            behaviorStructural = ((SendSignalAction)action).getSignal();
            if (behaviorStructural == null) return globalCmd;
            EList eList = ((Signal)behaviorStructural).getOwnedAttributes();
        } else if (action instanceof BroadcastSignalAction) {
            Signal signal = ((BroadcastSignalAction)action).getSignal();
            if (signal != null) {
                behaviorStructural = signal;
                EList eList = ((Signal)behaviorStructural).getOwnedAttributes();
            } else {
                List list2 = Collections.emptyList();
            }
        }
        XMIResource xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behaviorStructural);
        ArrayList<TypedElement> parameterWhichPinNotDeleted = new ArrayList<TypedElement>();
        ArrayList arrayList = Lists.newArrayList((Iterable)action.getArguments());
        if (action instanceof CallAction) {
            Iterable iterable = Iterables.concat((Iterable)arrayList, (Iterable)((CallAction)action).getResults());
        }
        ArrayList removesCommand = Lists.newArrayList();
        for (Pin pin : var7_15) {
            if (SynchronizePinsParametersHandler.isUpToDate(pin, xmiResource)) {
                TypedElement pa = PinAndParameterSynchronizer.getLinkedParemeter(pin, xmiResource);
                parameterWhichPinNotDeleted.add(pa);
                continue;
            }
            EReference feature = null;
            if (pin instanceof InputPin) {
                feature = UMLPackage.eINSTANCE.getInvocationAction_Argument();
            } else if (pin instanceof OutputPin) {
                feature = UMLPackage.eINSTANCE.getCallAction_Result();
            }
            Command cmd = RemoveCommand.create((EditingDomain)editingdomain, (Object)action, (Object)feature, (Object)pin);
            if (!cmd.canExecute()) continue;
            removesCommand.add(cmd);
        }
        HashMap<Integer, TypedElement> inParams = new HashMap<Integer, TypedElement>();
        HashMap<Integer, TypedElement> outParams = new HashMap<Integer, TypedElement>();
        PinAndParameterSynchronizer.splitParameters((List<? extends TypedElement>)var4_10, parameterWhichPinNotDeleted, inParams, outParams, (Action)action);
        if (!inParams.isEmpty() || !outParams.isEmpty()) {
            CompoundCommand cmd = PinAndParameterSynchronizer.getAddPinsCmd(action, inParams, outParams, null);
            globalCmd.append((Command)cmd);
        }
        for (Command rmComand : removesCommand) {
            globalCmd.append(rmComand);
        }
        if (action instanceof CallOperationAction) {
            Operation operation = ((CallOperationAction)action).getOperation();
            if (operation == null) return globalCmd;
            targetPin = PinAndParameterSynchronizer.createTargetPin(operation);
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getCallOperationAction_Target(), (Object)targetPin);
            globalCmd.append(cmd);
            return globalCmd;
        } else {
            SendSignalAction sendSignalAction;
            if (!(action instanceof SendSignalAction) || (sendSignalAction = (SendSignalAction)action).getTarget() != null) return globalCmd;
            targetPin = PinAndParameterSynchronizer.createTargetPin(null);
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)action, (Object)UMLPackage.eINSTANCE.getSendSignalAction_Target(), (Object)targetPin);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    /*
     * WARNING - void declaration
     */
    public static void splitParameters(List<? extends TypedElement> allParams, Collection<? extends TypedElement> paramsToIgnore, Map<Integer, TypedElement> inParams, Map<Integer, TypedElement> outParams, Action action) {
        block7: {
            block6: {
                if (!(action instanceof CallAction)) break block6;
                Integer inIndex = 0;
                Integer n = 0;
                for (TypedElement typedElement : allParams) {
                    void var6_8;
                    if (!(typedElement instanceof Parameter)) continue;
                    Parameter param = (Parameter)typedElement;
                    ParameterDirectionKind direction = param.getDirection();
                    if (direction == ParameterDirectionKind.IN_LITERAL || direction == ParameterDirectionKind.INOUT_LITERAL) {
                        if (!paramsToIgnore.contains(param)) {
                            inParams.put(inIndex, (TypedElement)param);
                        }
                        inIndex = inIndex + 1;
                    }
                    if (direction != ParameterDirectionKind.OUT_LITERAL && direction != ParameterDirectionKind.INOUT_LITERAL && direction != ParameterDirectionKind.RETURN_LITERAL) continue;
                    if (!paramsToIgnore.contains(param)) {
                        outParams.put((Integer)var6_8, (TypedElement)param);
                    }
                    Integer n2 = var6_8.intValue() + 1;
                }
                break block7;
            }
            if (!(action instanceof InvocationAction)) break block7;
            Integer inIndex = 0;
            for (TypedElement typedElement : allParams) {
                if (!paramsToIgnore.contains(typedElement)) {
                    inParams.put(inIndex, typedElement);
                }
                inIndex = inIndex + 1;
            }
        }
    }

    public static XMIResource getXMIResource(Element behaviorStructural) {
        Resource resource;
        XMIResource xmiResource = null;
        if (behaviorStructural != null && (resource = behaviorStructural.eResource()) instanceof XMIResource) {
            xmiResource = (XMIResource)resource;
        }
        return xmiResource;
    }

    protected CompoundCommand getSetPinsNamesCmd(List<Pin> pins, String name) {
        CompoundCommand globalCmd = new CompoundCommand();
        if (pins == null || name == null || "".equals(name)) {
            return globalCmd;
        }
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        for (Pin pin : pins) {
            if (pin.getName() != null) continue;
            Command cmd = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)name);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    protected CompoundCommand getUpdatePinsCmd(List<Pin> pins, Type type, boolean ordered, boolean unique, int lower, ValueSpecification lowerValue, int upper, ValueSpecification upperValue) {
        CompoundCommand globalCmd = new CompoundCommand();
        if (pins == null) {
            return globalCmd;
        }
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        for (Pin pin : pins) {
            Command cmd;
            Collection result;
            Command copy;
            Object affectedvalue;
            Command cmd2;
            if (!EcoreUtil.equals((EObject)pin.getType(), (EObject)type)) {
                cmd2 = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)type);
                globalCmd.append(cmd2);
            }
            if (pin.isOrdered() != ordered) {
                cmd2 = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered(), (Object)ordered);
                globalCmd.append(cmd2);
            }
            if (pin.isUnique() != unique) {
                cmd2 = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique(), (Object)unique);
                globalCmd.append(cmd2);
            }
            if (!EcoreUtil.equals((EObject)pin.getLowerValue(), (EObject)lowerValue)) {
                affectedvalue = null;
                if (lowerValue != null) {
                    copy = CopyCommand.create((EditingDomain)editingdomain, Collections.singleton(lowerValue));
                    copy.execute();
                    result = copy.getResult();
                    if (!result.isEmpty()) {
                        affectedvalue = result.iterator().next();
                    }
                }
                cmd = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), affectedvalue);
                globalCmd.append(cmd);
            }
            if (EcoreUtil.equals((EObject)pin.getUpperValue(), (EObject)upperValue)) continue;
            affectedvalue = null;
            if (upperValue != null) {
                copy = CopyCommand.create((EditingDomain)editingdomain, Collections.singleton(upperValue));
                copy.execute();
                result = copy.getResult();
                if (!result.isEmpty()) {
                    affectedvalue = result.iterator().next();
                }
            }
            cmd = SetCommand.create((EditingDomain)editingdomain, (Object)pin, (Object)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), affectedvalue);
            globalCmd.append(cmd);
        }
        return globalCmd;
    }

    protected static NamedElement getInvokedObject(Pin pin) {
        Element action = pin.getOwner();
        if (action instanceof CallOperationAction) {
            Operation operation = ((CallOperationAction)action).getOperation();
            return operation;
        }
        if (action instanceof CallBehaviorAction) {
            Behavior behavior = ((CallBehaviorAction)action).getBehavior();
            return behavior;
        }
        if (action instanceof SendSignalAction) {
            Signal signal = ((SendSignalAction)action).getSignal();
            return signal;
        }
        return null;
    }

    protected static List<Pin> getPins(Property property) {
        Element owner = property.getOwner();
        if (owner instanceof Signal) {
            LinkedList<Pin> listOfPins = new LinkedList<Pin>();
            int inIndex = ((Signal)owner).getAttributes().indexOf((Object)property);
            List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions(owner);
            for (InvocationAction action : callingActions) {
                Pin pin = (Pin)((SendSignalAction)action).getArguments().get(inIndex);
                if (pin == null) continue;
                listOfPins.add(pin);
            }
            return listOfPins;
        }
        return Collections.emptyList();
    }

    protected static List<Pin> getPins(Parameter parameter) {
        Element owner = parameter.getOwner();
        List<InvocationAction> callingActions = PinAndParameterSynchronizer.getCallingActions(owner);
        LinkedList<Pin> listOfPins = new LinkedList<Pin>();
        int inIndex = -1;
        int outIndex = -1;
        switch (parameter.getDirection()) {
            case IN_LITERAL: {
                inIndex = PinAndParameterSynchronizer.getIndex((TypedElement)parameter, true);
                break;
            }
            case OUT_LITERAL: 
            case RETURN_LITERAL: {
                outIndex = PinAndParameterSynchronizer.getIndex((TypedElement)parameter, false);
                break;
            }
            case INOUT_LITERAL: {
                inIndex = PinAndParameterSynchronizer.getIndex((TypedElement)parameter, true);
                outIndex = PinAndParameterSynchronizer.getIndex((TypedElement)parameter, false);
            }
        }
        if (owner instanceof Operation) {
            for (InvocationAction action : callingActions) {
                switch (parameter.getDirection()) {
                    case IN_LITERAL: {
                        Pin pin = (Pin)((CallOperationAction)action).getArguments().get(inIndex);
                        if (pin == null) break;
                        listOfPins.add(pin);
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        Pin pin = (Pin)((CallOperationAction)action).getResults().get(outIndex);
                        if (pin == null) break;
                        listOfPins.add(pin);
                        break;
                    }
                    case INOUT_LITERAL: {
                        Pin pin = (Pin)((CallOperationAction)action).getArguments().get(inIndex);
                        if (pin != null) {
                            listOfPins.add(pin);
                        }
                        if ((pin = (Pin)((CallOperationAction)action).getResults().get(outIndex)) == null) break;
                        listOfPins.add(pin);
                    }
                }
            }
            return listOfPins;
        }
        if (owner instanceof Behavior) {
            for (InvocationAction action : callingActions) {
                switch (parameter.getDirection()) {
                    case IN_LITERAL: {
                        Pin pin = (Pin)((CallBehaviorAction)action).getArguments().get(inIndex);
                        if (pin == null) break;
                        listOfPins.add(pin);
                        break;
                    }
                    case OUT_LITERAL: 
                    case RETURN_LITERAL: {
                        Pin pin = (Pin)((CallBehaviorAction)action).getResults().get(outIndex);
                        if (pin == null) break;
                        listOfPins.add(pin);
                        break;
                    }
                    case INOUT_LITERAL: {
                        Pin pin = (Pin)((CallBehaviorAction)action).getArguments().get(inIndex);
                        if (pin != null) {
                            listOfPins.add(pin);
                        }
                        if ((pin = (Pin)((CallBehaviorAction)action).getResults().get(outIndex)) == null) break;
                        listOfPins.add(pin);
                    }
                }
            }
            return listOfPins;
        }
        return Collections.emptyList();
    }

    protected static int getIndex(TypedElement typedElement, boolean in) {
        if (typedElement == null) {
            return -1;
        }
        Element owner = typedElement.getOwner();
        EList parametersList = Collections.emptyList();
        if (owner instanceof Operation) {
            parametersList = ((Operation)owner).getOwnedParameters();
        } else if (owner instanceof Behavior) {
            parametersList = ((Behavior)owner).getOwnedParameters();
        }
        int index = 0;
        for (Parameter param : parametersList) {
            if (param.equals(typedElement)) {
                return index;
            }
            if (in && (ParameterDirectionKind.IN_LITERAL.equals((Object)param.getDirection()) || ParameterDirectionKind.INOUT_LITERAL.equals((Object)param.getDirection()))) {
                ++index;
                continue;
            }
            if (in || !ParameterDirectionKind.OUT_LITERAL.equals((Object)param.getDirection()) && !ParameterDirectionKind.RETURN_LITERAL.equals((Object)param.getDirection()) && !ParameterDirectionKind.INOUT_LITERAL.equals((Object)param.getDirection())) continue;
            ++index;
        }
        return -1;
    }

    protected boolean askForValidation(final List<? extends NamedElement> listOfActions) {
        SafeDialogOpenerDuringValidation<Boolean> opener = new SafeDialogOpenerDuringValidation<Boolean>(){

            @Override
            protected Boolean openDialog() {
                return ConfirmPinAndParameterSyncDialog.openConfirmFromParameter(Display.getDefault().getActiveShell(), listOfActions, labelProvider);
            }
        };
        return (Boolean)opener.execute();
    }
}

