/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.activity.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.ActionInputPin;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValuePin;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.activity/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLActivityDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLActivityDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLActivityDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 2001: {
                if (!UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3059;
            }
            case 3007: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3008: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3018;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 3010: {
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3021(containerView, (ActionInputPin)domainElement)) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3022(containerView, (ValuePin)domainElement)) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3023(containerView, (InputPin)domainElement)) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3025(containerView, (ValuePin)domainElement)) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3026(containerView, (ActionInputPin)domainElement)) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3027(containerView, (InputPin)domainElement)) break;
                return 3027;
            }
            case 3042: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3046(containerView, (ValuePin)domainElement)) {
                    return 3046;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3047(containerView, (ActionInputPin)domainElement)) {
                    return 3047;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3048(containerView, (InputPin)domainElement)) {
                    return 3048;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3049(containerView, (ValuePin)domainElement)) {
                    return 3049;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3050(containerView, (ActionInputPin)domainElement)) {
                    return 3050;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3051(containerView, (InputPin)domainElement)) break;
                return 3051;
            }
            case 3052: {
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3053(containerView, (ActionInputPin)domainElement)) {
                    return 3053;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3054(containerView, (ValuePin)domainElement)) {
                    return 3054;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3055(containerView, (InputPin)domainElement)) {
                    return 3055;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3060(containerView, (ValuePin)domainElement)) {
                    return 3060;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3061(containerView, (ActionInputPin)domainElement)) {
                    return 3061;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3062(containerView, (InputPin)domainElement)) break;
                return 3062;
            }
            case 3063: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3064;
            }
            case 3076: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3077;
            }
            case 3070: {
                if (UMLPackage.eINSTANCE.getExpansionNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isExpansionNode_3074(containerView, (ExpansionNode)domainElement)) {
                    return 3074;
                }
                if (!UMLPackage.eINSTANCE.getExpansionNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isExpansionNode_3075(containerView, (ExpansionNode)domainElement)) break;
                return 3075;
            }
            case 3071: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3105;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3111;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3109;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3110;
            }
            case 3081: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3084;
            }
            case 3083: {
                if (!UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3059;
            }
            case 3086: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3087;
            }
            case 3088: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3089;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3090;
            }
            case 3091: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3092(containerView, (InputPin)domainElement)) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3093(containerView, (InputPin)domainElement)) {
                    return 3093;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3094;
            }
            case 3095: {
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3096(containerView, (InputPin)domainElement)) break;
                return 3096;
            }
            case 3097: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isOutputPin_3098(containerView, (OutputPin)domainElement)) break;
                return 3098;
            }
            case 3099: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3100(containerView, (InputPin)domainElement)) {
                    return 3100;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3101(containerView, (InputPin)domainElement)) break;
                return 3101;
            }
            case 3102: {
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3103(containerView, (InputPin)domainElement)) break;
                return 3103;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getInterruptibleActivityRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3068;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7008: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7009: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7010: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7012: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7006: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3112;
            }
            case 7014: {
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7015: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7016: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7013: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034(containerView, (DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035(containerView, (DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036(containerView, (TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037(containerView, (TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032(containerView, (IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033(containerView, (IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011(containerView, (Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012(containerView, (Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getInterruptibleActivityRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3068;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (!UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3059;
            }
        }
        return -1;
    }

    private static boolean isExpansionNode_3075(View containerView, ExpansionNode domainElement) {
        return UMLVisualIDRegistry.isExpansionNode_3075(domainElement);
    }

    private static boolean isExpansionNode_3074(View containerView, ExpansionNode domainElement) {
        return UMLVisualIDRegistry.isExpansionNode_3074(domainElement);
    }

    private static boolean isValuePin_3022(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3022(domainElement);
    }

    private static boolean isValuePin_3025(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3025(domainElement);
    }

    private static boolean isValuePin_3046(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3046(domainElement);
    }

    private static boolean isValuePin_3049(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3049(domainElement);
    }

    private static boolean isValuePin_3054(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3054(domainElement);
    }

    private static boolean isValuePin_3060(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3060(domainElement);
    }

    private static boolean isInputPin_3023(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3023(domainElement);
    }

    private static boolean isInputPin_3027(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3027(domainElement);
    }

    private static boolean isInputPin_3048(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3048(domainElement);
    }

    private static boolean isInputPin_3051(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3051(domainElement);
    }

    private static boolean isInputPin_3055(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3055(domainElement);
    }

    private static boolean isInputPin_3062(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3062(domainElement);
    }

    private static boolean isActionInputPin_3026(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3026(domainElement);
    }

    private static boolean isActionInputPin_3021(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3021(domainElement);
    }

    private static boolean isActionInputPin_3047(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3047(domainElement);
    }

    private static boolean isActionInputPin_3050(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3050(domainElement);
    }

    private static boolean isActionInputPin_3053(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3053(domainElement);
    }

    private static boolean isActionInputPin_3061(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3061(domainElement);
    }

    private static boolean isConstraint_3011(View containerView, Constraint domainElement) {
        return UMLVisualIDRegistry.isConstraint_3011(domainElement);
    }

    private static boolean isConstraint_3012(View containerView, Constraint domainElement) {
        return UMLVisualIDRegistry.isConstraint_3012(domainElement);
    }

    private static boolean isIntervalConstraint_3032(View containerView, IntervalConstraint domainElement) {
        return UMLVisualIDRegistry.isIntervalConstraint_3032(domainElement);
    }

    private static boolean isIntervalConstraint_3033(View containerView, IntervalConstraint domainElement) {
        return UMLVisualIDRegistry.isIntervalConstraint_3033(domainElement);
    }

    private static boolean isDurationConstraint_3034(View containerView, DurationConstraint domainElement) {
        return UMLVisualIDRegistry.isDurationConstraint_3034(domainElement);
    }

    private static boolean isDurationConstraint_3035(View containerView, DurationConstraint domainElement) {
        return UMLVisualIDRegistry.isDurationConstraint_3035(domainElement);
    }

    private static boolean isTimeConstraint_3036(View containerView, TimeConstraint domainElement) {
        return UMLVisualIDRegistry.isTimeConstraint_3036(domainElement);
    }

    private static boolean isTimeConstraint_3037(View containerView, TimeConstraint domainElement) {
        return UMLVisualIDRegistry.isTimeConstraint_3037(domainElement);
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLActivityDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLActivityDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3059 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (5080 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5081 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5082 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (5083 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (5084 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5085 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5086 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 == nodeVisualID) {
                    return true;
                }
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (5087 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (5088 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (5089 != nodeVisualID) break;
                return true;
            }
            case 3020: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5090 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 3021: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (5028 == nodeVisualID) {
                    return true;
                }
                if (5091 != nodeVisualID) break;
                return true;
            }
            case 3022: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (5029 == nodeVisualID) {
                    return true;
                }
                if (5092 != nodeVisualID) break;
                return true;
            }
            case 3023: {
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (5093 != nodeVisualID) break;
                return true;
            }
            case 3024: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (5094 != nodeVisualID) break;
                return true;
            }
            case 3025: {
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (5030 == nodeVisualID) {
                    return true;
                }
                if (5095 != nodeVisualID) break;
                return true;
            }
            case 3026: {
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (5031 == nodeVisualID) {
                    return true;
                }
                if (5096 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (5097 != nodeVisualID) break;
                return true;
            }
            case 3034: {
                if (5038 == nodeVisualID) {
                    return true;
                }
                if (5130 != nodeVisualID) break;
                return true;
            }
            case 3035: {
                if (5039 == nodeVisualID) {
                    return true;
                }
                if (5131 != nodeVisualID) break;
                return true;
            }
            case 3036: {
                if (5040 == nodeVisualID) {
                    return true;
                }
                if (5132 != nodeVisualID) break;
                return true;
            }
            case 3037: {
                if (5041 == nodeVisualID) {
                    return true;
                }
                if (5133 != nodeVisualID) break;
                return true;
            }
            case 3032: {
                if (5036 == nodeVisualID) {
                    return true;
                }
                if (5134 != nodeVisualID) break;
                return true;
            }
            case 3033: {
                if (5037 == nodeVisualID) {
                    return true;
                }
                if (5135 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5136 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (5137 != nodeVisualID) break;
                return true;
            }
            case 3038: {
                if (5043 == nodeVisualID) {
                    return true;
                }
                if (5098 != nodeVisualID) break;
                return true;
            }
            case 3039: {
                if (5099 != nodeVisualID) break;
                return true;
            }
            case 3040: {
                if (5100 != nodeVisualID) break;
                return true;
            }
            case 3041: {
                if (5042 == nodeVisualID) {
                    return true;
                }
                if (5101 != nodeVisualID) break;
                return true;
            }
            case 3078: {
                if (5127 == nodeVisualID) {
                    return true;
                }
                if (5128 != nodeVisualID) break;
                return true;
            }
            case 3042: {
                if (5059 == nodeVisualID) {
                    return true;
                }
                if (3046 == nodeVisualID) {
                    return true;
                }
                if (3047 == nodeVisualID) {
                    return true;
                }
                if (3048 == nodeVisualID) {
                    return true;
                }
                if (3049 == nodeVisualID) {
                    return true;
                }
                if (3050 == nodeVisualID) {
                    return true;
                }
                if (3051 != nodeVisualID) break;
                return true;
            }
            case 3046: {
                if (5049 == nodeVisualID) {
                    return true;
                }
                if (5050 == nodeVisualID) {
                    return true;
                }
                if (5102 != nodeVisualID) break;
                return true;
            }
            case 3047: {
                if (5051 == nodeVisualID) {
                    return true;
                }
                if (5052 == nodeVisualID) {
                    return true;
                }
                if (5103 != nodeVisualID) break;
                return true;
            }
            case 3048: {
                if (5053 == nodeVisualID) {
                    return true;
                }
                if (5104 != nodeVisualID) break;
                return true;
            }
            case 3049: {
                if (5054 == nodeVisualID) {
                    return true;
                }
                if (5055 == nodeVisualID) {
                    return true;
                }
                if (5105 != nodeVisualID) break;
                return true;
            }
            case 3050: {
                if (5056 == nodeVisualID) {
                    return true;
                }
                if (5057 == nodeVisualID) {
                    return true;
                }
                if (5106 != nodeVisualID) break;
                return true;
            }
            case 3051: {
                if (5058 == nodeVisualID) {
                    return true;
                }
                if (5107 != nodeVisualID) break;
                return true;
            }
            case 3052: {
                if (5060 == nodeVisualID) {
                    return true;
                }
                if (3053 == nodeVisualID) {
                    return true;
                }
                if (3054 == nodeVisualID) {
                    return true;
                }
                if (3055 == nodeVisualID) {
                    return true;
                }
                if (3060 == nodeVisualID) {
                    return true;
                }
                if (3061 == nodeVisualID) {
                    return true;
                }
                if (3062 != nodeVisualID) break;
                return true;
            }
            case 3053: {
                if (5061 == nodeVisualID) {
                    return true;
                }
                if (5062 == nodeVisualID) {
                    return true;
                }
                if (5108 != nodeVisualID) break;
                return true;
            }
            case 3054: {
                if (5063 == nodeVisualID) {
                    return true;
                }
                if (5064 == nodeVisualID) {
                    return true;
                }
                if (5109 != nodeVisualID) break;
                return true;
            }
            case 3055: {
                if (5065 == nodeVisualID) {
                    return true;
                }
                if (5110 != nodeVisualID) break;
                return true;
            }
            case 3060: {
                if (5072 == nodeVisualID) {
                    return true;
                }
                if (5073 == nodeVisualID) {
                    return true;
                }
                if (5111 != nodeVisualID) break;
                return true;
            }
            case 3061: {
                if (5074 == nodeVisualID) {
                    return true;
                }
                if (5075 == nodeVisualID) {
                    return true;
                }
                if (5112 != nodeVisualID) break;
                return true;
            }
            case 3062: {
                if (5076 == nodeVisualID) {
                    return true;
                }
                if (5113 != nodeVisualID) break;
                return true;
            }
            case 3059: {
                if (5071 != nodeVisualID) break;
                return true;
            }
            case 3063: {
                if (5078 == nodeVisualID) {
                    return true;
                }
                if (5079 == nodeVisualID) {
                    return true;
                }
                if (5115 == nodeVisualID) {
                    return true;
                }
                if (3064 != nodeVisualID) break;
                return true;
            }
            case 3064: {
                if (5077 == nodeVisualID) {
                    return true;
                }
                if (5114 != nodeVisualID) break;
                return true;
            }
            case 3076: {
                if (5126 == nodeVisualID) {
                    return true;
                }
                if (3077 != nodeVisualID) break;
                return true;
            }
            case 3077: {
                if (5124 == nodeVisualID) {
                    return true;
                }
                if (5125 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5119 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5120 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5121 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (3105 == nodeVisualID) {
                    return true;
                }
                if (3111 == nodeVisualID) {
                    return true;
                }
                if (3109 == nodeVisualID) {
                    return true;
                }
                if (3110 != nodeVisualID) break;
                return true;
            }
            case 3109: {
                if (5184 == nodeVisualID) {
                    return true;
                }
                if (5185 != nodeVisualID) break;
                return true;
            }
            case 3110: {
                if (5186 == nodeVisualID) {
                    return true;
                }
                if (5183 != nodeVisualID) break;
                return true;
            }
            case 3111: {
                if (5187 == nodeVisualID) {
                    return true;
                }
                if (5188 != nodeVisualID) break;
                return true;
            }
            case 3073: {
                if (5123 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 3065: {
                if (5117 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3105: {
                if (5178 == nodeVisualID) {
                    return true;
                }
                if (5179 != nodeVisualID) break;
                return true;
            }
            case 3067: {
                if (5118 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3068: {
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3080: {
                if (5138 != nodeVisualID) break;
                return true;
            }
            case 3081: {
                if (5139 == nodeVisualID) {
                    return true;
                }
                if (3084 != nodeVisualID) break;
                return true;
            }
            case 3084: {
                if (5144 == nodeVisualID) {
                    return true;
                }
                if (5145 != nodeVisualID) break;
                return true;
            }
            case 3083: {
                if (5142 == nodeVisualID) {
                    return true;
                }
                if (5143 == nodeVisualID) {
                    return true;
                }
                if (7014 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (7016 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (3059 != nodeVisualID) break;
                return true;
            }
            case 3086: {
                if (5148 == nodeVisualID) {
                    return true;
                }
                if (3087 != nodeVisualID) break;
                return true;
            }
            case 3087: {
                if (5146 == nodeVisualID) {
                    return true;
                }
                if (5147 != nodeVisualID) break;
                return true;
            }
            case 3085: {
                if (5129 != nodeVisualID) break;
                return true;
            }
            case 3088: {
                if (5153 == nodeVisualID) {
                    return true;
                }
                if (3089 == nodeVisualID) {
                    return true;
                }
                if (3090 != nodeVisualID) break;
                return true;
            }
            case 3089: {
                if (5149 == nodeVisualID) {
                    return true;
                }
                if (5150 != nodeVisualID) break;
                return true;
            }
            case 3090: {
                if (5151 == nodeVisualID) {
                    return true;
                }
                if (5152 != nodeVisualID) break;
                return true;
            }
            case 3091: {
                if (5160 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 != nodeVisualID) break;
                return true;
            }
            case 3092: {
                if (5154 == nodeVisualID) {
                    return true;
                }
                if (5155 != nodeVisualID) break;
                return true;
            }
            case 3093: {
                if (5156 == nodeVisualID) {
                    return true;
                }
                if (5157 != nodeVisualID) break;
                return true;
            }
            case 3094: {
                if (5158 == nodeVisualID) {
                    return true;
                }
                if (5159 != nodeVisualID) break;
                return true;
            }
            case 3095: {
                if (5163 == nodeVisualID) {
                    return true;
                }
                if (3096 != nodeVisualID) break;
                return true;
            }
            case 3096: {
                if (5161 == nodeVisualID) {
                    return true;
                }
                if (5162 != nodeVisualID) break;
                return true;
            }
            case 3097: {
                if (5166 == nodeVisualID) {
                    return true;
                }
                if (3098 != nodeVisualID) break;
                return true;
            }
            case 3098: {
                if (5164 == nodeVisualID) {
                    return true;
                }
                if (5165 != nodeVisualID) break;
                return true;
            }
            case 3099: {
                if (5171 == nodeVisualID) {
                    return true;
                }
                if (3100 == nodeVisualID) {
                    return true;
                }
                if (3101 != nodeVisualID) break;
                return true;
            }
            case 3100: {
                if (5167 == nodeVisualID) {
                    return true;
                }
                if (5168 != nodeVisualID) break;
                return true;
            }
            case 3101: {
                if (5169 == nodeVisualID) {
                    return true;
                }
                if (5170 != nodeVisualID) break;
                return true;
            }
            case 3102: {
                if (5175 == nodeVisualID) {
                    return true;
                }
                if (3103 != nodeVisualID) break;
                return true;
            }
            case 3103: {
                if (5172 == nodeVisualID) {
                    return true;
                }
                if (5173 == nodeVisualID) {
                    return true;
                }
                if (5174 != nodeVisualID) break;
                return true;
            }
            case 3104: {
                if (5176 == nodeVisualID) {
                    return true;
                }
                if (5177 != nodeVisualID) break;
                return true;
            }
            case 3112: {
                if (5189 == nodeVisualID) {
                    return true;
                }
                if (5190 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3068 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3068 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3059 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6014 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6011 == nodeVisualID) {
                    return true;
                }
                if (6013 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getObjectFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getControlFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getExceptionHandler().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isActionInputPin_3021(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3022(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3023(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3025(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3026(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3027(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConstraint_3011(Constraint domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConstraint_3012(Constraint domainElement) {
        Object result = UMLOCLFactory.getExpression(13, (EClassifier)UMLPackage.eINSTANCE.getConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3046(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(14, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3047(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(15, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3048(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(16, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3049(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(17, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3050(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(18, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3051(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(19, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3053(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(20, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3054(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(21, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3055(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3060(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(23, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3061(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(24, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3062(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(25, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isExpansionNode_3074(ExpansionNode domainElement) {
        Object result = UMLOCLFactory.getExpression(26, (EClassifier)UMLPackage.eINSTANCE.getExpansionNode(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isExpansionNode_3075(ExpansionNode domainElement) {
        Object result = UMLOCLFactory.getExpression(27, (EClassifier)UMLPackage.eINSTANCE.getExpansionNode(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3092(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3092(domainElement);
    }

    private static boolean isInputPin_3092(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(29, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3093(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3093(domainElement);
    }

    private static boolean isInputPin_3093(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(30, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3096(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3096(domainElement);
    }

    private static boolean isInputPin_3096(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(31, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isOutputPin_3098(View containerView, OutputPin domainElement) {
        return UMLVisualIDRegistry.isOutputPin_3098(domainElement);
    }

    private static boolean isOutputPin_3098(OutputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(32, (EClassifier)UMLPackage.eINSTANCE.getOutputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3100(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3100(domainElement);
    }

    private static boolean isInputPin_3100(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(33, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3101(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3101(domainElement);
    }

    private static boolean isInputPin_3101(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(34, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3103(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3103(domainElement);
    }

    private static boolean isInputPin_3103(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(35, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: 
            case 7010: 
            case 7012: 
            case 7013: 
            case 7014: 
            case 7015: 
            case 7016: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: 
            case 3026: 
            case 3027: 
            case 3032: 
            case 3033: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: 
            case 3046: 
            case 3047: 
            case 3048: 
            case 3049: 
            case 3050: 
            case 3051: 
            case 3053: 
            case 3054: 
            case 3055: 
            case 3059: 
            case 3060: 
            case 3061: 
            case 3062: 
            case 3064: 
            case 3074: 
            case 3075: 
            case 3077: 
            case 3078: 
            case 3080: 
            case 3084: 
            case 3085: 
            case 3087: 
            case 3089: 
            case 3090: 
            case 3092: 
            case 3093: 
            case 3094: 
            case 3096: 
            case 3098: 
            case 3100: 
            case 3101: 
            case 3103: 
            case 3104: 
            case 3105: 
            case 3109: 
            case 3110: 
            case 3111: 
            case 3112: {
                return true;
            }
        }
        return false;
    }

    private static boolean isIntervalConstraint_3032(IntervalConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(10, (EClassifier)UMLPackage.eINSTANCE.getIntervalConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isIntervalConstraint_3033(IntervalConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(11, (EClassifier)UMLPackage.eINSTANCE.getIntervalConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDurationConstraint_3034(DurationConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getDurationConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDurationConstraint_3035(DurationConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(7, (EClassifier)UMLPackage.eINSTANCE.getDurationConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTimeConstraint_3036(TimeConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(8, (EClassifier)UMLPackage.eINSTANCE.getTimeConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTimeConstraint_3037(TimeConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(9, (EClassifier)UMLPackage.eINSTANCE.getTimeConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }
}

