/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.outline;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.papyrus.infra.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.outline.DiagramNavigator;
import org.eclipse.papyrus.infra.gmfdiag.outline.internal.Activator;
import org.eclipse.papyrus.infra.gmfdiag.outline.internal.Messages;
import org.eclipse.papyrus.infra.gmfdiag.outline.overview.OverviewComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiagramOutline
extends Page
implements IPapyrusContentOutlinePage,
ISelectionListener {
    protected EditingDomain editingDomain;
    private IMultiDiagramEditor multiEditor;
    private SashForm sashComp;
    private DiagramNavigator navigator;
    private RenderedDiagramRootEditPart root = null;
    private Diagram diagram = null;
    public static final int SHOW_TREE = 1;
    public static final int SHOW_OVERVIEW = 2;
    public static final int SHOW_BOTH = 0;
    private Composite overview;
    private ActionContributionItem showTreeItem;
    private ActionContributionItem showOverviewItem;
    private ActionContributionItem showAllItem;

    public void init(IMultiDiagramEditor multiEditor) throws BackboneException {
        try {
            this.editingDomain = (EditingDomain)multiEditor.getServicesRegistry().getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            throw new BackboneException("Can't get TransactionalEditingDomain", (Throwable)e);
        }
        this.multiEditor = multiEditor;
        multiEditor.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void createControl(Composite parent) {
        this.sashComp = new SashForm(parent, 512);
        this.sashComp.setLayoutData((Object)new GridData(1808));
        this.refreshSelection();
        if (this.root != null) {
            this.overview = this.createOverview((Composite)this.sashComp, (ScalableFreeformRootEditPart)this.root);
            this.overview.setLayoutData((Object)new GridData(1808));
        }
        this.navigator = this.createNavigator((Composite)this.sashComp, this.getSite());
        if (this.diagram != null) {
            this.navigator.getTreeViewer().setInput((Object)this.diagram);
        }
        if (this.overview != null) {
            this.sashComp.setWeights(new int[]{30, 70});
        }
        this.createActions();
    }

    protected Composite createOverview(Composite parent, ScalableFreeformRootEditPart rootEditPart) {
        return new OverviewComposite(parent, rootEditPart);
    }

    protected void createActions() {
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        this.createShowOutlineActions(tbm);
    }

    private void createShowOutlineActions(IToolBarManager tbm) {
        ShowTreeAction showTreeAction = new ShowTreeAction(Messages.DiagramOutline_ShowNavigator, 8);
        showTreeAction.setToolTipText(showTreeAction.getText());
        showTreeAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.gmfdiag.outline", (String)"icons/elcl16/tree_co.gif"));
        this.showTreeItem = new ActionContributionItem((IAction)showTreeAction);
        tbm.add((IContributionItem)this.showTreeItem);
        ShowOverviewAction showOverviewAction = new ShowOverviewAction(Messages.DiagramOutline_ShowOverview, 8);
        showOverviewAction.setToolTipText(showOverviewAction.getText());
        showOverviewAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.gmfdiag.outline", (String)"icons/elcl16/overview_co.gif"));
        this.showOverviewItem = new ActionContributionItem((IAction)showOverviewAction);
        tbm.add((IContributionItem)this.showOverviewItem);
        ShowAllAction showAllAction = new ShowAllAction(Messages.DiagramOutline_ShowBoth, 8);
        showAllAction.setToolTipText(showAllAction.getText());
        showAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.gmfdiag.outline", (String)"icons/elcl16/all_co.gif"));
        this.showAllItem = new ActionContributionItem((IAction)showAllAction);
        tbm.add((IContributionItem)this.showAllItem);
        showOverviewAction.setChecked(true);
        this.performShowAction();
    }

    private DiagramNavigator createNavigator(Composite parent, IPageSite pageSite) {
        return new DiagramNavigator(parent, pageSite, this.multiEditor.getServicesRegistry());
    }

    public Control getControl() {
        return this.sashComp;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.navigator.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.navigator.getTreeViewer().setSelection(selection);
    }

    public void dispose() {
        super.dispose();
        if (this.navigator != null) {
            this.navigator.dispose();
            this.navigator = null;
        }
        if (this.overview != null) {
            this.overview.dispose();
            this.overview = null;
        }
        if (this.multiEditor != null) {
            this.multiEditor.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.multiEditor = null;
        }
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (this.showTreeItem != null) {
            this.showTreeItem.dispose();
            this.showTreeItem = null;
        }
        if (this.showOverviewItem != null) {
            this.showOverviewItem.dispose();
            this.showOverviewItem = null;
        }
        if (this.showAllItem != null) {
            this.showAllItem.dispose();
            this.showAllItem = null;
        }
        toolBarManager.update(false);
        this.getSite().setSelectionProvider(null);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.refreshSelection();
        try {
            this.refresh();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private void refreshSelection() {
        if (this.multiEditor.getActiveEditor() != null) {
            GraphicalViewer viewer = (GraphicalViewer)this.multiEditor.getAdapter(GraphicalViewer.class);
            if (viewer == null) {
                this.root = null;
                this.diagram = null;
                return;
            }
            RootEditPart rootEditPart = viewer.getRootEditPart();
            if (rootEditPart instanceof RenderedDiagramRootEditPart) {
                this.root = (RenderedDiagramRootEditPart)rootEditPart;
                this.diagram = rootEditPart.getContents() != null ? (Diagram)rootEditPart.getContents().getModel() : null;
            } else {
                this.root = null;
                this.diagram = null;
            }
        } else {
            this.root = null;
            this.diagram = null;
        }
    }

    private void refresh() {
        if (this.overview != null && !this.overview.isDisposed()) {
            this.overview.dispose();
        }
        if (this.sashComp == null) {
            Activator.log.warn("Trying to refresh the Outline view before it is initialized");
            return;
        }
        if (this.root != null) {
            this.overview = this.createOverview((Composite)this.sashComp, (ScalableFreeformRootEditPart)this.root);
            this.overview.setLayoutData((Object)new GridData(1808));
        }
        if (this.diagram != null) {
            this.navigator.getTreeViewer().setInput((Object)this.diagram);
        }
        if (this.overview != null && !this.overview.isDisposed()) {
            this.sashComp.setWeights(new int[]{30, 70});
        }
        this.performShowAction();
    }

    private void performShowAction() {
        DiagramNavigator control = null;
        control = null;
        switch (this.getShowActionMode()) {
            case 1: {
                control = this.navigator;
                break;
            }
            case 2: {
                control = this.overview;
                break;
            }
            case 0: {
                control = null;
                break;
            }
            default: {
                control = this.overview;
            }
        }
        if (this.sashComp != null && !this.sashComp.isDisposed()) {
            this.sashComp.setMaximizedControl((Control)control);
        }
    }

    private int getShowActionMode() {
        int showActionMode = -1;
        if (this.showTreeItem.getAction().isChecked()) {
            showActionMode = 1;
        }
        if (this.showOverviewItem.getAction().isChecked()) {
            showActionMode = 2;
        }
        if (this.showAllItem.getAction().isChecked()) {
            showActionMode = 0;
        }
        return showActionMode;
    }

    private final class ShowAllAction
    extends Action {
        private ShowAllAction(String text, int style) {
            super(text, style);
        }

        public void run() {
            if (DiagramOutline.this.sashComp != null && !DiagramOutline.this.sashComp.isDisposed()) {
                DiagramOutline.this.performShowAction();
            }
        }
    }

    private final class ShowOverviewAction
    extends Action {
        private ShowOverviewAction(String text, int style) {
            super(text, style);
        }

        public void run() {
            if (DiagramOutline.this.overview != null && !DiagramOutline.this.overview.isDisposed()) {
                DiagramOutline.this.performShowAction();
            }
        }
    }

    private final class ShowTreeAction
    extends Action {
        private ShowTreeAction(String text, int style) {
            super(text, style);
        }

        public void run() {
            if (DiagramOutline.this.navigator != null && !DiagramOutline.this.navigator.isDisposed()) {
                DiagramOutline.this.performShowAction();
            }
        }
    }
}

