/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.contentprovider.singlefolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.singlefolder.SingleFolderContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFolderModel
implements ITabFolderModel {
    private List<IPageModel> itemModels = new ArrayList<IPageModel>();
    private SingleFolderContentProvider contentProvider;

    public SingleFolderModel(SingleFolderContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    @Override
    public List<?> getChildren() {
        return this.itemModels;
    }

    @Override
    public IPageModel createChildSashModel(Object child) {
        return (IPageModel)child;
    }

    public void addItem(IPageModel newModel) {
        this.itemModels.add(newModel);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    public void addItem(int index, IPageModel newModel) {
        this.itemModels.add(index, newModel);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    public IPageModel removeTab(int index) {
        IPageModel removed = this.itemModels.remove(index);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, removed));
        return removed;
    }

    public void removeTab(IPageModel tabItem) {
        this.itemModels.remove(tabItem);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, tabItem));
    }

    public void moveTab(int oldIndex, int newIndex) {
        int listSize = this.itemModels.size();
        if (newIndex >= listSize) {
            newIndex = listSize - 1;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (oldIndex == newIndex) {
            return;
        }
        if (listSize == 0) {
            return;
        }
        IPageModel toMove = this.itemModels.remove(oldIndex);
        this.itemModels.add(newIndex, toMove);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(3, this, toMove));
    }
}

