/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.util.Geometry;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.PresentationUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.dnd.DragUtil;

public class PTabFolder {
    protected CTabFolder tabFolder;
    private EventsManager listenersManager = new EventsManager();
    private Listener dragListener = new Listener(){

        public void handleEvent(Event e) {
            Point globalPos = ((Control)e.widget).toDisplay(e.x, e.y);
            PTabFolder.this.handleDragStarted(globalPos, e);
        }
    };
    private Listener activateListener = new Listener(){

        public void handleEvent(Event e) {
            Point globalPos = ((Control)e.widget).toDisplay(e.x, e.y);
            PTabFolder.this.handleFolderReselected(globalPos, null);
        }
    };
    private MenuDetectListener menuDetectListener = new MenuDetectListener(){

        public void menuDetected(MenuDetectEvent e) {
            Point globalPos = new Point(e.x, e.y);
            PTabFolder.this.handleMenuDetect(globalPos, e);
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
            PTabFolder.this.handleMouseUp(e);
        }

        public void mouseDown(MouseEvent e) {
            PTabFolder.this.handleMouseDown(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
            PTabFolder.this.handleMouseDoubleClick(e);
        }
    };

    public Composite getControl() {
        return this.tabFolder;
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = this.createContainer(parent);
        this.attachListeners(this.tabFolder, false);
    }

    private CTabFolder createContainer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder newContainer = new CTabFolder(parent, 0x800440);
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = newContainer.indexOf((CTabItem)e.item);
                PTabFolder.this.firePageChange(newPageIndex);
            }
        });
        newContainer.setUnselectedCloseVisible(false);
        newContainer.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                int pageIndex = newContainer.indexOf((CTabItem)event.item);
                event.doit = false;
                PTabFolder.this.fireItemClosed(event, pageIndex);
            }
        });
        return newContainer;
    }

    public void dispose() {
        if (this.tabFolder.isDisposed()) {
            return;
        }
        this.detachListeners((Control)this.tabFolder);
        this.tabFolder.dispose();
    }

    protected void attachListeners(CTabFolder theControl, boolean recursive) {
        theControl.addMenuDetectListener(this.menuDetectListener);
        PresentationUtil.addDragListener((Control)theControl, this.dragListener);
        theControl.addListener(26, this.activateListener);
        theControl.addMouseListener(this.mouseListener);
    }

    private void detachListeners(Control theControl) {
        theControl.removeMenuDetectListener(this.menuDetectListener);
        PresentationUtil.removeDragListener(theControl, this.dragListener);
        theControl.removeListener(26, this.activateListener);
        theControl.removeMouseListener(this.mouseListener);
    }

    protected void handleContextMenu(Point displayPos, Event e) {
        CTabItem tab = this.getItem(displayPos);
        this.listenersManager.fireContextMenuEvent(tab, e);
    }

    protected void handleDragStarted(Point displayPos, Event e) {
        CTabItem tab = this.getItem(displayPos);
        boolean allowSnapping = true;
        Rectangle sourceBounds = Geometry.toDisplay((Control)this.tabFolder.getParent(), (Rectangle)this.tabFolder.getBounds());
        if (tab == null) {
            DragUtil.performDrag((Object)this.tabFolder, (Rectangle)sourceBounds, (Point)displayPos, (boolean)allowSnapping);
        } else {
            DragUtil.performDrag((Object)tab, (Rectangle)sourceBounds, (Point)displayPos, (boolean)allowSnapping);
        }
    }

    private void handleMenuDetect(Point displayPos, MenuDetectEvent e) {
        CTabItem tab = this.getItem(displayPos);
        this.listenersManager.fireMenuDetectEvent(tab, e);
    }

    private void handleFolderReselected(Point displayPos, MouseEvent e) {
        int itemIndex = this.getItemIndex(displayPos);
        if (itemIndex == -1) {
            itemIndex = this.tabFolder.getSelectionIndex();
        }
        if (itemIndex == -1) {
            return;
        }
        this.listenersManager.firePageChange(itemIndex);
    }

    private void handleMouseDoubleClick(MouseEvent e) {
        Point displayPos = new Point(e.x, e.y);
        int itemIndex = this.getItemIndex(displayPos);
        this.listenersManager.fireMouseDoubleClick(itemIndex, e);
    }

    private void handleMouseUp(MouseEvent e) {
        Point displayPos = new Point(e.x, e.y);
        int itemIndex = this.getItemIndex(displayPos);
        this.listenersManager.fireMouseUp(itemIndex, e);
    }

    private void handleMouseDown(MouseEvent e) {
        Point displayPos = new Point(e.x, e.y);
        int itemIndex = this.getItemIndex(displayPos);
        this.listenersManager.fireMouseDown(itemIndex, e);
    }

    private boolean isOnBorder(Point toTest) {
        Composite content = this.getControl();
        if (content != null) {
            Rectangle displayBounds = DragUtil.getDisplayBounds((Control)content);
            if (this.tabFolder.getTabPosition() == 128) {
                return toTest.y >= displayBounds.y;
            }
            if (toTest.y >= displayBounds.y && toTest.y < displayBounds.y + displayBounds.height) {
                return true;
            }
        }
        return false;
    }

    public CTabItem getItem(Point toFind) {
        CTabItem[] items;
        CTabItem[] cTabItemArray = items = this.tabFolder.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (this.getItemBounds(item).contains(toFind)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public int getItemIndex(Point pt) {
        CTabItem item = this.tabFolder.getItem(pt);
        if (item == null) {
            return -1;
        }
        return PTabFolder.getItemIndex(item);
    }

    public Rectangle getItemBounds(CTabItem item) {
        return Geometry.toDisplay((Control)item.getParent(), (Rectangle)item.getBounds());
    }

    protected void fireItemClosed(CTabFolderEvent event, int pageIndex) {
        this.listenersManager.fireItemClosed(event, pageIndex);
    }

    protected void firePageChange(int newPageIndex) {
        this.listenersManager.firePageChange(newPageIndex);
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public Rectangle getTabArea() {
        Rectangle bounds = DragUtil.getDisplayBounds((Control)this.tabFolder);
        if (this.tabFolder.getTabPosition() == 128) {
            bounds.height = this.tabFolder.getTabHeight();
        } else {
            bounds.y = bounds.y + bounds.height - this.tabFolder.getTabHeight();
            bounds.height = this.tabFolder.getTabHeight();
        }
        return bounds;
    }

    public static int getDraggedObjectTabIndex(Object draggedObject) {
        if (draggedObject instanceof CTabItem) {
            CTabItem item = (CTabItem)draggedObject;
            int index = PTabFolder.getItemIndex(item);
            return index;
        }
        if (draggedObject instanceof CTabFolder) {
            return -1;
        }
        return -2;
    }

    private static int getItemIndex(CTabItem item) {
        CTabItem[] items = item.getParent().getItems();
        int i = 0;
        while (i < items.length) {
            CTabItem cur = items[i];
            if (cur == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public EventsManager getEventManager() {
        return this.listenersManager;
    }

    public class EventsManager {
        Set<IPTabFolderListener> listeners = new HashSet<IPTabFolderListener>();

        public void addListener(IPTabFolderListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(IPTabFolderListener listener) {
            this.listeners.remove(listener);
        }

        public void fireContextMenuEvent(CTabItem tab, Event event) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.contextMenuDetectEvent(tab, event);
            }
        }

        private void fireItemClosed(CTabFolderEvent event, int pageIndex) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.itemClosedEvent(event, pageIndex);
            }
        }

        private void firePageChange(int newPageIndex) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.pageChangeEvent(newPageIndex);
            }
        }

        private void fireMenuDetectEvent(CTabItem tab, MenuDetectEvent e) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.menuDetectEvent(tab, e);
            }
        }

        public void fireMouseDoubleClick(int itemIndex, MouseEvent e) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.mouseDoubleClickEvent(itemIndex, e);
            }
        }

        public void fireMouseUp(int itemIndex, MouseEvent e) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.mouseUpEvent(itemIndex, e);
            }
        }

        public void fireMouseDown(int itemIndex, MouseEvent e) {
            for (IPTabFolderListener cur : this.listeners) {
                cur.mouseDownEvent(itemIndex, e);
            }
        }
    }

    public static interface IPTabFolderListener {
        public void menuDetectEvent(CTabItem var1, MenuDetectEvent var2);

        public void contextMenuDetectEvent(CTabItem var1, Event var2);

        public void itemClosedEvent(CTabFolderEvent var1, int var2);

        public void pageChangeEvent(int var1);

        public void mouseDoubleClickEvent(int var1, MouseEvent var2);

        public void mouseUpEvent(int var1, MouseEvent var2);

        public void mouseDownEvent(int var1, MouseEvent var2);
    }
}

