/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;

public class SashContainerEventsProvider {
    private List<IPageLifeCycleEventsListener> listeners = new ArrayList<IPageLifeCycleEventsListener>();

    public void addListener(IPageLifeCycleEventsListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(IPageLifeCycleEventsListener listener) {
        this.listeners.remove(listener);
    }

    public void firePageOpenedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageOpened(page);
        }
    }

    public void firePageClosedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageClosed(page);
        }
    }

    public void firePageAboutToBeOpenedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageAboutToBeOpened(page);
        }
    }

    public void firePageAboutToBeClosedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageAboutToBeClosed(page);
        }
    }

    public void firePageActivatedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageActivated(page);
        }
    }

    public void firePageDeactivatedEvent(PagePart page) {
        for (IPageLifeCycleEventsListener listener : this.listeners) {
            listener.pageDeactivated(page);
        }
    }
}

