/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.edit.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ExternalLabelPrimaryDragRoleEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.diagram.common.figure.FlowPortFigure;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementBorderEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeIconlDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FlowPortAffixedNodeEditPart
extends AbstractElementBorderEditPart {
    private LayoutListener.Stub layoutInitializationListener;

    public FlowPortAffixedNodeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeIconlDisplayEditPolicy(){

            protected void refreshStereotypeDisplay() {
                if (this.getHost() instanceof IPapyrusEditPart) {
                    IFigure figure = ((IPapyrusEditPart)this.getHost()).getPrimaryShape();
                    if (figure instanceof IPapyrusUMLElementFigure && this.stereotypeIconToDisplay() != null) {
                        ((IPapyrusUMLElementFigure)figure).setStereotypeDisplay(null, this.stereotypeIconToDisplay());
                    } else {
                        FlowPortAffixedNodeEditPart.this.refreshVisuals();
                    }
                }
            }
        });
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ShowHideLabelEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new ExternalLabelPrimaryDragRoleEditPolicy(){

                        protected List createSelectionHandles() {
                            MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                            mh.setBorder(null);
                            return Collections.singletonList(mh);
                        }
                    };
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        ExternalLabelPositionLocator locator = new ExternalLabelPositionLocator(this.getMainFigure());
        borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint("affixedlabel_sysml_flowport_label");
    }

    protected void addSemanticListeners() {
        FlowPort flowPort;
        if (this.resolveSemanticElement() != null && (flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)((Element)this.resolveSemanticElement()), FlowPort.class)) != null) {
            this.addListenerFilter("FlowPort", (NotificationListener)this, (EObject)flowPort);
        }
        super.addSemanticListeners();
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter("FlowPort");
        super.removeSemanticListeners();
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshVisuals();
        }
        if (this.resolveSemanticElement() != null) {
            Element element = (Element)this.resolveSemanticElement();
            FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)element, FlowPort.class);
            if (flowPort != null && flowPort.equals(event.getNotifier()) && (PortandflowsPackage.eINSTANCE.getFlowPort_Direction().equals(event.getFeature()) || PortandflowsPackage.eINSTANCE.getFlowPort_IsConjugated().equals(event.getFeature()))) {
                this.refreshVisuals();
            }
            if (this.resolveSemanticElement().equals(event.getNotifier()) && UMLPackage.eINSTANCE.getTypedElement_Type().equals(event.getFeature())) {
                this.refreshVisuals();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new FlowPortFigure();
        return this.primaryShape;
    }

    public FlowPortFigure getPrimaryShape() {
        return (FlowPortFigure)this.primaryShape;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int side = this.getBorderItemLocator().getCurrentSideOfParent();
        if (side == 0) {
            this.getBorderItemLocator().getCurrentSideOfParent();
        }
        Element element = (Element)this.resolveSemanticElement();
        FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)element, FlowPort.class);
        Image image = Activator.getInstance().getFlowPortImage(flowPort, side);
        this.getPrimaryShape().setImage(image);
    }

    public void activate() {
        this.layoutInitializationListener = new LayoutListener.Stub(){

            public void postLayout(IFigure container) {
                FlowPortAffixedNodeEditPart.this.refreshVisuals();
                FlowPortAffixedNodeEditPart.this.layoutInitializationListener = null;
            }
        };
        this.getBorderedFigure().getBorderItemContainer().addLayoutListener((LayoutListener)this.layoutInitializationListener);
        super.activate();
    }
}

