/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.sysml.portandflows.FlowSpecification;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowPortLabelParser
extends PropertyLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String CONJUGATED_FORMAT = "~%s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Port) {
            ValueSpecification valueSpecification;
            Property property = (Property)eObject;
            FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)property, FlowPort.class);
            if (flowPort != null) {
                int directionFlag = flags & 0x100;
                if ((flags & 0x100) == 256) {
                    String direction;
                    switch (flowPort.getDirection().getValue()) {
                        case 0: {
                            direction = "in";
                            break;
                        }
                        case 1: {
                            direction = "out";
                            break;
                        }
                        case 2: {
                            direction = "inout";
                            break;
                        }
                        default: {
                            direction = "inout";
                        }
                    }
                    if (property.getType() == null || property.getType() != null && UMLUtil.getStereotypeApplication((Element)property.getType(), FlowSpecification.class) == null) {
                        result = String.format(DIRECTION_FORMAT, direction, result);
                    }
                }
            }
            if ((flags & 2) == 2) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(DIRECTION_FORMAT, visibility, result);
            }
            if ((flags & 4) == 4 && property.isDerived()) {
                result = String.format("%s/", result);
            }
            if ((flags & 8) == 8 && property.isSetName()) {
                String name = property.getName();
                result = String.format("%s%s", result, name);
            }
            if ((flags & 0x10) == 16) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = property.getType().getName();
                }
                if ((flags & 0x200000) == 0x200000 || !"<Undefined>".equals(type)) {
                    if (flowPort != null && flowPort.isConjugated()) {
                        type = String.format(CONJUGATED_FORMAT, type);
                    }
                    result = String.format("%s: %s", result, type);
                }
            }
            if ((flags & 0x20) == 32) {
                String upper;
                String lower = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getLowerValue()) : "1";
                String string = upper = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getUpperValue()) : "1";
                if ((flags & 0x100000) == 0x100000 || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format("%s [%s]", result, lower, upper) : String.format("%s [%s..%s]", result, lower, upper);
                }
            }
            if ((flags & 0x40) == 64 && property.getDefaultValue() != null && (valueSpecification = property.getDefaultValue()) instanceof InstanceValue && property.getType().equals(valueSpecification.getType())) {
                result = String.format("%s= %s", result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            if ((flags & 0x80) == 128) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? p.getName() : ", redefines " + p.getName());
                    }
                }
                if (sb.length() != 0) {
                    result = String.format("%s{%s}", result, sb.toString());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return PortandflowsPackage.eINSTANCE.getFlowPort_Direction().equals(feature) || PortandflowsPackage.eINSTANCE.getFlowPort_IsConjugated().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        Port semElement;
        FlowPort flowPort;
        List<EObject> semanticElementsBeingParsed = super.getSemanticElementsBeingParsed(element);
        if (element != null && element instanceof Port && (flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)(semElement = (Port)element), FlowPort.class)) != null) {
            semanticElementsBeingParsed.add((EObject)flowPort);
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(10);
        masks.put(256, "Direction");
        masks.put(2, "Visibility");
        masks.put(4, "Is Derived");
        masks.put(8, "Name");
        masks.put(16, "Type");
        masks.put(0x200000, "Show <Undefined> type");
        masks.put(32, "Multiplicity");
        masks.put(0x100000, "Show default multiplicity");
        masks.put(64, "Default Value");
        masks.put(128, "Modifiers");
        return masks;
    }
}

