/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.papyrus.sysml.SysmlPackage;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.requirements.RequirementsPackage;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SysMLSelectionTester
extends PropertyTester {
    public static final String IS_SYSML_MODEL = "isSysMLModel";
    public static final String IS_SYSML_REQUIREMENTS_MODEL = "isSysMLRequirementsModel";
    public static final String IS_SYSML_BLOCKS_MODEL = "isSysMLBlocksModel";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Boolean currentValue = null;
        if (IS_SYSML_MODEL.equals(property)) {
            currentValue = this.testSysMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_SYSML_BLOCKS_MODEL.equals(property)) {
            currentValue = this.testSysMLBlocksModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_SYSML_REQUIREMENTS_MODEL.equals(property)) {
            currentValue = this.testSysMLRequirementsModelNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testSysMLModelNature(Object receiver) {
        Profile sysml;
        boolean isSysMLModel = false;
        EObject root = this.getRoot(receiver);
        if (root instanceof Package && ((Package)root).isProfileApplied(sysml = UMLUtil.getProfile((EPackage)SysmlPackage.eINSTANCE, (EObject)root))) {
            isSysMLModel = true;
        }
        return isSysMLModel;
    }

    protected boolean testSysMLRequirementsModelNature(Object receiver) {
        Profile sysml;
        boolean isSysMLModel = false;
        EObject root = this.getRoot(receiver);
        if (root instanceof Package && ((Package)root).isProfileApplied(sysml = UMLUtil.getProfile((EPackage)RequirementsPackage.eINSTANCE, (EObject)root))) {
            isSysMLModel = true;
        }
        return isSysMLModel;
    }

    protected boolean testSysMLBlocksModelNature(Object receiver) {
        Profile sysml;
        boolean isSysMLModel = false;
        EObject root = this.getRoot(receiver);
        if (root instanceof Package && ((Package)root).isProfileApplied(sysml = UMLUtil.getProfile((EPackage)BlocksPackage.eINSTANCE, (EObject)root))) {
            isSysMLModel = true;
        }
        return isSysMLModel;
    }

    private EObject getRoot(Object receiver) {
        EObject root = null;
        if (receiver instanceof ISelection) {
            ISelection selection = (ISelection)receiver;
            if (selection.isEmpty()) {
                return null;
            }
            try {
                ServiceUtilsForSelection serviceUtils = ServiceUtilsForSelection.getInstance();
                UmlModel openedModel = (UmlModel)serviceUtils.getModelSet((Object)selection).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (openedModel != null) {
                    root = openedModel.lookupRoot();
                }
            }
            catch (ServiceException serviceUtils) {
            }
            catch (NotFoundException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return root;
    }
}

