/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelParser
extends NamedElementLabelParser {
    protected static final String VISIBILITY_FORMAT = "%s %s";
    protected static final String DERIVED_FORMAT = "%s/";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String MULTIPLICITY_FORMAT_ALT = "%s [%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Property) {
            ValueSpecification valueSpecification;
            Property property = (Property)eObject;
            if ((flags & 2) == 2) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(VISIBILITY_FORMAT, visibility, result);
            }
            if ((flags & 4) == 4 && property.isDerived()) {
                result = String.format(DERIVED_FORMAT, result);
            }
            if ((flags & 8) == 8 && property.isSetName()) {
                String name = property.getName();
                result = String.format(NAME_FORMAT, result, name);
            }
            if ((flags & 0x10) == 16) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = property.getType().getName();
                }
                if ((flags & 0x200000) == 0x200000 || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            if ((flags & 0x20) == 32) {
                String upper;
                String lower = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getLowerValue()) : "1";
                String string = upper = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getUpperValue()) : "1";
                if ((flags & 0x100000) == 0x100000 || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format(MULTIPLICITY_FORMAT_ALT, result, lower, upper) : String.format(MULTIPLICITY_FORMAT, result, lower, upper);
                }
            }
            if ((flags & 0x40) == 64 && property.getDefaultValue() != null && ((valueSpecification = property.getDefaultValue()) instanceof InstanceValue && property.getType().equals(valueSpecification.getType()) || !(valueSpecification instanceof InstanceValue))) {
                result = String.format(DEFAULT_VALUE_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            if ((flags & 0x80) == 128) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? p.getName() : ", redefines " + p.getName());
                    }
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getInstanceValue_Instance().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature) || UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly().equals(feature) || UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerived().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerivedUnion().equals(feature) || UMLPackage.eINSTANCE.getProperty_RedefinedProperty().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Property) {
            Property semElement = (Property)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
            if (semElement.getDefaultValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getDefaultValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(9);
        masks.put(2, "Visibility");
        masks.put(4, "Is Derived");
        masks.put(8, "Name");
        masks.put(16, "Type");
        masks.put(0x200000, "Show <Undefined> type");
        masks.put(32, "Multiplicity");
        masks.put(0x100000, "Show default multiplicity");
        masks.put(64, "Default Value");
        masks.put(128, "Modifiers");
        return masks;
    }
}

