/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusMarkerAdapter
implements IPapyrusMarker {
    private final Resource resource;
    private final IMarker marker;
    private final Map attributes;

    protected PapyrusMarkerAdapter(Resource resource, IMarker marker) {
        this.resource = resource;
        this.marker = marker;
        this.attributes = null;
    }

    protected PapyrusMarkerAdapter(Resource resource, IMarker marker, Map attributes) {
        this.resource = resource;
        this.marker = marker;
        this.attributes = attributes;
    }

    public static final PapyrusMarkerAdapter wrap(Resource resource, IMarker marker) {
        return new PapyrusMarkerAdapter(resource, marker);
    }

    public static final PapyrusMarkerAdapter wrap(Resource resource, IMarker marker, Map attributes) {
        return new PapyrusMarkerAdapter(resource, marker, attributes);
    }

    public static final List<PapyrusMarkerAdapter> wrap(Resource resource, Collection<? extends IMarker> markers) {
        ArrayList<PapyrusMarkerAdapter> result = new ArrayList<PapyrusMarkerAdapter>(markers.size());
        for (IMarker iMarker : markers) {
            result.add(PapyrusMarkerAdapter.wrap(resource, iMarker));
        }
        return result;
    }

    public final IMarker getMarker() {
        return this.marker;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public EObject getEObject() {
        EObject result = null;
        String uriAttribute = null;
        uriAttribute = this.attributes != null ? (String)this.attributes.get("uri") : this.marker.getAttribute("uri", null);
        if (uriAttribute != null) {
            URI uri = URI.createURI((String)uriAttribute);
            if (this.getResource().getURI().equals(uri.trimFragment())) {
                result = this.getResource().getEObject(uri.fragment());
            }
        }
        return result;
    }

    @Override
    public boolean exists() {
        return this.marker.exists();
    }

    @Override
    public String getType() throws CoreException {
        return this.marker.getType();
    }

    @Override
    public String getTypeLabel() throws CoreException {
        return MarkerListenerUtils.getMarkerTypeLabel(this.getType());
    }

    @Override
    public void delete() throws CoreException {
        this.marker.delete();
    }

    @Override
    public Object getAttribute(String name) throws CoreException {
        return this.marker.getAttribute(name);
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        return this.marker.getAttribute(name, defaultValue);
    }

    @Override
    public boolean getAttribute(String name, boolean defaultValue) {
        return this.marker.getAttribute(name, defaultValue);
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        return this.marker.getAttribute(name, defaultValue);
    }

    @Override
    public Map<String, ?> getAttributes() throws CoreException {
        return this.marker.getAttributes();
    }

    @Override
    public void setAttribute(String name, Object value) throws CoreException {
        this.marker.setAttribute(name, value);
    }

    @Override
    public void setAttribute(String name, String value) throws CoreException {
        this.marker.setAttribute(name, (Object)value);
    }

    @Override
    public void setAttribute(String name, boolean value) throws CoreException {
        this.marker.setAttribute(name, value);
    }

    @Override
    public void setAttribute(String name, int value) throws CoreException {
        this.marker.setAttribute(name, value);
    }

    @Override
    public void setAttributes(Map<String, ?> attributes) throws CoreException {
        this.marker.setAttributes(attributes);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PapyrusMarkerAdapter && this.marker.equals((Object)((PapyrusMarkerAdapter)obj).marker);
    }

    @Override
    public int hashCode() {
        return this.marker.hashCode();
    }

    @Override
    public String toString() {
        return String.format("WorkspaceMarker:%s:%s", this.marker.getResource(), this.marker.getId());
    }

    @Override
    public boolean isSubtypeOf(String type) throws CoreException {
        return this.marker.isSubtypeOf(type);
    }
}

