/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;

public class NoExtraHeightLayoutManager
extends AutomaticCompartmentLayoutManager {
    NoExtraHeightLayoutManager() {
        this.addExtraHeight = false;
    }

    protected void optimizeCompartmentSize(IFigure container, int vOffset) {
        int compartmentsHeight = 0;
        int notCompartmentsHeight = vOffset;
        int i = 0;
        while (i < this.notCompartmentList.size()) {
            notCompartmentsHeight += ((IFigure)this.notCompartmentList.get((int)i)).getBounds().height;
            ++i;
        }
        i = 0;
        while (i < this.compartmentList.size()) {
            compartmentsHeight += ((IFigure)this.compartmentList.get((int)i)).getBounds().height;
            ++i;
        }
        int remainingspace = container.getBounds().height - notCompartmentsHeight;
        double ratio = new Integer(compartmentsHeight).doubleValue() / new Integer(remainingspace).doubleValue();
        int i2 = 0;
        while (i2 < this.compartmentList.size()) {
            int value;
            Rectangle bound = new Rectangle(((IFigure)this.compartmentList.get(i2)).getBounds());
            bound.height = value = (int)((double)bound.height / ratio);
            bound.x = container.getBounds().x;
            if (i2 > 0) {
                bound.y = ((IFigure)this.compartmentList.get((int)(i2 - 1))).getBounds().getBottomLeft().y;
            }
            ((IFigure)this.compartmentList.get(i2)).setBounds(bound);
            ++i2;
        }
    }

    public void layout(IFigure container) {
        this.collectInformationOnChildren(container);
        if (this.compartmentList.size() != 0) {
            IFigure previousCompartment = null;
            int vOffset = 0;
            int i = 0;
            while (i < container.getChildren().size()) {
                Rectangle bounds;
                IFigure currentCompartment = (IFigure)container.getChildren().get(i);
                if (currentCompartment.isVisible()) {
                    bounds = new Rectangle(currentCompartment.getBounds());
                    currentCompartment.invalidate();
                    Dimension pref = currentCompartment.getPreferredSize();
                    currentCompartment.invalidate();
                    Dimension prefConstraint = currentCompartment.getPreferredSize(container.getBounds().width - 40, -1);
                    if (pref.width < prefConstraint.width) {
                        bounds.setSize(pref);
                    } else {
                        bounds.setSize(prefConstraint);
                    }
                    if (previousCompartment != null) {
                        bounds.x = container.getBounds().x + 3;
                        bounds.y = previousCompartment.getBounds().getBottomLeft().y + 1;
                        bounds.width = container.getBounds().width;
                    } else {
                        bounds.x = container.getBounds().x + 3;
                        bounds.y = container.getBounds().y;
                        if (this.notCompartmentList.contains(currentCompartment)) {
                            vOffset = 3;
                            bounds.y += vOffset;
                        }
                        bounds.width = container.getBounds().width;
                    }
                    currentCompartment.setBounds(bounds);
                    previousCompartment = currentCompartment;
                } else {
                    bounds = new Rectangle(currentCompartment.getBounds());
                    bounds.setSize(0, 0);
                    currentCompartment.setBounds(bounds);
                }
                ++i;
            }
            this.optimizeCompartmentSize(container, vOffset);
        } else {
            this.layoutCenterForLabel(container);
        }
    }
}

