/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.statemachine/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2000 != nodeVisualID) break;
                return true;
            }
            case 2000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (16000 == nodeVisualID) {
                    return true;
                }
                if (17000 != nodeVisualID) break;
                return true;
            }
            case 3000: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 5000: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 6000: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (690 == nodeVisualID) {
                    return true;
                }
                if (691 == nodeVisualID) {
                    return true;
                }
                if (692 == nodeVisualID) {
                    return true;
                }
                if (680 == nodeVisualID) {
                    return true;
                }
                if (3000 == nodeVisualID) {
                    return true;
                }
                if (16000 == nodeVisualID) {
                    return true;
                }
                if (17000 == nodeVisualID) {
                    return true;
                }
                if (18000 != nodeVisualID) break;
                return true;
            }
            case 8000: {
                if (8001 == nodeVisualID) {
                    return true;
                }
                if (8002 != nodeVisualID) break;
                return true;
            }
            case 9000: {
                if (9001 == nodeVisualID) {
                    return true;
                }
                if (9002 != nodeVisualID) break;
                return true;
            }
            case 10000: {
                if (10001 == nodeVisualID) {
                    return true;
                }
                if (10002 != nodeVisualID) break;
                return true;
            }
            case 11000: {
                if (11001 == nodeVisualID) {
                    return true;
                }
                if (11002 != nodeVisualID) break;
                return true;
            }
            case 12000: {
                if (12001 == nodeVisualID) {
                    return true;
                }
                if (12002 != nodeVisualID) break;
                return true;
            }
            case 13000: {
                if (13001 == nodeVisualID) {
                    return true;
                }
                if (13002 != nodeVisualID) break;
                return true;
            }
            case 14000: {
                if (14001 == nodeVisualID) {
                    return true;
                }
                if (14002 != nodeVisualID) break;
                return true;
            }
            case 15000: {
                if (15001 == nodeVisualID) {
                    return true;
                }
                if (15002 != nodeVisualID) break;
                return true;
            }
            case 16000: {
                if (16001 == nodeVisualID) {
                    return true;
                }
                if (16002 != nodeVisualID) break;
                return true;
            }
            case 17000: {
                if (17001 == nodeVisualID) {
                    return true;
                }
                if (17002 != nodeVisualID) break;
                return true;
            }
            case 18000: {
                if (18001 == nodeVisualID) {
                    return true;
                }
                if (18002 != nodeVisualID) break;
                return true;
            }
            case 666: {
                if (6666 != nodeVisualID) break;
                return true;
            }
            case 668: {
                if (6668 == nodeVisualID) {
                    return true;
                }
                if (6669 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (8000 == nodeVisualID) {
                    return true;
                }
                if (9000 == nodeVisualID) {
                    return true;
                }
                if (10000 == nodeVisualID) {
                    return true;
                }
                if (11000 == nodeVisualID) {
                    return true;
                }
                if (12000 == nodeVisualID) {
                    return true;
                }
                if (13000 == nodeVisualID) {
                    return true;
                }
                if (14000 == nodeVisualID) {
                    return true;
                }
                if (15000 == nodeVisualID) {
                    return true;
                }
                if (5000 == nodeVisualID) {
                    return true;
                }
                if (6000 == nodeVisualID) {
                    return true;
                }
                if (16000 == nodeVisualID) {
                    return true;
                }
                if (17000 == nodeVisualID) {
                    return true;
                }
                if (666 == nodeVisualID) {
                    return true;
                }
                if (668 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (3000 == nodeVisualID) {
                    return true;
                }
                if (16000 == nodeVisualID) {
                    return true;
                }
                if (17000 != nodeVisualID) break;
                return true;
            }
            case 6002: {
                if (3000 == nodeVisualID) {
                    return true;
                }
                if (18000 != nodeVisualID) break;
                return true;
            }
            case 7000: {
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 19000: {
                if (19002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
            return 7000;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 19000;
        }
        return -1;
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLStateMachineDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) break;
                return 2000;
            }
            case 2000: {
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_16000(containerView, (Pseudostate)domainElement)) {
                    return 16000;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_17000(containerView, (Pseudostate)domainElement)) break;
                return 17000;
            }
            case 6000: {
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_690(containerView, (Behavior)domainElement)) {
                    return 690;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_691(containerView, (Behavior)domainElement)) {
                    return 691;
                }
                if (UMLPackage.eINSTANCE.getBehavior().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isBehavior_692(containerView, (Behavior)domainElement)) {
                    return 692;
                }
                if (UMLPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
                    return 680;
                }
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_16000(containerView, (Pseudostate)domainElement)) {
                    return 16000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_17000(containerView, (Pseudostate)domainElement)) {
                    return 17000;
                }
                if (!UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass())) break;
                return 18000;
            }
            case 3002: {
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_8000(containerView, (Pseudostate)domainElement)) {
                    return 8000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_9000(containerView, (Pseudostate)domainElement)) {
                    return 9000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_10000(containerView, (Pseudostate)domainElement)) {
                    return 10000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_11000(containerView, (Pseudostate)domainElement)) {
                    return 11000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_12000(containerView, (Pseudostate)domainElement)) {
                    return 12000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_13000(containerView, (Pseudostate)domainElement)) {
                    return 13000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_14000(containerView, (Pseudostate)domainElement)) {
                    return 14000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_15000(containerView, (Pseudostate)domainElement)) {
                    return 15000;
                }
                if (UMLPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 5000;
                }
                if (UMLPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass())) {
                    return 6000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_16000(containerView, (Pseudostate)domainElement)) {
                    return 16000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_17000(containerView, (Pseudostate)domainElement)) {
                    return 17000;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 666;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 668;
            }
            case 2002: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3000;
                }
                if (UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isPseudostate_16000(containerView, (Pseudostate)domainElement)) {
                    return 16000;
                }
                if (!UMLPackage.eINSTANCE.getPseudostate().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isPseudostate_17000(containerView, (Pseudostate)domainElement)) break;
                return 17000;
            }
            case 6002: {
                if (UMLPackage.eINSTANCE.getRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3000;
                }
                if (!UMLPackage.eINSTANCE.getConnectionPointReference().isSuperTypeOf(domainElement.eClass())) break;
                return 18000;
            }
        }
        return -1;
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLStateMachineDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isPseudostate_10000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.FORK_LITERAL);
    }

    private static boolean isPseudostate_11000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.CHOICE_LITERAL);
    }

    private static boolean isPseudostate_12000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.JUNCTION_LITERAL);
    }

    private static boolean isPseudostate_13000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
    }

    private static boolean isPseudostate_14000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.DEEP_HISTORY_LITERAL);
    }

    private static boolean isPseudostate_15000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.TERMINATE_LITERAL);
    }

    private static boolean isPseudostate_16000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.ENTRY_POINT_LITERAL);
    }

    private static boolean isPseudostate_17000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
    }

    private static boolean isBehavior_690(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_691(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_692(Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 2002: 
            case 3002: 
            case 6002: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 666: 
            case 668: 
            case 680: 
            case 690: 
            case 691: 
            case 692: 
            case 5000: 
            case 8000: 
            case 9000: 
            case 10000: 
            case 11000: 
            case 12000: 
            case 13000: 
            case 14000: 
            case 15000: 
            case 16000: 
            case 17000: 
            case 18000: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPseudostate_8000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.INITIAL_LITERAL);
    }

    private static boolean isPseudostate_9000(View containerView, Pseudostate domainElement) {
        PseudostateKind kind;
        return domainElement instanceof Pseudostate && (kind = domainElement.getKind()).equals((Object)PseudostateKind.JOIN_LITERAL);
    }

    private static boolean isBehavior_690(View containerView, Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_691(View containerView, Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isBehavior_692(View containerView, Behavior domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getBehavior(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }
}

