/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.internal.ColumnComparator;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.ENamedElementComparator;
import org.eclipse.papyrus.infra.table.common.editor.AbstractNattableEditor;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.AdditionalContentsUtils;
import org.eclipse.papyrus.uml.table.common.dialog.ColumnsToShowDialog;
import org.eclipse.papyrus.uml.table.common.editor.AbstractUMLTableEditor;
import org.eclipse.papyrus.uml.table.common.provider.AbstractAdditionalContentsProvider;
import org.eclipse.papyrus.uml.table.common.provider.EMFFacetColumnsProvider;
import org.eclipse.papyrus.uml.table.common.provider.ProfileFacetSetProvider;
import org.eclipse.papyrus.uml.table.common.provider.SortedFeaturesContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectColumnsHandler
extends AbstractHandler {
    private final SortedSet<ETypedElement> allDirectFeatures = new TreeSet<ETypedElement>((Comparator<ETypedElement>)new ENamedElementComparator());
    private final Collection<FacetSet> allAdditionalContents = new HashSet<FacetSet>();
    private final Collection<ETypedElement> initialDirectFeatureSelected = new HashSet<ETypedElement>();
    private final Collection<ETypedElement> initialAdditionalFeatureSelected = new HashSet<ETypedElement>();
    private final Collection<FacetSet> facetSetsUsedInTheTable = new HashSet<FacetSet>();
    private final Map<ETypedElement, Column> columnsFeatureMap = new HashMap<ETypedElement, Column>();
    private final Map<Column, Boolean> defaultColumnsAndVisibility = new TreeMap<Column, Boolean>((Comparator<Column>)new ColumnComparator());

    protected void clearFields() {
        this.allDirectFeatures.clear();
        this.initialDirectFeatureSelected.clear();
        this.initialAdditionalFeatureSelected.clear();
        this.facetSetsUsedInTheTable.clear();
        this.columnsFeatureMap.clear();
        this.allAdditionalContents.clear();
        this.defaultColumnsAndVisibility.clear();
    }

    /*
     * Unable to fully structure code
     */
    private FacetSet getRootFacetSet(EObject facetElement) {
        container = facetElement;
        while (container.eContainer() != null) {
            container = container.eContainer();
        }
        if (container instanceof FacetSet) {
            return (FacetSet)container;
        }
        if (facetElement instanceof FacetStructuralFeature) {
            container = facetElement.eContainer().eContainer();
        }
        if (facetElement instanceof Facet) {
            container = facetElement.eContainer();
        }
        if (facetElement instanceof FacetSet) {
            container = facetElement;
        }
        if (SelectColumnsHandler.$assertionsDisabled || container instanceof FacetSet) ** GOTO lbl16
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            container = container.eContainer();
lbl16:
            // 2 sources

            ** while (container.eContainer() != null && container.eContainer() instanceof FacetSet)
        }
lbl17:
        // 1 sources

        return (FacetSet)container;
    }

    protected void initField(NatTableWidget widget, PapyrusTableInstance papyrusTable) {
        this.clearFields();
        EList contents = papyrusTable.getTable().getElements();
        for (EObject current : contents) {
            this.allDirectFeatures.addAll((Collection<ETypedElement>)current.eClass().getEAllStructuralFeatures());
        }
        List visibleColumns = widget.getVisibleColumns(false);
        HashSet visibleFeatures = new HashSet();
        for (Column current : visibleColumns) {
            if (current instanceof AttributeColumn) {
                this.initialDirectFeatureSelected.add((ETypedElement)((AttributeColumn)current).getFeature());
                continue;
            }
            if (current instanceof ReferenceColumn) {
                this.initialDirectFeatureSelected.add((ETypedElement)((ReferenceColumn)current).getFeature());
                continue;
            }
            if (current instanceof FacetAttributeColumn) {
                this.initialAdditionalFeatureSelected.add((ETypedElement)((FacetAttributeColumn)current).getAttribute());
                continue;
            }
            if (!(current instanceof FacetReferenceColumn)) continue;
            this.initialAdditionalFeatureSelected.add((ETypedElement)((FacetReferenceColumn)current).getReference());
        }
        for (Column current : papyrusTable.getTable().getColumns()) {
            if (current instanceof DefaultLabelColumn) {
                this.defaultColumnsAndVisibility.put(current, !current.isIsHidden());
                continue;
            }
            if (current instanceof MetaClassColumn) {
                this.defaultColumnsAndVisibility.put(current, !current.isIsHidden());
                continue;
            }
            if (!(current instanceof EContainerColumn)) continue;
            this.defaultColumnsAndVisibility.put(current, !current.isIsHidden());
        }
        for (Column current : papyrusTable.getTable().getColumns()) {
            if (!(current instanceof FeatureColumn)) continue;
            EStructuralFeature feature = ((FeatureColumn)current).getFeature();
            assert (feature != null);
            this.columnsFeatureMap.put((ETypedElement)feature, current);
            if (!(feature instanceof FacetStructuralFeature)) continue;
            FacetSet set = this.getRootFacetSet((EObject)feature);
            this.facetSetsUsedInTheTable.add(set);
        }
        EPackage additionalContentsPackageRoot = AdditionalContentsUtils.getAdditionalContentsEPackage((PapyrusTableInstance)papyrusTable);
        if (additionalContentsPackageRoot != null) {
            EList sets = additionalContentsPackageRoot.getESubpackages();
            for (EPackage ePackage : sets) {
                if (!(ePackage instanceof FacetSet)) continue;
                this.allAdditionalContents.add((FacetSet)ePackage);
            }
        }
        this.allAdditionalContents.addAll(this.facetSetsUsedInTheTable);
        AbstractAdditionalContentsProvider provider = new EMFFacetColumnsProvider();
        provider.setPapyrusTable(papyrusTable);
        this.allAdditionalContents.addAll(provider.getAdditionalFeatures());
        provider = new ProfileFacetSetProvider();
        provider.setPapyrusTable(papyrusTable);
        this.allAdditionalContents.addAll(provider.getAdditionalFeatures());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand compoundCmd = new CompoundCommand("Papyrus Show/Hide columns command");
        PapyrusTableInstance papyrusTable = this.getPapyrusTable();
        NatTableWidget widget = this.getTableWidget();
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (papyrusTable != null && widget != null) {
            this.initField(widget, papyrusTable);
            ArrayList<ETypedElement> initialSelection = new ArrayList<ETypedElement>();
            initialSelection.addAll(this.initialDirectFeatureSelected);
            initialSelection.addAll(this.initialAdditionalFeatureSelected);
            TreeSet<ENamedElement> allFacetSets = new TreeSet<ENamedElement>((Comparator<ENamedElement>)new ENamedElementComparator());
            allFacetSets.addAll(this.facetSetsUsedInTheTable);
            allFacetSets.addAll(this.allAdditionalContents);
            SortedFeaturesContentProvider contentProvider = new SortedFeaturesContentProvider();
            ColumnsToShowDialog dialog = new ColumnsToShowDialog(Display.getCurrent().getActiveShell(), this.defaultColumnsAndVisibility, this.allDirectFeatures, allFacetSets, initialSelection, this.getLabelProvider(), (IContentProvider)contentProvider);
            if (dialog.open() == 0) {
                Command cmd2;
                Command cmd;
                Object[] result = dialog.getResult();
                Set directFeatures = (Set)result[0];
                Set additionalFeatures = (Set)result[1];
                for (Column col : this.defaultColumnsAndVisibility.keySet()) {
                    Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)col, (Object)TableinstancePackage.eINSTANCE.getColumn_IsHidden(), (Object)(this.defaultColumnsAndVisibility.get(col) == false ? 1 : 0));
                    compoundCmd.append(cmd3);
                }
                if (!directFeatures.equals(this.initialDirectFeatureSelected) && (cmd = this.getShowHideDirectFeatureColumnsCommand(papyrusTable, widget, directFeatures)) != null) {
                    compoundCmd.append(cmd);
                }
                if (!additionalFeatures.equals(this.initialAdditionalFeatureSelected) && (cmd2 = this.getCreateDestroyAdditonalFeatureColumnsCommand(papyrusTable, widget, additionalFeatures)) != null) {
                    compoundCmd.append(cmd2);
                }
                if (!compoundCmd.isEmpty()) {
                    domain.getCommandStack().execute((Command)compoundCmd);
                }
            }
        }
        this.clearFields();
        return null;
    }

    protected Command getShowHideDirectFeatureColumnsCommand(PapyrusTableInstance papyrusTable, NatTableWidget widget, Collection<ETypedElement> selectedFeatures) {
        CompoundCommand compoundCmd = new CompoundCommand("Show/Hide direct features command");
        ArrayList<ETypedElement> featuresToAdd = new ArrayList<ETypedElement>(selectedFeatures);
        featuresToAdd.removeAll(this.initialDirectFeatureSelected);
        ArrayList<ETypedElement> directFeaturesToHide = new ArrayList<ETypedElement>(this.initialDirectFeatureSelected);
        directFeaturesToHide.removeAll(selectedFeatures);
        ArrayList<Column> columnsToHide = new ArrayList<Column>();
        for (Object e : directFeaturesToHide) {
            Column column = this.columnsFeatureMap.get(e);
            if (column == null) continue;
            columnsToHide.add(column);
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ArrayList<ETypedElement> columnsToCreate = new ArrayList<ETypedElement>();
        for (Object e : featuresToAdd) {
            if (this.columnsFeatureMap.containsKey(e)) {
                arrayList.add(this.columnsFeatureMap.get(e));
                continue;
            }
            columnsToCreate.add((ETypedElement)e);
        }
        TransactionalEditingDomain transactionalEditingDomain = this.getEditingDomain();
        Command showHideColumnsCommand = TableInstanceCommandFactory.createShowHideColumnCommand((NatTableWidget)widget, arrayList, columnsToHide, (boolean)false);
        if (showHideColumnsCommand != null && showHideColumnsCommand.canExecute()) {
            compoundCmd.append(showHideColumnsCommand);
        }
        assert (columnsToCreate.isEmpty());
        if (!compoundCmd.isEmpty() && compoundCmd.canExecute()) {
            return compoundCmd;
        }
        return null;
    }

    protected Command getCreateDestroyAdditonalFeatureColumnsCommand(PapyrusTableInstance papyrusTable, NatTableWidget widget, Collection<ETypedElement> selectedAdditionalFeatures) {
        Command removeColumns;
        Command createColumns;
        CompoundCommand compoundCmd = new CompoundCommand("Show/Hide additional features command");
        ModelSet resourceSet = (ModelSet)papyrusTable.eResource().getResourceSet();
        Resource notationResource = resourceSet.getAssociatedResource(papyrusTable.eResource(), "notation");
        TransactionalEditingDomain domain = this.getEditingDomain();
        EPackage additionFeatureRootEPackage = AdditionalContentsUtils.getAdditionalContentsEPackage((PapyrusTableInstance)papyrusTable);
        ArrayList<ETypedElement> featuresToAdd = new ArrayList<ETypedElement>(selectedAdditionalFeatures);
        featuresToAdd.removeAll(this.initialAdditionalFeatureSelected);
        ArrayList<ETypedElement> columnsToCreate = new ArrayList<ETypedElement>();
        columnsToCreate.addAll(featuresToAdd);
        ArrayList<Column> existingColumnsToShow = new ArrayList<Column>();
        ListIterator iter = columnsToCreate.listIterator();
        while (iter.hasNext()) {
            ETypedElement current = (ETypedElement)iter.next();
            if (!this.columnsFeatureMap.containsKey(current)) continue;
            existingColumnsToShow.add(this.columnsFeatureMap.get(current));
            iter.remove();
        }
        ArrayList<ETypedElement> additionalFeaturesToHide = new ArrayList<ETypedElement>(this.initialAdditionalFeatureSelected);
        additionalFeaturesToHide.removeAll(selectedAdditionalFeatures);
        HashSet<FacetSet> requiredSubFacetSets = new HashSet<FacetSet>();
        HashSet<Facet> requiredFacets = new HashSet<Facet>();
        HashSet<FacetSet> requiredRootFacetSet = new HashSet<FacetSet>();
        for (ETypedElement current : selectedAdditionalFeatures) {
            if (!(current instanceof FacetStructuralFeature)) continue;
            Facet facet = (Facet)current.eContainer();
            requiredFacets.add(facet);
            requiredSubFacetSets.add((FacetSet)facet.eContainer());
            requiredRootFacetSet.add(this.getRootFacetSet((EObject)current));
        }
        Collection<FacetSet> facetSetsToStore = this.getFacetSetToStore(requiredSubFacetSets);
        HashSet<FacetSet> uselessRootFacetSetsInAllExistingTable = new HashSet<FacetSet>();
        HashSet<FacetSet> uselessRootFacetSetsInCurrentTable = new HashSet<FacetSet>();
        if (additionFeatureRootEPackage != null) {
            for (EPackage set : additionFeatureRootEPackage.getESubpackages()) {
                if (!(set instanceof FacetSet) || requiredRootFacetSet.contains(set)) continue;
                uselessRootFacetSetsInCurrentTable.add((FacetSet)set);
                TreeIterator it = set.eAllContents();
                boolean useless = true;
                while (it.hasNext() && useless) {
                    EObject value = (EObject)it.next();
                    if (!(value instanceof FacetStructuralFeature)) continue;
                    CrossReferenceAdapter eCrossReference = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)papyrusTable.eResource().getResourceSet());
                    Collection references = eCrossReference.getInverseReferences(value, false);
                    Iterator settingIter = references.iterator();
                    while (settingIter.hasNext() && useless) {
                        EObject ref = ((EStructuralFeature.Setting)settingIter.next()).getEObject();
                        if (!(ref instanceof Column) || ref.eContainer() == null || ref.eResource() == null) continue;
                        useless = papyrusTable.getTable().getColumns().contains((Object)ref);
                    }
                }
                if (!useless) continue;
                uselessRootFacetSetsInAllExistingTable.add((FacetSet)set);
            }
        }
        HashSet newRegisteredRootFacetSetValue = new HashSet();
        HashSet<FacetSet> oldRegisteredRootFacetSetValue = new HashSet<FacetSet>();
        if (additionFeatureRootEPackage != null) {
            for (EPackage current : additionFeatureRootEPackage.getESubpackages()) {
                if (!(current instanceof FacetSet)) continue;
                oldRegisteredRootFacetSetValue.add((FacetSet)current);
            }
        }
        newRegisteredRootFacetSetValue.addAll(oldRegisteredRootFacetSetValue);
        newRegisteredRootFacetSetValue.addAll(facetSetsToStore);
        newRegisteredRootFacetSetValue.removeAll(uselessRootFacetSetsInAllExistingTable);
        if (additionFeatureRootEPackage == null && newRegisteredRootFacetSetValue.size() != 0) {
            additionFeatureRootEPackage = AdditionalContentsUtils.createAdditionalContentsEPackage();
            compoundCmd.append(SelectColumnsHandler.addToResourceAdditionalContentsEPackage(domain, notationResource, additionFeatureRootEPackage));
            compoundCmd.append(SelectColumnsHandler.storeProfileFacetSet(domain, notationResource, additionFeatureRootEPackage, facetSetsToStore));
        } else if (additionFeatureRootEPackage != null && !newRegisteredRootFacetSetValue.equals(oldRegisteredRootFacetSetValue)) {
            compoundCmd.append(SelectColumnsHandler.storeProfileFacetSet(domain, notationResource, additionFeatureRootEPackage, facetSetsToStore));
            compoundCmd.append(SelectColumnsHandler.unstoreProfileFacetSet(domain, notationResource, additionFeatureRootEPackage, uselessRootFacetSetsInAllExistingTable));
        }
        if (columnsToCreate.size() != 0 && (createColumns = this.createAddColumnsCommand(domain, papyrusTable, columnsToCreate)) != null && createColumns.canExecute()) {
            compoundCmd.append(createColumns);
        }
        if (additionalFeaturesToHide.size() != 0 && (removeColumns = this.createRemoveColumnsCommand(domain, papyrusTable, additionalFeaturesToHide)) != null && removeColumns.canExecute()) {
            compoundCmd.append(removeColumns);
        }
        if (newRegisteredRootFacetSetValue.size() == 0 && additionFeatureRootEPackage != null) {
            compoundCmd.append(SelectColumnsHandler.removeFromNotationResourceAdditionalContentsEPackage(domain, notationResource, additionFeatureRootEPackage));
        }
        Collection<Facet> facetsToSetInTableContext = this.getFacetsToApplyOnTheTable(papyrusTable, requiredFacets);
        compoundCmd.append(SelectColumnsHandler.updateFacetsAppliedToTheTable(domain, papyrusTable, facetsToSetInTableContext));
        if (!compoundCmd.isEmpty()) {
            return compoundCmd;
        }
        return null;
    }

    private Collection<Facet> getFacetsToApplyOnTheTable(PapyrusTableInstance papyrusTable, Collection<Facet> requiredFacets) {
        Collection<Facet> facetsForOtherThings = this.getFacetUsedForOtherThingsThanColumns(papyrusTable);
        ArrayList<Facet> facetsToSetInTableContext = new ArrayList<Facet>();
        facetsToSetInTableContext.addAll(facetsForOtherThings);
        facetsToSetInTableContext.addAll(requiredFacets);
        return facetsToSetInTableContext;
    }

    private Collection<FacetSet> getFacetSetToStore(Set<FacetSet> requiredSubFacetSets) {
        HashSet<FacetSet> toAddToResource = new HashSet<FacetSet>();
        for (FacetSet set : requiredSubFacetSets) {
            if (set.eResource() != null) continue;
            toAddToResource.add(this.getRootFacetSet((EObject)set));
        }
        return toAddToResource;
    }

    private Collection<FacetSet> getAllOwnedFacetSet(FacetSet set) {
        ArrayList<FacetSet> coll = new ArrayList<FacetSet>();
        if (set instanceof ProfileFacetSet) {
            for (ProfileFacetSet profileSet : ((ProfileFacetSet)set).getSubProfileFacetSet()) {
                coll.add((FacetSet)profileSet);
                coll.addAll(this.getAllOwnedFacetSet((FacetSet)profileSet));
            }
        }
        return coll;
    }

    private Collection<FacetSet> getOwnedFacetSets(EPackage additionFeatureRootFacetSet) {
        ArrayList<FacetSet> ownedFacetSets = new ArrayList<FacetSet>();
        for (EPackage pack : additionFeatureRootFacetSet.getESubpackages()) {
            if (!(pack instanceof FacetSet)) continue;
            ownedFacetSets.add((FacetSet)pack);
        }
        return ownedFacetSets;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain domain = null;
        domain = TransactionUtil.getEditingDomain((EObject)this.getPapyrusTable());
        return domain;
    }

    private AbstractNattableEditor getCurrentTableEditor() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof IMultiDiagramEditor) {
            part = ((IMultiDiagramEditor)part).getActiveEditor();
        }
        if (part instanceof AbstractNattableEditor) {
            return (AbstractNattableEditor)part;
        }
        return null;
    }

    protected PapyrusTableInstance getPapyrusTable() {
        AbstractNattableEditor part = this.getCurrentTableEditor();
        if (part != null) {
            return (PapyrusTableInstance)part.getAdapter(PapyrusTableInstance.class);
        }
        return null;
    }

    protected NatTableWidget getTableWidget() {
        INatTableWidgetProvider provider;
        AbstractNattableEditor editor = this.getCurrentTableEditor();
        if (editor != null && (provider = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class)) != null) {
            return (NatTableWidget)provider.getNatTableWidget();
        }
        return null;
    }

    private ILabelProvider getLabelProvider() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
        return labelProvider;
    }

    private Command createAddColumnsCommand(TransactionalEditingDomain domain, PapyrusTableInstance pTable, Collection<ETypedElement> columnsToAdd) {
        CompoundCommand cmd = new CompoundCommand("Create New Columns");
        ICommandFactory factory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor((EditingDomain)domain);
        int width = 100;
        for (ETypedElement current : columnsToAdd) {
            Command addCommand;
            FacetAttributeColumn col;
            if (current instanceof FacetAttribute) {
                col = TableinstanceFactory.eINSTANCE.createFacetAttributeColumn();
                col.setAttribute((FacetAttribute)current);
                col.setWidth(100);
                addCommand = factory.createAddCommand((EditingDomain)domain, (Object)pTable.getTable(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)col);
                if (!addCommand.canExecute()) continue;
                cmd.append(addCommand);
                continue;
            }
            if (!(current instanceof FacetReference)) continue;
            col = TableinstanceFactory.eINSTANCE.createFacetReferenceColumn();
            col.setReference((FacetReference)current);
            col.setWidth(100);
            addCommand = factory.createAddCommand((EditingDomain)domain, (Object)pTable.getTable(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)col);
            if (!addCommand.canExecute()) continue;
            cmd.append(addCommand);
        }
        if (cmd.canExecute()) {
            return cmd;
        }
        return null;
    }

    private Command createRemoveColumnsCommand(TransactionalEditingDomain domain, PapyrusTableInstance pTable, Collection<ETypedElement> columnsToDestroy) {
        CompoundCommand cmd = new CompoundCommand("Destroy existing Columns");
        ICommandFactory factory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor((EditingDomain)domain);
        for (ETypedElement current : columnsToDestroy) {
            if (!(current instanceof EStructuralFeature)) continue;
            Column column = this.columnsFeatureMap.get(current);
            Command rmColumnCmd = factory.createRemoveCommand((EditingDomain)domain, (Object)pTable.getTable(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Columns(), (Object)column);
            if (!rmColumnCmd.canExecute()) continue;
            cmd.append(rmColumnCmd);
        }
        if (cmd.canExecute()) {
            return cmd;
        }
        return null;
    }

    private Collection<Facet> getFacetUsedForOtherThingsThanColumns(PapyrusTableInstance papyrusTable) {
        HashSet<Facet> setForOtherThings = new HashSet<Facet>();
        for (Facet current : papyrusTable.getTable().getFacets2()) {
            setForOtherThings.add(current);
        }
        for (Facet current : papyrusTable.getTable().getColumns()) {
            EStructuralFeature element;
            if (!(current instanceof FeatureColumn) || !((element = ((FeatureColumn)current).getFeature()) instanceof FacetStructuralFeature)) continue;
            setForOtherThings.remove(((FacetStructuralFeature)element).eContainer());
        }
        return setForOtherThings;
    }

    public static final Command removeFromNotationResourceAdditionalContentsEPackage(TransactionalEditingDomain domain, final Resource resource, final EPackage pack) {
        AbstractTransactionalCommand removeFacetSet = new AbstractTransactionalCommand(domain, "Remove FacetSet from the resource", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                resource.getContents().remove((Object)pack);
                return CommandResult.newOKCommandResult();
            }
        };
        return new GMFtoEMFCommandWrapper((ICommand)removeFacetSet);
    }

    public static final Command addToResourceAdditionalContentsEPackage(TransactionalEditingDomain domain, final Resource resource, final EPackage ePackage) {
        AbstractTransactionalCommand removeFacetSet = new AbstractTransactionalCommand(domain, "Add FacetSet from the resource", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                resource.getContents().add((Object)ePackage);
                return CommandResult.newOKCommandResult();
            }
        };
        return new GMFtoEMFCommandWrapper((ICommand)removeFacetSet);
    }

    public static final Command storeProfileFacetSet(TransactionalEditingDomain domain, Resource resource, final EPackage additionFeatureRootEPackage, final Collection<FacetSet> newRegisteredSubFacetSet) {
        CompoundCommand cc = new CompoundCommand("Store Generated facetSet and Queries");
        ModelSet modelSet = (ModelSet)resource.getResourceSet();
        final Resource notationResource = modelSet.getAssociatedResource(resource, "notation");
        for (FacetSet set : newRegisteredSubFacetSet) {
            Collection<ModelQuery> queriesToSave = SelectColumnsHandler.getAllUnregisteredQueries((EObject)set);
            if (queriesToSave.isEmpty()) continue;
            final ModelQuerySet querySet = QueryFactory.eINSTANCE.createModelQuerySet();
            querySet.setName("QueriesFor_" + set.getName());
            querySet.setDescription(NLS.bind((String)"Queries used by the generated facetset {0}", (Object)set.getName()));
            querySet.getAssociatedMetamodels().add((Object)UMLPackage.eINSTANCE);
            querySet.getAssociatedMetamodels().add((Object)EcorePackage.eINSTANCE);
            querySet.getQueries().addAll(queriesToSave);
            AbstractTransactionalCommand addQuerySet = new AbstractTransactionalCommand(domain, "Add QuerySetToResource", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    notationResource.getContents().add((Object)querySet);
                    return CommandResult.newOKCommandResult();
                }
            };
            cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)addQuerySet));
        }
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                additionFeatureRootEPackage.getESubpackages().addAll(newRegisteredSubFacetSet);
                return CommandResult.newOKCommandResult();
            }
        };
        cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
        return cc;
    }

    public static final Collection<ModelQuery> getAllUnregisteredQueries(EObject eobject) {
        Collection<ModelQuery> allQueries = SelectColumnsHandler.getAllQueries(eobject);
        ArrayList<ModelQuery> notYetRegistered = new ArrayList<ModelQuery>();
        for (ModelQuery modelQuery : allQueries) {
            if (modelQuery.eResource() != null) continue;
            notYetRegistered.add(modelQuery);
        }
        return notYetRegistered;
    }

    public static final Collection<ModelQuery> getAllQueries(EObject eobject) {
        HashSet<ModelQuery> queries = new HashSet<ModelQuery>();
        if (eobject instanceof ProfileFacetSet) {
            for (FacetSet set : ((ProfileFacetSet)eobject).getSubProfileFacetSet()) {
                queries.addAll(SelectColumnsHandler.getAllQueries((EObject)set));
            }
            for (Facet facet : ((ProfileFacetSet)eobject).getStereotypeFacets()) {
                queries.addAll(SelectColumnsHandler.getAllQueries((EObject)facet));
            }
        } else if (eobject instanceof StereotypeFacet) {
            for (StereotypePropertyElement feature : ((StereotypeFacet)eobject).getStereotypePropertyElements()) {
                queries.addAll(SelectColumnsHandler.getAllQueries((EObject)feature));
            }
            queries.add(((StereotypeFacet)eobject).getConditionQuery());
        } else if (eobject instanceof FacetStructuralFeature) {
            FacetStructuralFeature feature = (FacetStructuralFeature)eobject;
            ModelQuery setQuery = feature.getSetQuery();
            ModelQuery getQuery = feature.getValueQuery();
            if (setQuery != null) {
                queries.add(setQuery);
            }
            if (getQuery != null) {
                queries.add(getQuery);
            }
        }
        return queries;
    }

    public static final Command unstoreProfileFacetSet(TransactionalEditingDomain domain, final Resource resource, final EPackage additionFeatureRootEPackage, final Collection<FacetSet> toRemove) {
        CompoundCommand cc = new CompoundCommand("Unstore Generated facetSet and Queries");
        for (FacetSet set : toRemove) {
            Collection<ModelQuery> allQueries = SelectColumnsHandler.getAllQueries((EObject)set);
            final ArrayList<ModelQuerySet> querySets = new ArrayList<ModelQuerySet>();
            for (ModelQuery modelQuery : allQueries) {
                querySets.add(modelQuery.getModelQuerySet());
                AbstractTransactionalCommand removeQuerySet = new AbstractTransactionalCommand(domain, "Add QuerySetToResource", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        resource.getContents().removeAll(querySets);
                        return CommandResult.newOKCommandResult();
                    }
                };
                cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)removeQuerySet));
            }
        }
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                additionFeatureRootEPackage.getESubpackages().removeAll(toRemove);
                return CommandResult.newOKCommandResult();
            }
        };
        cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
        return cc;
    }

    public static final Command updateFacetsAppliedToTheTable(TransactionalEditingDomain domain, final PapyrusTableInstance pTable, final Collection<Facet> facets) {
        AbstractTransactionalCommand updateContext = new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EList currentFacets = pTable.getTable().getFacets2();
                currentFacets.clear();
                currentFacets.addAll(facets);
                return CommandResult.newOKCommandResult();
            }
        };
        return new GMFtoEMFCommandWrapper((ICommand)updateContext);
    }

    public boolean isEnabled() {
        return this.getPapyrusTable() != null && this.getCurrentTableEditor() instanceof AbstractUMLTableEditor;
    }

    public final SortedSet<ETypedElement> getAllDirectFeatures() {
        return this.allDirectFeatures;
    }

    public final Collection<FacetSet> getAllAdditionalContents() {
        return this.allAdditionalContents;
    }

    public final Collection<ETypedElement> getInitialDirectFeatureSelected() {
        return this.initialDirectFeatureSelected;
    }

    public final Collection<ETypedElement> getInitialAdditionalFeatureSelected() {
        return this.initialAdditionalFeatureSelected;
    }

    public final Collection<FacetSet> getFacetSetsUsedInTheTable() {
        return this.facetSetsUsedInTheTable;
    }

    public final Map<ETypedElement, Column> getColumnsFeatureMap() {
        return this.columnsFeatureMap;
    }
}

