/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.readonly;

import com.google.common.base.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.readonly.AbstractReadOnlyHandler;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppliedProfileReadOnlyHandler
extends AbstractReadOnlyHandler {
    public AppliedProfileReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(URI[] uris) {
        if (this.getEditingDomain() != null) {
            Resource mainUmlResource = null;
            if (this.getEditingDomain().getResourceSet() instanceof ModelSet) {
                UmlModel umlModel = (UmlModel)((ModelSet)this.getEditingDomain().getResourceSet()).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (umlModel == null) {
                    return Optional.absent();
                }
                mainUmlResource = umlModel.getResource();
            }
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                Resource resource = this.getEditingDomain().getResourceSet().getResource(uri, false);
                if (this.isProfileResource(resource) && mainUmlResource != resource) {
                    return Optional.of((Object)Boolean.TRUE);
                }
                ++n2;
            }
        }
        return Optional.absent();
    }

    private boolean isProfileResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Profile;
    }

    public Optional<Boolean> makeWritable(URI[] uris) {
        return Optional.absent();
    }
}

