/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.commands.AbstractValidateCommand;

public class ValidateDelMarkersFromModelCommand
extends AbstractValidateCommand {
    public ValidateDelMarkersFromModelCommand(EObject selectedElement, IPapyrusDiagnostician diagnostician) {
        super("Delete markers from model", TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement, diagnostician);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Resource resource = this.getValidationResource();
        if (resource != null) {
            try {
                MarkerListenerUtils.getMarkerProvider((Resource)this.getValidationResource()).deleteMarkers(resource, monitor);
            }
            catch (CoreException e) {
                throw new ExecutionException("Failed to delete all markers.", (Throwable)e);
            }
        }
        return null;
    }
}

