/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.GeneralOrderingCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class CustomGeneralOrderingCreateCommand
extends GeneralOrderingCreateCommand {
    protected final EObject source;
    protected final EObject target;
    protected InteractionFragment container;

    public CustomGeneralOrderingCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
        List<OccurrenceSpecification> possibleSourceOcc = null;
        if (this.getRequest().getParameters().containsKey("Nearest occurrence specification")) {
            List<OccurrenceSpecification> occ1List;
            Object paramOccurrence1 = this.getRequest().getParameter("Nearest occurrence specification");
            possibleSourceOcc = occ1List = SequenceUtil.getAsOccSpecList(paramOccurrence1);
        }
        List<OccurrenceSpecification> possibleTargetOcc = null;
        if (this.getRequest().getParameters().containsKey("Nearest occurrence specification (end)")) {
            List<OccurrenceSpecification> occ2List;
            Object paramOccurrence2 = this.getRequest().getParameter("Nearest occurrence specification (end)");
            possibleTargetOcc = occ2List = SequenceUtil.getAsOccSpecList(paramOccurrence2);
        }
        this.source = possibleSourceOcc != null && !possibleSourceOcc.isEmpty() ? (EObject)possibleSourceOcc.get(0) : null;
        this.target = possibleTargetOcc != null && !possibleTargetOcc.isEmpty() && Collections.disjoint(possibleSourceOcc, possibleTargetOcc) ? (EObject)possibleTargetOcc.get(0) : target;
        this.container = this.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof OccurrenceSpecification)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof OccurrenceSpecification)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateGeneralOrdering_4012(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected OccurrenceSpecification getSource() {
        return (OccurrenceSpecification)this.source;
    }

    protected OccurrenceSpecification getTarget() {
        return (OccurrenceSpecification)this.target;
    }

    public InteractionFragment getContainer() {
        return this.container;
    }
}

