/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.emf.appearance.helper.NameLabelIconHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.PackageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.UMLEditPartFactory;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLParserProvider;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Feature;

public class ContinuationNameEditPart
extends PapyrusCompartmentEditPart
implements ITextAwareEditPart {
    public static final int VISUAL_ID = 5007;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;
    private static final String ADD_PARENT_MODEL = "AddParentModel";

    public ContinuationNameEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PackageEditPart.NodeLabelDragPolicy());
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(CenteredWrappedLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        EObject parserElement = this.getParserElement();
        if (parserElement == null) {
            return null;
        }
        List views = DiagramEditPartsUtil.findViews((EObject)parserElement, (EditPartViewer)this.getViewer());
        for (View view : views) {
            if (!NameLabelIconHelper.showLabelIcon((EModelElement)view)) continue;
            return UMLElementTypes.getImage((ENamedElement)parserElement.eClass());
        }
        return null;
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = ContinuationNameEditPart.this.getParserElement();
                    final IParser parser = ContinuationNameEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)ContinuationNameEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = UMLParserProvider.getParser(UMLElementTypes.Continuation_3016, this.getParserElement(), UMLVisualIDRegistry.getType(5007));
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        ContinuationNameEditPart.this.configuration.postEditAction((Object)ContinuationNameEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            if (ContinuationNameEditPart.this.isActive() && ContinuationNameEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    ContinuationNameEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && ContinuationNameEditPart.this.getEditText().equals(ContinuationNameEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    ContinuationNameEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    ContinuationNameEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
        if (this.resolveSemanticElement() instanceof Feature) {
            if (((Feature)this.resolveSemanticElement()).isStatic()) {
                ((WrappingLabel)this.getFigure()).setTextUnderline(true);
            } else {
                ((WrappingLabel)this.getFigure()).setTextUnderline(false);
            }
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = ContinuationNameEditPart.this.getLabelTextHelper(ContinuationNameEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (ContinuationNameEditPart.this.isActive() && ContinuationNameEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            ContinuationNameEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && ContinuationNameEditPart.this.getEditText().equals(ContinuationNameEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            ContinuationNameEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            ContinuationNameEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void handleNotificationEvent(Notification event) {
        this.refreshLabel();
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        if (event.getNewValue() instanceof EAnnotation && "displayNameLabelIcon".equals(((EAnnotation)event.getNewValue()).getSource())) {
            this.refreshLabel();
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        return null;
    }

    public void activate() {
        super.activate();
        this.addOwnerElementListeners();
    }

    protected void addOwnerElementListeners() {
        this.addListenerFilter(ADD_PARENT_MODEL, (NotificationListener)this, (EObject)((View)this.getParent().getModel()));
    }

    public void deactivate() {
        this.removeOwnerElementListeners();
        super.deactivate();
    }

    protected void removeOwnerElementListeners() {
        this.removeListenerFilter(ADD_PARENT_MODEL);
    }
}

