/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.GateCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionFragmentsCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomInteractionItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomInteractionEditPart
extends InteractionEditPart {
    private NotificationHelper notifier = null;

    public CustomInteractionEditPart(View view) {
        super(view);
    }

    protected NotificationHelper getNotifier() {
        if (this.notifier == null) {
            try {
                Field f = InteractionEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifier = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifier = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        CustomInteractionEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifier;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomInteractionItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new InteractionGraphicalNodeEditPolicy());
        this.installEditPolicy("Gate Creation Edit Policy", (EditPolicy)new GateCreationEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new InteractionFragmentsCreationEditPolicy());
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new InteractionRectangleFigure(){

            public Dimension getMinimumSize(int wHint, int hHint) {
                Rectangle bounds = new Rectangle();
                for (Object child : CustomInteractionEditPart.this.getChildren()) {
                    if (!(child instanceof InteractionInteractionCompartmentEditPart)) continue;
                    InteractionInteractionCompartmentEditPart childEditPart = (InteractionInteractionCompartmentEditPart)((Object)child);
                    for (Object grandChild : childEditPart.getChildren()) {
                        GraphicalEditPart editPart = (GraphicalEditPart)grandChild;
                        IFigure figure = editPart.getFigure();
                        bounds.union(figure.getBounds());
                    }
                    IFigure figure = childEditPart.getFigure();
                    Rectangle rectangle = figure.getBounds();
                    IFigure parentfigure = CustomInteractionEditPart.this.getFigure();
                    Rectangle parentRectangle = parentfigure.getBounds();
                    bounds.width += parentRectangle.width - rectangle.width + 10;
                    bounds.height += parentRectangle.height - rectangle.height + 16;
                    break;
                }
                return bounds.getSize();
            }
        };
        return this.primaryShape;
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            InteractionRectangleFigure irf;
            this.primaryShape.setBackgroundColor(color);
            if (this.primaryShape instanceof InteractionRectangleFigure && (irf = (InteractionRectangleFigure)this.primaryShape).getCompartmentFigure() != null) {
                irf.getCompartmentFigure().setForegroundColor(color);
            }
        }
    }

    protected void refreshFont() {
        super.refreshFont();
        this.refreshBounds();
    }

    protected void handleNotificationEvent(Notification notification) {
        NotificationHelper notifier = this.getNotifier();
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getInteraction_FormalGate().equals(feature)) {
            notifier.unlistenObject((Notifier)notification.getOldValue());
            notifier.listenObject((Notifier)notification.getNewValue());
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof Gate) {
            String newPrefix;
            String oldPrefix;
            Gate gate = (Gate)notification.getNotifier();
            String oldStringValue = notification.getOldStringValue();
            String newStringValue = notification.getNewStringValue();
            if (oldStringValue != null && newStringValue != null && !(oldPrefix = oldStringValue.split("_")[0]).equals(newPrefix = newStringValue.split("_")[0]) && (oldPrefix.equals(MessageDirection.IN.getName()) || oldPrefix.equals(MessageDirection.OUT.getName()))) {
                notifier.unlistenObject((Notifier)gate);
                gate.setName(String.valueOf(oldPrefix) + "_" + gate.getName());
                notifier.listenObject((Notifier)gate);
            }
        }
        super.handleNotificationEvent(notification);
    }

    public void activate() {
        super.activate();
        NotificationHelper notifier = this.getNotifier();
        Interaction interaction = (Interaction)this.resolveSemanticElement();
        if (interaction != null) {
            for (Gate formalGate : interaction.getFormalGates()) {
                notifier.listenObject((Notifier)formalGate);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
    }

    public void removeNotify() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.removeNotify();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor sourceAnchor = this.createAnchor(request, UMLElementTypes.Message_4009, 4009, Message7EditPart.class);
        if (sourceAnchor == null) {
            sourceAnchor = super.getSourceConnectionAnchor(request);
        }
        return sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof Message7EditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, true)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor sourceConnectionAnchor = super.getSourceConnectionAnchor(connEditPart);
        return sourceConnectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ConnectionAnchor targetAnchor = this.createAnchor(request, UMLElementTypes.Message_4008, 4008, Message6EditPart.class);
        if (targetAnchor == null) {
            targetAnchor = this.createAnchor(request, UMLElementTypes.Message_4006, 4006, Message4EditPart.class);
        }
        if (targetAnchor == null) {
            targetAnchor = super.getTargetConnectionAnchor(request);
        }
        return targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if ((connEditPart instanceof Message6EditPart || connEditPart instanceof Message4EditPart) && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, false)).length() > 0) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor targetConnectionAnchor = super.getTargetConnectionAnchor(connEditPart);
        return targetConnectionAnchor;
    }

    private ConnectionAnchor createAnchor(Request request, IElementType elementType, int visualId, Class<?> messageType) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!elementType.equals(obj)) continue;
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = createRequest.getConnectionViewDescriptor();
            if (connectionViewDescriptor != null && String.valueOf(visualId).equals(connectionViewDescriptor.getSemanticHint())) {
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof ReconnectRequest && messageType.isInstance(connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) && request instanceof LocationRequest) {
            return this.createAnchor(((LocationRequest)request).getLocation().getCopy());
        }
        return null;
    }

    private ConnectionAnchor createAnchor(Point location) {
        return AnchorHelper.InnerPointAnchor.createAnchorAtLocation(this.getFigure(), new PrecisionPoint(location));
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof InteractionInteractionCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.remove(((InteractionInteractionCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof GateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((GateEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    @Override
    protected NodeFigure createNodeFigure() {
        return new BorderedNodeFigure((IFigure)super.createNodeFigure());
    }

    @Override
    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    public final BorderedNodeFigure getBorderedFigure() {
        return (BorderedNodeFigure)this.getFigure();
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof GateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().add(((GateEditPart)childEditPart).getFigure(), (Object)new GateLocator((GateEditPart)childEditPart, this.getFigure()));
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected NodeFigure createNodePlate() {
        String prefElementId = "Interaction";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight)){

            protected ConnectionAnchor createAnchor(PrecisionPoint p) {
                if (p == null) {
                    return this.createDefaultAnchor();
                }
                return new AnchorHelper.IntersectionPointAnchor((IFigure)this, p);
            }
        };
        return result;
    }
}

