/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.helper.NotificationHelper;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SelfMessageHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomMessageName2EditPart
extends MessageName2EditPart
implements MessageLabelEditPolicy.ICustomMessageLabel {
    private NotificationHelper notifier = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            CustomMessageName2EditPart.this.handleNotificationEvent(msg);
        }
    });
    private NotificationHelper firstDirectEditListener = null;

    public CustomMessageName2EditPart(View view) {
        super(view);
    }

    public void deactivate() {
        this.notifier.unlistenAll();
        super.deactivate();
    }

    public void activate() {
        super.activate();
        Message outerCFMessage = this.getOuterCFMessage();
        if (outerCFMessage != null) {
            this.notifier.listenObject((Notifier)outerCFMessage);
        }
    }

    private Message getOuterCFMessage() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof Message) {
            return GateHelper.getOuterCFMessage((Message)element);
        }
        return null;
    }

    public void refreshBounds() {
        super.refreshBounds();
        Message2EditPart parent = (Message2EditPart)this.getParent();
        if (SelfMessageHelper.isSelfLink(parent)) {
            SelfMessageHelper.updateLabelLocation((LabelEditPart)this);
        }
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getParent().getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    private View getFontStyleOwnerView() {
        return (View)this.getParent().getModel();
    }

    protected void performDirectEditRequest(Request request) {
        EObject element;
        Object data = request.getExtendedData().get("Direct Edit After Creation");
        if (data != null && "true".equals(data.toString()) && (element = this.resolveSemanticElement()) instanceof Message) {
            MessageEnd sendEvent = ((Message)element).getSendEvent();
            if (sendEvent instanceof Gate && GateHelper.isInnerCFGate((Gate)sendEvent)) {
                return;
            }
            MessageEnd receiveEvent = ((Message)element).getReceiveEvent();
            if (receiveEvent instanceof Gate && GateHelper.isInnerCFGate((Gate)receiveEvent)) {
                return;
            }
            final Message message = (Message)element;
            this.firstDirectEditListener = new NotificationHelper(new UIAdapterImpl(){

                protected void safeNotifyChanged(Notification msg) {
                    if (message == msg.getNotifier() && UMLPackage.eINSTANCE.getNamedElement_Name() == msg.getFeature()) {
                        CustomMessageName2EditPart.this.postFirstTimeDirectEdit(message);
                        CustomMessageName2EditPart.this.firstDirectEditListener.unlistenAll();
                        CustomMessageName2EditPart.this.firstDirectEditListener = null;
                    }
                }
            });
            this.firstDirectEditListener.listenObject((Notifier)message);
        }
        super.performDirectEditRequest(request);
    }

    protected void postFirstTimeDirectEdit(Message message) {
        GateHelper.updateGateWithMessage(message, true);
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }
}

