/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractBorderEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.NotificationHelper;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.GateGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.GateItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateModelElementFactory;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.UMLPackage;

public class GateEditPart
extends AbstractBorderEditPart
implements IBorderItemEditPart {
    public static final String GATE_TYPE = "Gate";
    public static final Dimension DEFAULT_SIZE = new Dimension(16, 16);
    protected GateFigure primaryShape;
    private NotificationHelper notifier = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            GateEditPart.this.handleNotificationEvent(msg);
        }
    });

    public GateEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.hookExternalGates();
    }

    protected void hookExternalGates() {
        Gate actualGate;
        EObject resolveSemanticElement = this.resolveSemanticElement();
        if (!(resolveSemanticElement instanceof Gate)) {
            return;
        }
        Gate gate = (Gate)resolveSemanticElement;
        if (gate.eContainer() instanceof CombinedFragment) {
            if (!GateHelper.isInnerCFGate(gate)) {
                Message message = gate.getMessage();
                if (message != null) {
                    this.notifier.listenObject((Notifier)message);
                }
            } else {
                Gate outerGate = GateHelper.getOuterCFGate(gate);
                if (outerGate != null) {
                    this.notifier.listenObject((Notifier)outerGate);
                    Message message = outerGate.getMessage();
                    if (message != null) {
                        this.notifier.listenObject((Notifier)message);
                    }
                }
            }
        } else if (gate.eContainer() instanceof Interaction && (actualGate = GateHelper.getActualGate(gate)) != null) {
            this.notifier.listenObject((Notifier)actualGate);
            Message message = actualGate.getMessage();
            if (message != null) {
                this.notifier.listenObject((Notifier)message);
            }
        }
    }

    public void deactivate() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.deactivate();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new GateItemSemanticEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", this.getPrimaryDragEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GateGraphicalNodeEditPolicy());
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new BorderItemSelectionEditPolicy(){

            protected Command getMoveCommand(ChangeBoundsRequest request) {
                IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
                IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
                if (borderItemLocator != null) {
                    PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    rect.translate(request.getMoveDelta());
                    rect.resize(request.getSizeDelta());
                    this.getHostFigure().translateToRelative((Translatable)rect);
                    Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                    Point location = realLocation.getLocation();
                    SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
                    return new ICommandProxy((ICommand)moveCommand);
                }
                return null;
            }
        };
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof GateNameEditPart) {
                    return new BorderItemSelectionEditPolicy(){

                        protected List createSelectionHandles() {
                            MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                            mh.setBorder(null);
                            return Collections.singletonList(mh);
                        }
                    };
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected NodeFigure createMainFigure() {
        this.primaryShape = new GateFigure();
        return this.primaryShape;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof GateNameEditPart) {
            ExternalLabelPositionLocator locator = new ExternalLabelPositionLocator(this.getMainFigure());
            this.getContentPaneFor((IGraphicalEditPart)((GateNameEditPart)childEditPart)).add(((GateNameEditPart)childEditPart).getFigure(), (Object)locator);
            return;
        }
        super.addChildVisual(childEditPart, index);
    }

    public IPapyrusNodeFigure getPrimaryShape() {
        return this.primaryShape;
    }

    protected void removeChildVisual(EditPart child) {
        if (child instanceof GateNameEditPart) {
            this.getContentPaneFor((IGraphicalEditPart)((GateNameEditPart)child)).remove(((GateNameEditPart)child).getFigure());
            return;
        }
        super.removeChildVisual(child);
    }

    protected void refreshBounds() {
        if (this.getBorderItemLocator() != null) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point loc = new Point(x, y);
            this.getBorderItemLocator().setConstraint(new Rectangle(loc, DEFAULT_SIZE));
            GateNameEditPart labelEditPart = this.getLabelEditPart();
            if (labelEditPart != null) {
                labelEditPart.refreshBounds();
            }
        }
    }

    protected void handleNotificationEvent(Notification event) {
        if (GateModelElementFactory.isShowNameChanged(event)) {
            this.refreshChildren();
            return;
        }
        if (!event.isTouch()) {
            this.hookExternalGates();
        }
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(event.getFeature())) {
            EObject element = this.resolveSemanticElement();
            if (!(element instanceof Gate) || !(event.getNotifier() instanceof Message)) {
                this.refreshGateLabel();
            }
        } else if (UMLPackage.eINSTANCE.getMessageEnd_Message().equals(event.getFeature())) {
            this.notifier.unlistenObject((Notifier)event.getOldValue());
            this.notifier.listenObject((Notifier)event.getNewValue());
            this.refreshGateLabel();
        }
        super.handleNotificationEvent(event);
    }

    protected List getModelChildren() {
        if (GateModelElementFactory.isShowName(this.getPrimaryView())) {
            return super.getModelChildren();
        }
        ArrayList modelChildren = new ArrayList(super.getModelChildren());
        Iterator iterator = modelChildren.iterator();
        while (iterator.hasNext()) {
            View next = (View)iterator.next();
            if (!"Gate_Name".equals(next.getType())) continue;
            iterator.remove();
            break;
        }
        return modelChildren;
    }

    protected void refreshGateLabel() {
        GateNameEditPart labelEditPart = this.getLabelEditPart();
        if (labelEditPart != null) {
            labelEditPart.refreshLabel();
        }
    }

    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
        GateNameEditPart labelEditPart = this.getLabelEditPart();
        if (labelEditPart != null) {
            labelEditPart.refreshBounds();
        }
    }

    protected void refreshTargetConnections() {
        super.refreshTargetConnections();
        GateNameEditPart labelEditPart = this.getLabelEditPart();
        if (labelEditPart != null) {
            labelEditPart.refreshBounds();
        }
    }

    public GateNameEditPart getLabelEditPart() {
        IGraphicalEditPart labelEditPart = this.getChildBySemanticHint("Gate_Name");
        if (labelEditPart instanceof GateNameEditPart) {
            return (GateNameEditPart)labelEditPart;
        }
        return null;
    }

    public class GateFigure
    extends NodeNamedElementFigure {
        public GateFigure() {
            this.setBorder((Border)new LineBorder(ColorConstants.black));
            this.setPreferredSize(DEFAULT_SIZE);
        }

        protected ConnectionAnchor createDefaultAnchor() {
            return new SlidableAnchor((IFigure)this){

                public Point getLocation(Point reference) {
                    Point location = this.getLocation((Point)new PrecisionPoint(this.getBox().getCenter()), reference);
                    if (location == null) {
                        location = this.getBox().getCenter();
                    }
                    return location;
                }
            };
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            return new SlidableAnchor((IFigure)this, p){

                public Point getLocation(Point reference) {
                    Rectangle box = this.getBox();
                    Point location = this.getLocation((Point)new PrecisionPoint(box.getCenter()), reference);
                    if (location == null) {
                        location = this.getBox().getCenter();
                    }
                    return location;
                }
            };
        }
    }
}

