/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGateElementAndViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;

public class GateCreationEditPolicy
extends LayoutEditPolicy {
    private static final String GATE_LOCATION_DATA = "Gate location data";
    private IFigure gateFeedback;

    public EditPart getTargetEditPart(Request request) {
        if (this.isGateCreation(request)) {
            if (this.getHost() instanceof InteractionEditPart && !this.touchesInteractionBounds((GraphicalEditPart)this.getHost(), ((CreateRequest)request).getLocation())) {
                return null;
            }
            return this.getHost();
        }
        return null;
    }

    private boolean touchesInteractionBounds(GraphicalEditPart interaction, Point location) {
        Point p = location.getCopy();
        IFigure figure = interaction.getFigure();
        figure.translateToRelative((Translatable)p);
        Rectangle r = figure.getBounds().getCopy();
        Rectangle innerRetangle = r.getShrinked(20, 20);
        if (innerRetangle.contains(p)) {
            return false;
        }
        return r.getExpanded(1, 1).contains(p);
    }

    public void showTargetFeedback(Request request) {
        if (this.isGateCreation(request)) {
            this.showCreateGateFeedback((CreateRequest)request);
        }
        super.showTargetFeedback(request);
    }

    private void showCreateGateFeedback(CreateRequest request) {
        if (this.gateFeedback == null) {
            this.gateFeedback = new RectangleFigure();
            ((RectangleFigure)this.gateFeedback).setLineWidth(2);
            this.gateFeedback.setSize(GateEditPart.DEFAULT_SIZE);
            this.getFeedbackLayer().add(this.gateFeedback);
        }
        GateLocator locator = new GateLocator(this.getHostFigure());
        Rectangle proposedLocation = new Rectangle();
        proposedLocation.setLocation(request.getLocation());
        proposedLocation.setSize(GateEditPart.DEFAULT_SIZE);
        this.getHostFigure().translateToRelative((Translatable)proposedLocation);
        Rectangle rect = locator.getValidLocation(proposedLocation, this.gateFeedback);
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        this.gateFeedback.translateToRelative((Translatable)rect);
        this.gateFeedback.setBounds(rect);
        Point location = rect.getLocation().getCopy();
        this.gateFeedback.translateToAbsolute((Translatable)location);
        this.getHostFigure().translateToRelative((Translatable)location);
        request.getExtendedData().put(GATE_LOCATION_DATA, location);
    }

    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        if (this.gateFeedback != null && this.gateFeedback.getParent() != null) {
            this.gateFeedback.getParent().remove(this.gateFeedback);
            this.gateFeedback = null;
        }
    }

    private boolean isGateCreation(Request request) {
        if (!(request instanceof CreateRequest)) {
            return false;
        }
        CreateRequest createReq = (CreateRequest)request;
        try {
            Object newObjectType = createReq.getNewObjectType();
            return "Gate".equals(newObjectType);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return child.getEditPolicy((Object)"PrimaryDrag Policy");
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (this.isGateCreation((Request)request)) {
            EditPart targetEditPart = this.getTargetEditPart((Request)request);
            if (targetEditPart == null) {
                return UnexecutableCommand.INSTANCE;
            }
            if (targetEditPart instanceof InteractionEditPart && !this.touchesInteractionBounds((GraphicalEditPart)((InteractionEditPart)targetEditPart), request.getLocation())) {
                return UnexecutableCommand.INSTANCE;
            }
            Point location = (Point)request.getExtendedData().get(GATE_LOCATION_DATA);
            if (location == null) {
                location = GateHelper.computeGateLocation(request.getLocation(), this.getHostFigure(), null);
            }
            return this.getCreateGateCommand(location);
        }
        return null;
    }

    protected Command getCreateGateCommand(Point location) {
        return new ICommandProxy((ICommand)new CreateGateElementAndViewCommand(this.getEditingDomain(), (IAdaptable)this.getHost(), location));
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }

    public boolean understandsRequest(Request req) {
        if (this.isGateCreation(req)) {
            EditPart targetEditPart = this.getTargetEditPart(req);
            return targetEditPart != null;
        }
        return false;
    }
}

