/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineLabelHelper;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    private IPropertyChangeListener preferenceListener;

    public void addAdditionalListeners() {
        Lifeline lifeline;
        super.addAdditionalListeners();
        if (this.preferenceListener == null) {
            this.preferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    LifelineLabelEditPolicy.this.handlePreferenceChange(event);
                }
            };
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            store.addPropertyChangeListener(this.preferenceListener);
        }
        if ((lifeline = this.getUMLElement()) == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)lifeline, (NotificationListener)this);
        ConnectableElement ce = lifeline.getRepresents();
        if (ce != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)ce, (NotificationListener)this);
            if (ce.getType() != null) {
                this.getDiagramEventBroker().addNotificationListener((EObject)ce.getType(), (NotificationListener)this);
            }
        }
    }

    protected void handlePreferenceChange(PropertyChangeEvent event) {
        EditPart part = this.getHost();
        if (part == null || part.getParent() == null) {
            return;
        }
        String key = event.getProperty();
        if (key.equals("PapyrusUMLSequenceDiagram_Lifeline.label.display")) {
            this.refreshDisplay();
        }
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Lifeline lifeline = this.getUMLElement();
        if (lifeline == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)lifeline, (NotificationListener)this);
        ConnectableElement ce = lifeline.getRepresents();
        if (ce != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)ce, (NotificationListener)this);
            if (ce.getType() != null) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)ce.getType(), (NotificationListener)this);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        if (object == null || this.getUMLElement() == null) {
            return;
        }
        if (notification.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
            this.refreshDisplay();
        } else if (notification.getFeature().equals(UMLPackage.Literals.LIFELINE__REPRESENTS)) {
            ConnectableElement ce;
            if (notification.getNewValue() instanceof ConnectableElement) {
                ce = (ConnectableElement)notification.getNewValue();
                this.getDiagramEventBroker().addNotificationListener((EObject)ce, (NotificationListener)this);
                if (ce.getType() != null) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)ce.getType(), (NotificationListener)this);
                }
            }
            if (notification.getOldValue() instanceof ConnectableElement) {
                ce = (ConnectableElement)notification.getOldValue();
                this.getDiagramEventBroker().removeNotificationListener((EObject)ce, (NotificationListener)this);
                if (ce.getType() != null) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)ce.getType(), (NotificationListener)this);
                }
            }
            this.refreshDisplay();
        } else if (this.isMaskManagedAnnotation(object) || this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        } else if (object.equals(this.getUMLElement().getRepresents())) {
            if (notification.getNewValue() instanceof Type && notification.getNewValue() instanceof EObject) {
                this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
            }
            if (notification.getOldValue() instanceof Type && notification.getOldValue() instanceof EObject) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            }
            this.refreshDisplay();
        }
    }

    public void refreshDisplay() {
        LifelineEditPart lp = (LifelineEditPart)this.getHost();
        List children = lp.getChildren();
        for (Object p : children) {
            if (!(p instanceof LifelineNameEditPart)) continue;
            LifelineLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)p);
        }
    }

    public int getCurrentDisplayValue() {
        EAnnotation customeDisplayAnnotation = ((View)this.getHost().getModel()).getEAnnotation("CustomAppearance_Annotation");
        int displayValue = this.getDefaultDisplayValue();
        if (customeDisplayAnnotation != null && customeDisplayAnnotation.getDetails().get((Object)"CustomAppearance_MaskValue") != null) {
            displayValue = Integer.parseInt((String)customeDisplayAnnotation.getDetails().get((Object)"CustomAppearance_MaskValue"));
        } else {
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            int displayValueTemp = store.getInt("PapyrusUMLSequenceDiagram_Lifeline.label.display");
            if (displayValueTemp != 0) {
                displayValue = displayValueTemp;
            }
        }
        return displayValue;
    }

    public int getDefaultDisplayValue() {
        return 6;
    }

    public String getMaskLabel(int value) {
        return LifelineLabelHelper.getInstance().getMaskLabel(value);
    }

    public Collection<String> getMaskLabels() {
        return LifelineLabelHelper.getInstance().getMaskLabels();
    }

    public Map<Integer, String> getMasks() {
        return LifelineLabelHelper.getInstance().getMasks();
    }

    public Collection<Integer> getMaskValues() {
        return LifelineLabelHelper.getInstance().getMaskValues();
    }

    public String getPreferencePageID() {
        return "org.eclipse.papyrus.uml.diagram.sequence.preferences.LifelinePreferencePage";
    }

    public Lifeline getUMLElement() {
        return (Lifeline)this.hostSemanticElement;
    }
}

