/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "PapyrusUMLSequenceDiagram";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "PapyrusUMLSequenceDiagram".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                IElementType closestNonExtendedType;
                if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 2001: 
                    case 3001: 
                    case 3002: 
                    case 3003: 
                    case 3004: 
                    case 3005: 
                    case 3006: 
                    case 3007: 
                    case 3008: 
                    case 3009: 
                    case 3016: 
                    case 3017: 
                    case 3018: 
                    case 3019: 
                    case 3020: 
                    case 3021: 
                    case 3022: 
                    case 3023: 
                    case 3024: {
                        if (domainElement != null && visualID == UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2001 == visualID || 3007 == visualID || 3004 == visualID || 3005 == visualID || 3002 == visualID || 3016 == visualID || 3001 == visualID || 3006 == visualID || 3003 == visualID || 3017 == visualID || 3018 == visualID || 3019 == visualID || 3020 == visualID || 3021 == visualID || 3022 == visualID || 3008 == visualID || 3009 == visualID || 3023 == visualID || 3024 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType closestNonExtendedType;
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("PapyrusUMLSequenceDiagram");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2001: {
                return this.createInteraction_2001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3007: {
                return this.createConsiderIgnoreFragment_3007(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3004: {
                return this.createCombinedFragment_3004(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3005: {
                return this.createInteractionOperand_3005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3002: {
                return this.createInteractionUse_3002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3016: {
                return this.createContinuation_3016(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3001: {
                return this.createLifeline_3001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3006: {
                return this.createActionExecutionSpecification_3006(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3003: {
                return this.createBehaviorExecutionSpecification_3003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3017: {
                return this.createStateInvariant_3017(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3018: {
                return this.createCombinedFragment_3018(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3019: {
                return this.createTimeConstraint_3019(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3020: {
                return this.createTimeObservation_3020(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3021: {
                return this.createDurationConstraint_3021(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3022: {
                return this.createDestructionOccurrenceSpecification_3022(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3008: {
                return this.createConstraint_3008(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3009: {
                return this.createComment_3009(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3023: {
                return this.createDurationConstraint_3023(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3024: {
                return this.createDurationObservation_3024(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (UMLVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 4003: {
                return this.createMessage_4003(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4004: {
                return this.createMessage_4004(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4005: {
                return this.createMessage_4005(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4006: {
                return this.createMessage_4006(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4007: {
                return this.createMessage_4007(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4008: {
                return this.createMessage_4008(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4009: {
                return this.createMessage_4009(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4010: {
                return this.createCommentAnnotatedElement_4010(containerView, index, persisted, preferencesHint);
            }
            case 4011: {
                return this.createConstraintConstrainedElement_4011(containerView, index, persisted, preferencesHint);
            }
            case 4012: {
                return this.createGeneralOrdering_4012(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createInteraction_2001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        Node label5001 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5001));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7001), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        return node;
    }

    public Node createLifeline_3001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        Node label5002 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5002));
        return node;
    }

    public Node createBehaviorExecutionSpecification_3003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"BehaviorExecutionSpecification");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"BehaviorExecutionSpecification");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"BehaviorExecutionSpecification");
        return node;
    }

    public Node createStateInvariant_3017(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3017));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateInvariant");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateInvariant");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateInvariant");
        Node label5008 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5008));
        return node;
    }

    public Node createCombinedFragment_3018(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3018));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        return node;
    }

    public Node createTimeConstraint_3019(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3019));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        Node label5009 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5009));
        label5009.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5009 = (Location)label5009.getLayoutConstraint();
        location5009.setX(22);
        location5009.setY(-7);
        Node label5013 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5013));
        label5013.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5013 = (Location)label5013.getLayoutConstraint();
        location5013.setX(0);
        location5013.setY(-22);
        return node;
    }

    public Node createTimeObservation_3020(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3020));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        Node label5010 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5010));
        label5010.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5010 = (Location)label5010.getLayoutConstraint();
        location5010.setX(22);
        location5010.setY(-7);
        Node label5014 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5014));
        label5014.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5014 = (Location)label5014.getLayoutConstraint();
        location5014.setX(0);
        location5014.setY(-22);
        return node;
    }

    public Node createDurationConstraint_3021(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3021));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node label5011 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5011));
        label5011.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5011 = (Location)label5011.getLayoutConstraint();
        location5011.setX(25);
        location5011.setY(45);
        Node label5015 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5015));
        label5015.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5015 = (Location)label5015.getLayoutConstraint();
        location5015.setX(0);
        location5015.setY(-22);
        return node;
    }

    public Node createDestructionOccurrenceSpecification_3022(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3022));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        return node;
    }

    public Node createActionExecutionSpecification_3006(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3006));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ActionExecutionSpecification");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ActionExecutionSpecification");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ActionExecutionSpecification");
        return node;
    }

    public Node createInteractionUse_3002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createHintedDiagramLinkStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionUse");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionUse");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionUse");
        Node label5003 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5003));
        Node label5004 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5004));
        return node;
    }

    public Node createCombinedFragment_3004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3004));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7004), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        return node;
    }

    public Node createInteractionOperand_3005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionOperand");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionOperand");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionOperand");
        return node;
    }

    public Node createContinuation_3016(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3016));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Continuation");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Continuation");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Continuation");
        Node label5007 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5007));
        return node;
    }

    public Node createConstraint_3008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3008));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        Node label5005 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5005));
        Node label5012 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5012));
        return node;
    }

    public Node createComment_3009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3009));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        Node label5006 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5006));
        return node;
    }

    public Node createDurationConstraint_3023(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFillStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3023));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node label5018 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5018));
        Node label5019 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5019));
        label5019.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5019 = (Location)label5019.getLayoutConstraint();
        location5019.setX(0);
        location5019.setY(-22);
        return node;
    }

    public Node createDurationObservation_3024(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFillStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3024));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationObservation");
        Node label5016 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5016));
        Node label5017 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5017));
        label5017.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5017 = (Location)label5017.getLayoutConstraint();
        location5017.setX(0);
        location5017.setY(-22);
        return node;
    }

    public Node createConsiderIgnoreFragment_3007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3007));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConsiderIgnoreFragment");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConsiderIgnoreFragment");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConsiderIgnoreFragment");
        return node;
    }

    public Edge createMessage_4003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4003));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6001 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6001));
        label6001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6001 = (Location)label6001.getLayoutConstraint();
        location6001.setX(1);
        location6001.setY(-13);
        Node label6008 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6008));
        label6008.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6008 = (Location)label6008.getLayoutConstraint();
        location6008.setX(1);
        location6008.setY(-33);
        return edge;
    }

    public Edge createMessage_4004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4004));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6002 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6002));
        label6002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6002 = (Location)label6002.getLayoutConstraint();
        location6002.setX(1);
        location6002.setY(-13);
        Node label6009 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6009));
        label6009.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6009 = (Location)label6009.getLayoutConstraint();
        location6009.setX(1);
        location6009.setY(-33);
        return edge;
    }

    public Edge createMessage_4005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4005));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6003 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6003));
        label6003.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6003 = (Location)label6003.getLayoutConstraint();
        location6003.setX(1);
        location6003.setY(-13);
        Node label6010 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6010));
        label6010.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6010 = (Location)label6010.getLayoutConstraint();
        location6010.setX(1);
        location6010.setY(-33);
        return edge;
    }

    public Edge createMessage_4006(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4006));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6004 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6004));
        label6004.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6004 = (Location)label6004.getLayoutConstraint();
        location6004.setX(1);
        location6004.setY(-13);
        Node label6011 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6011));
        label6011.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6011 = (Location)label6011.getLayoutConstraint();
        location6011.setX(1);
        location6011.setY(-33);
        return edge;
    }

    public Edge createMessage_4007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4007));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6005 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6005));
        label6005.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6005 = (Location)label6005.getLayoutConstraint();
        location6005.setX(1);
        location6005.setY(-13);
        Node label6012 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6012));
        label6012.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6012 = (Location)label6012.getLayoutConstraint();
        location6012.setX(1);
        location6012.setY(-33);
        return edge;
    }

    public Edge createMessage_4008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4008));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6006 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6006));
        label6006.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6006 = (Location)label6006.getLayoutConstraint();
        location6006.setX(1);
        location6006.setY(-13);
        Node label6013 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6013));
        label6013.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6013 = (Location)label6013.getLayoutConstraint();
        location6013.setX(1);
        location6013.setY(-33);
        return edge;
    }

    public Edge createMessage_4009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4009));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node label6007 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6007));
        label6007.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6007 = (Location)label6007.getLayoutConstraint();
        location6007.setX(1);
        location6007.setY(-13);
        Node label6014 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6014));
        label6014.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6014 = (Location)label6014.getLayoutConstraint();
        location6014.setX(1);
        location6014.setY(-33);
        return edge;
    }

    public Edge createCommentAnnotatedElement_4010(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4010));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        return edge;
    }

    public Edge createConstraintConstrainedElement_4011(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4011));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        return edge;
    }

    public Edge createGeneralOrdering_4012(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createRoutingStyle());
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4012));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        Node label6015 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6015));
        label6015.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6015 = (Location)label6015.getLayoutConstraint();
        location6015.setX(1);
        location6015.setY(-33);
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLSequenceDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            ts.setShowTitle(true);
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fontConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)1);
        String fontColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    private void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String lineColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    private void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fillColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)0);
        String gradientColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)4);
        String gradientPolicyConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)5);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
    }
}

