/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class LifelineCoveredByUpdater {
    protected GraphicalEditPart context;
    protected Map<LifelineEditPart, Rectangle> lifelines = new HashMap<LifelineEditPart, Rectangle>();
    protected HashMap<InteractionFragmentEditPart, Rectangle> interactionFragments = new HashMap();
    protected List<InteractionFragment> coveredByLifelinesToAdd = new ArrayList<InteractionFragment>();
    protected List<InteractionFragment> coveredByLifelinesToRemove = new ArrayList<InteractionFragment>();
    protected TransactionalEditingDomain editingDomain;

    protected void init() {
        EditPart editPart;
        this.editingDomain = this.context.getEditingDomain();
        GraphicalEditPart parent = this.context;
        while ((editPart = parent.getParent()) instanceof GraphicalEditPart) {
            parent = (GraphicalEditPart)editPart;
        }
        this.childrenCollect(parent);
    }

    private void childrenCollect(GraphicalEditPart editPart) {
        Rectangle childBounds;
        IFigure figure;
        if (editPart instanceof LifelineEditPart) {
            figure = editPart.getFigure();
            childBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)childBounds);
            Rectangle centralLineBounds = new Rectangle(childBounds.x() + childBounds.width() / 2, childBounds.y(), 1, childBounds.height());
            this.lifelines.put((LifelineEditPart)editPart, centralLineBounds);
        }
        if (editPart instanceof InteractionFragmentEditPart) {
            figure = editPart.getFigure();
            childBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)childBounds);
            this.interactionFragments.put((InteractionFragmentEditPart)editPart, childBounds);
        }
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            this.childrenCollect((GraphicalEditPart)child);
        }
    }

    public void update(GraphicalEditPart context) {
        this.context = context;
        this.init();
        for (Map.Entry<LifelineEditPart, Rectangle> entry : this.lifelines.entrySet()) {
            LifelineEditPart editPart = entry.getKey();
            Rectangle childBounds = entry.getValue();
            this.updateLifeline(editPart, childBounds);
        }
    }

    public void updateLifeline(LifelineEditPart lifelineEditpart, Rectangle rect) {
        Lifeline lifeline = (Lifeline)lifelineEditpart.resolveSemanticElement();
        if (lifeline == null) {
            return;
        }
        EList coveredByLifelines = lifeline.getCoveredBys();
        this.coveredByLifelinesToAdd.clear();
        this.coveredByLifelinesToRemove.clear();
        int bottom = 0;
        for (Map.Entry<InteractionFragmentEditPart, Rectangle> entry : this.interactionFragments.entrySet()) {
            InteractionFragmentEditPart editPart = entry.getKey();
            Rectangle childBounds = entry.getValue();
            InteractionFragment interactionFragment = (InteractionFragment)editPart.resolveSemanticElement();
            if (rect.intersects(childBounds)) {
                if (coveredByLifelines.contains((Object)interactionFragment)) continue;
                this.coveredByLifelinesToAdd.add(interactionFragment);
                bottom = Math.max(childBounds.bottom(), bottom);
                continue;
            }
            if (!coveredByLifelines.contains((Object)interactionFragment)) continue;
            this.coveredByLifelinesToRemove.add(interactionFragment);
        }
        if (!this.coveredByLifelinesToAdd.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.editingDomain, AddCommand.create((EditingDomain)this.editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), this.coveredByLifelinesToAdd), true);
            int newHeight = bottom - rect.y;
            if (newHeight > rect.height) {
                Bounds bounds = (Bounds)((Shape)lifelineEditpart.getModel()).getLayoutConstraint();
                CommandHelper.executeCommandWithoutHistory((EditingDomain)this.editingDomain, SetCommand.create((EditingDomain)this.editingDomain, (Object)bounds, (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)newHeight), true);
            }
        }
        if (!this.coveredByLifelinesToRemove.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.editingDomain, RemoveCommand.create((EditingDomain)this.editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), this.coveredByLifelinesToRemove), true);
        }
    }
}

