/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ReconnectMessageHelper {
    public static void updateMessage(Message message) {
    }

    public static void updateMessageEnd(MessageEnd messageEnd, Element oldElement, Element newElement) {
        if (messageEnd instanceof MessageOccurrenceSpecification) {
            ReconnectMessageHelper.updateMos((MessageOccurrenceSpecification)messageEnd, oldElement, newElement);
        } else if (messageEnd instanceof Gate) {
            ReconnectMessageHelper.updateGate((Gate)messageEnd, oldElement, newElement);
        }
        if (oldElement instanceof ExecutionSpecification && oldElement != newElement) {
            ExecutionSpecification execution = (ExecutionSpecification)oldElement;
            if (messageEnd == execution.getStart()) {
                OccurrenceSpecificationHelper.resetExecutionStart(execution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            } else if (messageEnd == execution.getFinish()) {
                OccurrenceSpecificationHelper.resetExecutionFinish(execution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            }
        }
    }

    public static void updateGate(Gate messageEnd, Element oldElement, Element newElement) {
        if (newElement instanceof Gate && messageEnd != newElement) {
            Gate newEnd = (Gate)newElement;
            Message message = messageEnd.getMessage();
            if (message != null) {
                if (messageEnd == message.getSendEvent()) {
                    message.setSendEvent((MessageEnd)newEnd);
                } else if (messageEnd == message.getReceiveEvent()) {
                    message.setReceiveEvent((MessageEnd)newEnd);
                }
                newEnd.setMessage(message);
                messageEnd.setMessage(null);
            }
        }
    }

    public static void updateMos(MessageOccurrenceSpecification messageEnd, Element oldElement, Element newElement) {
        if (!(!(newElement instanceof Lifeline) || oldElement instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)oldElement).getInteractionOperator()))) {
            ReconnectMessageHelper.updateOccurenceSpecification((OccurrenceSpecification)messageEnd, (Lifeline)newElement);
        } else if (!(!(newElement instanceof ExecutionSpecification) || oldElement instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)oldElement).getInteractionOperator()))) {
            Lifeline lifeline = CommandHelper.getExecutionSpecificationLifeline((ExecutionSpecification)newElement);
            if (lifeline != null) {
                ReconnectMessageHelper.updateOccurenceSpecification((OccurrenceSpecification)messageEnd, lifeline);
            }
        } else if (newElement instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)newElement).getInteractionOperator())) {
            CombinedFragment cf = (CombinedFragment)newElement;
            InteractionOperand io = CommandHelper.getCoRegionInteractionOperand(cf);
            messageEnd.setEnclosingOperand(io);
            MessageEnd messageEnd2 = ReconnectMessageHelper.findSecondMessageEnd((MessageEnd)messageEnd);
            if (messageEnd2 instanceof MessageOccurrenceSpecification) {
                ((MessageOccurrenceSpecification)messageEnd2).setEnclosingOperand(io);
            }
            ReconnectMessageHelper.updateCoveredLifelinesOfCoregionOperand(cf);
        } else if (oldElement instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)oldElement).getInteractionOperator())) {
            CombinedFragment cf = (CombinedFragment)oldElement;
            Element backInteraction = cf.getOwner();
            SequenceUtil.setEnclosingInteraction((InteractionFragment)messageEnd, (EObject)backInteraction, true);
            MessageEnd messageEnd2 = ReconnectMessageHelper.findSecondMessageEnd((MessageEnd)messageEnd);
            if (messageEnd2 instanceof MessageOccurrenceSpecification) {
                SequenceUtil.setEnclosingInteraction((InteractionFragment)((MessageOccurrenceSpecification)messageEnd2), (EObject)backInteraction, true);
            }
            ReconnectMessageHelper.updateCoveredLifelinesOfCoregionOperand(cf);
        }
    }

    public static MessageEnd findSecondMessageEnd(MessageEnd messageEnd) {
        Message msg = messageEnd.getMessage();
        MessageEnd messageEnd2 = null;
        if (msg != null) {
            messageEnd2 = messageEnd.equals(msg.getSendEvent()) ? msg.getReceiveEvent() : msg.getSendEvent();
        }
        return messageEnd2;
    }

    public static void updateOccurenceSpecification(OccurrenceSpecification os, Lifeline newLifeline) {
        EList covereds = os.getCovereds();
        if (covereds.isEmpty()) {
            covereds.add((Object)newLifeline);
        } else if (covereds.size() == 1) {
            if (newLifeline != covereds.get(0)) {
                os.setCovered(newLifeline);
            }
        } else {
            covereds.clear();
            covereds.add((Object)newLifeline);
        }
    }

    public static void updateCoveredLifelinesOfCoregionOperand(CombinedFragment coregion) {
        coregion.getCovereds().clear();
        for (InteractionOperand operand : coregion.getOperands()) {
            operand.getCovereds().clear();
            for (InteractionFragment fragment : operand.getFragments()) {
                if (!(fragment instanceof MessageOccurrenceSpecification)) continue;
                operand.getCovereds().addAll((Collection)fragment.getCovereds());
                coregion.getCovereds().addAll((Collection)fragment.getCovereds());
            }
        }
    }
}

