/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.DiagramsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui.AdvancedHLManager;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorNavigationDialog;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;

public class NavigationEditPolicy
extends OpenEditPolicy {
    public static final String NAVIGATION_POLICY = "NavigationEditPolicy";

    protected Command getOpenCommand(Request request) {
        final IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost() instanceof CompartmentEditPart ? (IGraphicalEditPart)this.getHost().getParent() : (IGraphicalEditPart)this.getHost();
        EObject semanticElement = gep.resolveSemanticElement();
        List navElements = null;
        ArrayList<Object> defaultHyperLinkObject = new ArrayList<Object>();
        HashMap<NavigableElement, List> existingDiagrams = new HashMap<NavigableElement, List>();
        if (semanticElement == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        final HyperLinkHelperFactory hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
        try {
            final ArrayList hyperLinkObjectList = hyperlinkHelperFactory.getAllreferenced((EModelElement)gep.getNotationView());
            for (HyperLinkObject hyperlinkObject : hyperLinkObjectList) {
                if (!hyperlinkObject.getIsDefault()) continue;
                defaultHyperLinkObject.add(hyperlinkObject);
            }
            navElements = NavigationHelper.getInstance().getAllNavigableElements(semanticElement);
            HashMap possibleCreations = new HashMap();
            String navigationKind = Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DOUBLECLICK_KIND");
            if (navigationKind.equals("NO_NAVIGATION")) {
                return UnexecutableCommand.INSTANCE;
            }
            if (navigationKind.equals("EXPLICIT_IMPLICIT_NAVIGATION")) {
                for (NavigableElement navElement : navElements) {
                    EObject element = navElement.getElement();
                    if (!(navElement instanceof ExistingNavigableElement)) continue;
                    List associatedDiagrams = DiagramsUtil.getAssociatedDiagrams((EObject)element, null);
                    associatedDiagrams.remove(gep.getNotationView().getDiagram());
                    if (associatedDiagrams == null || associatedDiagrams.isEmpty()) continue;
                    existingDiagrams.put(navElement, associatedDiagrams);
                }
                for (List list : existingDiagrams.values()) {
                    for (Diagram diagram : list) {
                        HyperLinkEditor hyperLinkEditor = new HyperLinkEditor();
                        hyperLinkEditor.setObject((Object)diagram);
                        hyperLinkEditor.setTooltipText(String.valueOf(diagram.getName()) + " (found by heuristic)");
                        HyperLinkObject foundHyperlink = null;
                        int i = 0;
                        while (i < defaultHyperLinkObject.size() && foundHyperlink == null) {
                            if (((HyperLinkObject)defaultHyperLinkObject.get(i)).getObject().equals(diagram)) {
                                foundHyperlink = (HyperLinkObject)defaultHyperLinkObject.get(i);
                            }
                            ++i;
                        }
                        if (foundHyperlink != null) continue;
                        defaultHyperLinkObject.add(hyperLinkEditor);
                    }
                }
            }
            if (defaultHyperLinkObject.isEmpty()) {
                Command command = new Command(){

                    public void execute() {
                        EObject semanticElement = gep.getNotationView().getElement();
                        if (semanticElement instanceof EModelElement) {
                            AdvancedHLManager hyperLinkManagerShell = new AdvancedHLManager(NavigationEditPolicy.this.createEditorRegistry(), ((IGraphicalEditPart)NavigationEditPolicy.this.getHost()).getEditingDomain(), (EModelElement)semanticElement, gep.getNotationView(), hyperlinkHelperFactory);
                            hyperLinkManagerShell.setInput(hyperLinkObjectList);
                            hyperLinkManagerShell.open();
                        }
                    }
                };
                return command;
            }
            if (defaultHyperLinkObject.size() == 1) {
                final HyperLinkObject hyperlinkObject = (HyperLinkObject)defaultHyperLinkObject.get(0);
                Command command = new Command("Navigate hyperlink"){
                    private ICommand openLinkCommand;

                    public void execute() {
                        if (hyperlinkObject.needsOpenCommand()) {
                            try {
                                TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)NavigationEditPolicy.this.getHost());
                                this.openLinkCommand = new AbstractTransactionalCommand(editingDomain, "Navigate hyperlink", null){

                                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                        hyperlinkObject.openLink();
                                        return CommandResult.newOKCommandResult();
                                    }
                                };
                                this.openLinkCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ServiceException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        } else {
                            hyperlinkObject.openLink();
                        }
                    }

                    public void undo() {
                        if (this.openLinkCommand != null && this.openLinkCommand.canUndo()) {
                            try {
                                this.openLinkCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }

                    public void redo() {
                        if (this.openLinkCommand != null && this.openLinkCommand.canRedo()) {
                            try {
                                this.openLinkCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }
                };
                return command;
            }
            if (defaultHyperLinkObject.size() > 1) {
                EditorNavigationDialog diagramNavigationDialog = new EditorNavigationDialog(this.getHost().getViewer().getControl().getShell(), defaultHyperLinkObject, semanticElement);
                diagramNavigationDialog.open();
                final List hList = diagramNavigationDialog.getSelectedHyperlinks();
                Command command = new Command("Navigate hyperlinks"){
                    private CompositeCommand openLinksCommand;

                    public void execute() {
                        Iterator iter = hList.iterator();
                        this.openLinksCommand = new CompositeCommand("Navigate hyperlinks");
                        try {
                            TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)NavigationEditPolicy.this.getHost());
                            while (iter.hasNext()) {
                                final HyperLinkObject hyperlinkObject = (HyperLinkObject)iter.next();
                                if (hyperlinkObject.needsOpenCommand()) {
                                    AbstractTransactionalCommand navigateCommand = new AbstractTransactionalCommand(editingDomain, "Navigate hyperlink", null){

                                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                            hyperlinkObject.openLink();
                                            return CommandResult.newOKCommandResult();
                                        }
                                    };
                                    this.openLinksCommand.add((IUndoableOperation)navigateCommand);
                                    continue;
                                }
                                hyperlinkObject.openLink();
                            }
                            if (this.openLinksCommand.isEmpty()) {
                                return;
                            }
                            this.openLinksCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ServiceException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                    }

                    public void undo() {
                        if (this.openLinksCommand != null && this.openLinksCommand.canUndo()) {
                            try {
                                this.openLinksCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }

                    public void redo() {
                        if (this.openLinksCommand != null && this.openLinksCommand.canRedo()) {
                            try {
                                this.openLinksCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }
                };
                return command;
            }
        }
        catch (Exception e) {
            Activator.log.error("Impossible to load hyperlinks", (Throwable)e);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }
}

