/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleObservableValue
extends AbstractObservableValue
implements AggregatedObservable,
IChangeListener {
    protected List<IObservableValue> observableValues = new LinkedList<IObservableValue>();

    public MultipleObservableValue(Collection<IObservableValue> values) {
        if (values != null) {
            this.observableValues.addAll(values);
        }
    }

    public MultipleObservableValue() {
    }

    public Object getValueType() {
        if (this.observableValues.isEmpty()) {
            return null;
        }
        return this.observableValues.get(0).getValueType();
    }

    protected Object doGetValue() {
        if (this.hasDifferentValues() || this.observableValues.isEmpty()) {
            return null;
        }
        return this.observableValues.get(0).getValue();
    }

    private boolean equals(Object value, Object currentValue) {
        if (value == currentValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(currentValue);
    }

    protected void doSetValue(Object value) {
        for (IObservableValue observable : this.observableValues) {
            observable.setValue(value);
        }
    }

    @Override
    public AggregatedObservable aggregate(IObservable observable) {
        if (observable instanceof IObservableValue) {
            this.observableValues.add((IObservableValue)observable);
            observable.addChangeListener((IChangeListener)this);
            return this;
        }
        return null;
    }

    public List<IObservableValue> getObservableValues() {
        return this.observableValues;
    }

    public List<Object> getObservedValues() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (IObservableValue value : this.getObservableValues()) {
            result.add(value.getValue());
        }
        return result;
    }

    public synchronized void dispose() {
        super.dispose();
        for (IObservableValue observable : this.observableValues) {
            observable.removeChangeListener((IChangeListener)this);
            observable.dispose();
        }
    }

    @Override
    public boolean hasDifferentValues() {
        if (this.observableValues.isEmpty()) {
            return false;
        }
        Object currentValue = null;
        boolean firstValue = true;
        for (IObservableValue observable : this.observableValues) {
            if (firstValue) {
                firstValue = false;
                currentValue = observable.getValue();
                continue;
            }
            Object value = observable.getValue();
            if (this.equals(value, currentValue)) continue;
            return true;
        }
        return false;
    }

    public void handleChange(ChangeEvent event) {
        super.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return true;
            }

            public Object getNewValue() {
                return false;
            }
        });
    }
}

