/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.resourceloading.Activator;
import org.eclipse.papyrus.infra.services.resourceloading.preferences.CorePlugin;
import org.eclipse.papyrus.infra.services.resourceloading.util.LoadingUtils;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadedAuthorizedResourceManager
implements IPropertyChangeListener {
    private static final String LOADED_AUTHORIZED_RESOURCE_ELEMENT_ID = "loadedAuthorizedResource";
    private static final String URI_ID = "uri";
    private static final String PREFERENCE_PREFIX = "loadedAuthorizedResource.";
    public static final String URI_PREF_PREFIX = "loadedAuthorizedResource.uri.";
    private static final String pluginId = "org.eclipse.papyrus.infra.services.resourceloading.preferences";
    private IPreferenceStore prefStore = CorePlugin.getDefault().getPreferenceStore();
    private IPreferenceStore projectPrefStore;
    private Map<String, LoadedAuthorizedResource> loadedAuthorizedResources = null;
    private Set<URI> loadedAuthorizedResourcesSet = null;

    public static LoadedAuthorizedResourceManager getInstance() {
        return Holder.instance;
    }

    public LoadedAuthorizedResourceManager() {
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public synchronized Map<String, LoadedAuthorizedResource> getLoadedAuthorizedResources() {
        this.readAuthorizedResources();
        return this.loadedAuthorizedResources;
    }

    public synchronized Set<URI> getLoadedAuthorizedResourcesSet(ModelSet modelSet) {
        this.readAuthorizedResources(modelSet);
        return this.loadedAuthorizedResourcesSet;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        String[] newURIs;
        Object newValue = event.getNewValue();
        if (event.getProperty().startsWith(URI_PREF_PREFIX) && newValue instanceof String && (newURIs = this.parseString((String)newValue)).length > 0) {
            int i = 0;
            while (i < newURIs.length) {
                String newURI = newURIs[i];
                if (!this.getLoadedAuthorizedResources().containsKey(newURI)) {
                    this.getLoadedAuthorizedResources().put(newURI, new LoadedAuthorizedResource(URI.createURI((String)newURI)));
                }
                ++i;
            }
        }
    }

    private void readAuthorizedResources(ModelSet modelSet) {
        IModel mainDiModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
        URI mainUri = null;
        if (mainDiModel instanceof AbstractBaseModel) {
            AbstractBaseModel resourceMainModel = (AbstractBaseModel)mainDiModel;
            mainUri = resourceMainModel.getResourceURI();
        }
        if (this.loadedAuthorizedResourcesSet == null) {
            this.loadedAuthorizedResourcesSet = new HashSet<URI>();
        }
        if (this.loadedAuthorizedResources == null) {
            this.loadedAuthorizedResources = new HashMap<String, LoadedAuthorizedResource>();
        }
        this.loadedAuthorizedResources.clear();
        this.loadedAuthorizedResourcesSet.clear();
        IFile currentFile = LoadingUtils.getFile((URI)mainUri);
        if (currentFile != null) {
            IProject project = currentFile.getProject();
            IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
            if (project != null && root != null) {
                try {
                    if (root.node("project").node(project.getName()).nodeExists(pluginId)) {
                        this.projectPrefStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), pluginId);
                        String s = this.projectPrefStore.getString(URI_PREF_PREFIX);
                        String[] array = this.parseString(s);
                        int i = 0;
                        while (i < array.length) {
                            URI uri = URI.createURI((String)array[i]);
                            this.loadedAuthorizedResources.put(uri.toString(), new LoadedAuthorizedResource(uri));
                            this.loadedAuthorizedResourcesSet.add(uri);
                            ++i;
                        }
                    }
                }
                catch (BackingStoreException e) {
                    Activator.logError((Exception)((Object)e));
                }
            }
        }
        String s = this.prefStore.getString(URI_PREF_PREFIX);
        String[] array = this.parseString(s);
        int i = 0;
        while (i < array.length) {
            URI uri = URI.createURI((String)array[i]);
            this.loadedAuthorizedResources.put(uri.toString(), new LoadedAuthorizedResource(uri));
            this.loadedAuthorizedResourcesSet.add(uri);
            ++i;
        }
    }

    private void readAuthorizedResources() {
        if (this.loadedAuthorizedResources == null) {
            this.loadedAuthorizedResources = new HashMap<String, LoadedAuthorizedResource>();
        }
        this.loadedAuthorizedResources.clear();
        String s = this.projectPrefStore == null ? this.prefStore.getString(URI_PREF_PREFIX) : this.projectPrefStore.getString(URI_PREF_PREFIX);
        String[] array = this.parseString(s);
        int i = 0;
        while (i < array.length) {
            URI uri = URI.createURI((String)array[i]);
            this.loadedAuthorizedResources.put(uri.toString(), new LoadedAuthorizedResource(uri));
            ++i;
        }
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<Object> v = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    private static class Holder {
        static final LoadedAuthorizedResourceManager instance = new LoadedAuthorizedResourceManager();

        private Holder() {
        }
    }

    public static class LoadedAuthorizedResource {
        private URI uri;

        public LoadedAuthorizedResource(URI uri) {
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LoadedAuthorizedResource && this.uri != null) {
                return this.uri.equals(((LoadedAuthorizedResource)obj).uri);
            }
            return false;
        }

        public int hashCode() {
            if (this.uri != null) {
                return this.uri.hashCode();
            }
            return 0;
        }
    }
}

