/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.messages.Messages;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalContentsUtils {
    public static final String ADDITIONAL_CONTENTS_EPCKAGE_NAME = "AdditionalContentsForTable";
    public static final String ADDITIONAL_CONTENTS_EPACKAGE_NS_URI = "http://www.eclipse.org/papyrustable/additionalcontentsepackage";
    public static final String ADDITIONAL_CONTENTS_EPACKAGE_PREFIX = "additionalcontentsepackage";
    public static final String ADDITIONAL_CONTENTS_FACET_SET_DOCUMENTATION = Messages.AdditionalContentsUtils_ProfileEFacetDescription;
    public static final String ADDITIONAL_CONTENTS_QUERY_SET_NAME = "AdditionalContentsModelQuerySetForTable";

    private AdditionalContentsUtils() {
    }

    public static EPackage createAdditionalContentsEPackage() {
        EPackage additionFeatureRootFacetSet = EcoreFactory.eINSTANCE.createEPackage();
        additionFeatureRootFacetSet.setName(ADDITIONAL_CONTENTS_EPCKAGE_NAME);
        additionFeatureRootFacetSet.setNsPrefix(ADDITIONAL_CONTENTS_EPACKAGE_PREFIX);
        additionFeatureRootFacetSet.setNsURI(ADDITIONAL_CONTENTS_EPACKAGE_NS_URI);
        return additionFeatureRootFacetSet;
    }

    public static EPackage getAdditionalContentsEPackage(PapyrusTableInstance table) {
        EPackage ePackage = null;
        ModelSet modelSet = (ModelSet)table.eResource().getResourceSet();
        Resource resource = modelSet.getAssociatedResource(table.eResource(), "notation", true);
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext() && ePackage == null) {
            EPackage tmp;
            EObject current = (EObject)iter.next();
            if (!(current instanceof EPackage) || !ADDITIONAL_CONTENTS_EPACKAGE_NS_URI.equals((tmp = (EPackage)current).getNsURI())) continue;
            ePackage = tmp;
        }
        return ePackage;
    }

    public static EPackage getAdditionalContentsEPackage(Resource source) {
        if (source != null) {
            EPackage additionalSet = null;
            Iterator iter = source.getContents().iterator();
            while (iter.hasNext() && additionalSet == null) {
                EObject contents = (EObject)iter.next();
                if (!(contents instanceof EPackage) || !ADDITIONAL_CONTENTS_EPACKAGE_NS_URI.equals(((EPackage)contents).getNsURI())) continue;
                additionalSet = (EPackage)contents;
            }
            return additionalSet;
        }
        return null;
    }

    public static final Collection<ProfileFacetSet> getAllProfileFacetSets(ResourceSet resourceSet) {
        HashSet<ProfileFacetSet> facetSets = new HashSet<ProfileFacetSet>();
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)resourceSet);
        for (Resource current : resourceSet.getResources()) {
            EPackage additionalContentsEPackage;
            if (!"notation".equals(current.getURI().fileExtension()) || domain.isReadOnly(current) || (additionalContentsEPackage = AdditionalContentsUtils.getAdditionalContentsEPackage(current)) == null) continue;
            for (EPackage currentEPackage : additionalContentsEPackage.getESubpackages()) {
                if (!(currentEPackage instanceof ProfileFacetSet)) continue;
                facetSets.add((ProfileFacetSet)currentEPackage);
            }
        }
        return facetSets;
    }

    public static final Collection<ProfileFacetSet> getAllFacetSet(Profile profile) {
        String profileID = profile.eResource().getURIFragment((EObject)profile);
        HashSet<ProfileFacetSet> facetSets = new HashSet<ProfileFacetSet>();
        ResourceSet resourceSet = profile.eResource().getResourceSet();
        Collection<ProfileFacetSet> allExistingFacetSets = AdditionalContentsUtils.getAllProfileFacetSets(resourceSet);
        for (ProfileFacetSet current : allExistingFacetSets) {
            if (!profileID.equals(current.getRepresentedElement_XMI_ID())) continue;
            facetSets.add(current);
        }
        return facetSets;
    }

    public static final Collection<StereotypeFacet> getAllStereotypeFacets(ProfileFacetSet profileFacetSet) {
        HashSet<StereotypeFacet> facets = new HashSet<StereotypeFacet>();
        for (ProfileFacetSet current : profileFacetSet.getSubProfileFacetSet()) {
            facets.addAll(AdditionalContentsUtils.getAllStereotypeFacets(current));
        }
        facets.addAll((Collection<StereotypeFacet>)profileFacetSet.getStereotypeFacets());
        return facets;
    }

    public static final boolean areAllFacetSetUniqueByResource(ResourceSet resourceSet) {
        HashMap XMI_ID_Resource = new HashMap();
        Collection<ProfileFacetSet> allExistingProfileFacetSet = AdditionalContentsUtils.getAllProfileFacetSets(resourceSet);
        for (ProfileFacetSet profileFacetSet : allExistingProfileFacetSet) {
            String id = profileFacetSet.getRepresentedElement_XMI_ID();
            if (XMI_ID_Resource.containsKey(id)) {
                if (((Collection)XMI_ID_Resource.get(id)).contains(profileFacetSet.eResource())) {
                    return false;
                }
            } else {
                ArrayList res = new ArrayList();
                XMI_ID_Resource.put(id, res);
            }
            ((Collection)XMI_ID_Resource.get(id)).add(profileFacetSet.eResource());
        }
        return true;
    }

    public static final ProfileFacetSet findProfileFacetSet(Profile profile, EPackage additionalResourceEPackage) {
        XMIResource resource = (XMIResource)profile.eResource();
        String profileID = resource.getID((EObject)profile);
        for (EPackage current : additionalResourceEPackage.getESubpackages()) {
            if (!(current instanceof ProfileFacetSet) || !profileID.equals(((ProfileFacetSet)current).getRepresentedElement_XMI_ID())) continue;
            return (ProfileFacetSet)current;
        }
        return null;
    }
}

