/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.views.properties.Activator;

public class EMFURLStreamHandler
extends URLStreamHandler {
    private final URIConverter uriConverter;

    public EMFURLStreamHandler(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        return new EMFURLConnection(u, this.uriConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EMFURLConnection
    extends URLConnection {
        private final URIConverter uriConverter;
        private final URI uri;
        private Map<String, ?> contentDescription;
        private boolean connected;
        private InputStream input;

        protected EMFURLConnection(URL url, URIConverter uriConverter) {
            super(url);
            this.uriConverter = uriConverter;
            this.uri = URI.createURI((String)url.toExternalForm(), (boolean)true);
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                try {
                    this.input = this.uriConverter.getURIHandler(this.uri).createInputStream(this.uri, this.createInputStreamOptions());
                    this.connected = true;
                }
                catch (Exception e) {
                    throw new IOException("Failed to connect: " + e.getMessage());
                }
            }
        }

        @Override
        public String getContentEncoding() {
            return (String)this.getContentDescription().get("org.eclipse.core.runtime:charset");
        }

        @Override
        public String getContentType() {
            return (String)this.getContentDescription().get("org.eclipse.emf.ecore:contentType");
        }

        @Override
        public int getContentLength() {
            return -1;
        }

        @Override
        public boolean getDoInput() {
            return true;
        }

        @Override
        public boolean getDoOutput() {
            return false;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            return this.input;
        }

        private Map<String, ?> getContentDescription() {
            if (this.contentDescription == null) {
                try {
                    this.contentDescription = this.uriConverter.getURIHandler(this.uri).contentDescription(this.uri, this.getContentDescriptionOptions());
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                    this.contentDescription = Collections.emptyMap();
                }
            }
            return this.contentDescription;
        }

        private Map<Object, Object> createInputStreamOptions() {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            result.put("RESPONSE", new HashMap());
            return result;
        }

        private Map<?, ?> getContentDescriptionOptions() {
            HashSet<String> requestedProperties = new HashSet<String>();
            requestedProperties.add("org.eclipse.emf.ecore:contentType");
            requestedProperties.add("org.eclipse.core.runtime:charset");
            return Collections.singletonMap("REQUESTED_PROPERTIES", requestedProperties);
        }
    }
}

