/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.widgets;

import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.EmbeddedDisplayEngine;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MultiReferenceEditorWithPropertyView
extends AbstractListEditor
implements ISelectionChangedListener {
    protected MultipleReferenceEditor multiReferenceEditor;
    protected Composite propertiesComposite;
    protected EmbeddedDisplayEngine displayEngine = new EmbeddedDisplayEngine();

    public MultiReferenceEditorWithPropertyView(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.multiReferenceEditor = this.createMultipleReferenceEditor(style);
        this.multiReferenceEditor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.multiReferenceEditor.setLayoutData((Object)new GridData(1, 4, false, true));
        this.propertiesComposite = new Composite((Composite)this, style);
        this.propertiesComposite.setLayout((Layout)new FillLayout());
        this.propertiesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected MultipleReferenceEditor createMultipleReferenceEditor(int style) {
        return new MultipleReferenceEditor((Composite)this, style);
    }

    public GridData getDefaultLayoutData() {
        GridData data = super.getDefaultLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        return data;
    }

    public Object getEditableType() {
        return Object.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.multiReferenceEditor.setReadOnly(readOnly);
        this.propertiesComposite.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return this.multiReferenceEditor.isReadOnly();
    }

    public void setToolTipText(String text) {
        this.multiReferenceEditor.setToolTipText(text);
    }

    public void setLabel(String label) {
        this.multiReferenceEditor.setLabel(label);
    }

    public void setOrdered(boolean ordered) {
        this.multiReferenceEditor.setOrdered(ordered);
    }

    public void setUnique(boolean unique) {
        this.multiReferenceEditor.setUnique(unique);
    }

    public void setModelObservable(IObservableList modelObservable) {
        this.multiReferenceEditor.setModelObservable(modelObservable);
    }

    public void dispose() {
        super.dispose();
        this.multiReferenceEditor.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Set<View> views = ConfigurationManager.instance.constraintEngine.getViews(selection);
        this.displayEngine.display(views, this.propertiesComposite, selection, 0);
        this.layout();
        this.propertiesComposite.layout();
        this.getParent().layout();
        this.getParent().getParent().getParent().getParent().layout();
    }

    public void setFactory(ReferenceValueFactory valueFactory) {
        this.multiReferenceEditor.setFactory(valueFactory);
    }

    public void setDirectCreation(boolean directCreation) {
        this.multiReferenceEditor.setDirectCreation(directCreation);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.multiReferenceEditor.setLabelProvider(labelProvider);
    }

    public void addCommitListener(ICommitListener commitListener) {
        this.multiReferenceEditor.addCommitListener(commitListener);
    }
}

