/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.widgets;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StringEditorWithReferences
extends StringEditor
implements SelectionListener {
    protected Composite buttonsBar;
    protected Button insertReferenceButton;
    protected IStaticContentProvider referenceContentProvider = EmptyContentProvider.instance;
    protected ILabelProvider labelProvider = new LabelProvider();
    protected TextReferencesHelper referenceHelper;

    public StringEditorWithReferences(Composite parent, int style) {
        super(parent, style | 2);
        this.setLayout((Layout)new GridLayout(2, false));
        this.createButtonsBar((Composite)this);
    }

    protected GridData getDefaultLayoutData() {
        GridData defaultData = super.getDefaultLayoutData();
        defaultData.horizontalSpan = 2;
        return defaultData;
    }

    protected void createButtonsBar(Composite wrapper) {
        this.buttonsBar = new Composite(wrapper, 0);
        GridLayout buttonsBarLayout = new GridLayout(1, true);
        buttonsBarLayout.marginWidth = 0;
        buttonsBarLayout.marginHeight = 0;
        this.buttonsBar.setLayout((Layout)buttonsBarLayout);
        this.buttonsBar.setLayoutData((Object)new GridData(4, 1, true, false));
        this.buttonsBar.moveAbove((Control)this.label);
        this.createButtons(this.buttonsBar);
    }

    protected void createButtons(Composite buttonsBar) {
        this.createInsertReferenceButton(buttonsBar);
    }

    protected void createInsertReferenceButton(Composite buttonsBar) {
        this.insertReferenceButton = new Button(buttonsBar, 8);
        this.insertReferenceButton.setToolTipText("Insert a dynamic reference to an Element");
        this.insertReferenceButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/hyperlink_16x16.gif"));
        this.insertReferenceButton.addSelectionListener((SelectionListener)this);
        this.insertReferenceButton.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
    }

    public void setReferenceBrowserContentProvider(IStaticContentProvider provider) {
        this.referenceContentProvider = provider;
    }

    public void setTextReferencesHelper(TextReferencesHelper helper) {
        this.referenceHelper = helper;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.insertReferenceButton) {
            this.insertReferenceAction();
        }
    }

    protected void insertReferenceAction() {
        if (this.referenceHelper == null) {
            Activator.log.warn("This widget is not properly configured. It cannot handle reference insertion");
            return;
        }
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)this.referenceContentProvider));
        dialog.setLabelProvider(this.labelProvider);
        if (dialog.open() == 0) {
            int caretPosition;
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                return;
            }
            Object resultElement = result[0];
            if (!(resultElement instanceof EObject)) {
                return;
            }
            EObject objectToReference = (EObject)resultElement;
            String currentText = this.text.getText();
            String newText = this.referenceHelper.insertReference(objectToReference, currentText, caretPosition = this.text.getCaretPosition());
            if (newText.length() == currentText.length()) {
                return;
            }
            int caretShift = newText.length() - currentText.length();
            int newCaretPosition = caretPosition + caretShift;
            if (newCaretPosition < 0) {
                newCaretPosition = 0;
            }
            if (newCaretPosition > newText.length()) {
                newCaretPosition = newText.length();
            }
            this.text.setText(newText);
            this.text.setFocus();
            this.text.setSelection(newCaretPosition);
            this.commit();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

