/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.profile;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.standard.ExtensionIds;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;

public class RegisteredProfile
extends RegisteredElementExtensionPoint {
    private static final String TAG_PROFILE = "profile";
    private static RegisteredProfile[] registeredProfiles;
    private static final String ATT_QUALIFIED_NAMES = "qualifiednames";

    public RegisteredProfile(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
        this.qualifiednames = RegisteredProfile.getAttribute(configElt, ATT_QUALIFIED_NAMES, "", false);
    }

    public static RegisteredProfile getRegisteredProfile(String name) {
        return RegisteredProfile.getRegisteredProfile(name, null);
    }

    public static RegisteredProfile getRegisteredProfile(String name, String path) {
        Assert.isNotNull((Object)name);
        RegisteredProfile[] profiles = RegisteredProfile.getRegisteredProfiles();
        int i = 0;
        while (i < profiles.length) {
            RegisteredProfile profile = profiles[i];
            if (name.equals(profile.name)) {
                if (path == null) {
                    return profile;
                }
                if (path.equals(profile.path)) {
                    return profile;
                }
            }
            ++i;
        }
        return null;
    }

    public static RegisteredProfile[] getRegisteredProfiles() {
        if (registeredProfiles != null) {
            return registeredProfiles;
        }
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionIds.PROFILE_EXTENSION_ID);
        int j = 0;
        while (j < configElements.length) {
            RegisteredProfile proxy = RegisteredProfile.parseProfileExtension(configElements[j], profiles.size());
            if (proxy != null) {
                profiles.add(proxy);
            }
            ++j;
        }
        registeredProfiles = profiles.toArray(new RegisteredProfile[profiles.size()]);
        return registeredProfiles;
    }

    private static RegisteredProfile parseProfileExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_PROFILE.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredProfile(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load profile named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

